/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.autoplay.client.nodes;

import com.google.gwt.place.shared.Place;
import com.google.web.bindery.event.shared.Event;
import com.sap.sailing.domain.common.RaceIdentifier;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.dto.AbstractLeaderboardDTO;
import com.sap.sailing.domain.common.dto.FleetDTO;
import com.sap.sailing.domain.common.dto.RaceColumnDTO;
import com.sap.sailing.gwt.autoplay.client.app.AutoPlayClientFactory;
import com.sap.sailing.gwt.autoplay.client.events.AutoPlayHeaderEvent;
import com.sap.sailing.gwt.autoplay.client.nodes.base.FiresPlaceNode;
import com.sap.sailing.gwt.autoplay.client.places.screens.idleloop.idleupnext.IdleUpNextPlace;
import com.sap.sailing.gwt.autoplay.client.utils.AutoplayHelper;
import com.sap.sailing.gwt.ui.client.RaceTimesInfoProvider;
import com.sap.sailing.gwt.ui.client.RaceTimesInfoProviderListener;
import com.sap.sailing.gwt.ui.shared.EventDTO;
import com.sap.sailing.gwt.ui.shared.RaceTimesInfoDTO;
import com.sap.sailing.gwt.ui.shared.StrippedLeaderboardDTO;
import com.sap.sse.common.Util;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;

public class IdleUpNextNode
extends FiresPlaceNode {
    private final AutoPlayClientFactory cf;
    private IdleUpNextPlace place;
    private RaceTimesInfoProvider raceTimesInfoProvider;

    public IdleUpNextNode(AutoPlayClientFactory cf) {
        super(IdleUpNextNode.class.getName());
        this.cf = cf;
        this.place = new IdleUpNextPlace();
    }

    public void onStart() {
        String eventName = this.cf.getAutoPlayCtxSignalError().getEvent().getName();
        this.getBus().fireEvent((Event)new AutoPlayHeaderEvent(eventName, ""));
        this.setPlaceToGo((Place)this.place);
        this.firePlaceChangeAndStartTimer();
        this.createRaceTimeInfoProvider();
    }

    public void onStop() {
        this.raceTimesInfoProvider.terminate();
        super.onStop();
    }

    private void createRaceTimeInfoProvider() {
        this.raceTimesInfoProvider = new RaceTimesInfoProvider(this.cf.getSailingService(), AutoplayHelper.asyncActionsExecutor, this.cf.getErrorReporter(), new ArrayList(), 10000L);
        StrippedLeaderboardDTO selectedLeaderboard = AutoplayHelper.getSelectedLeaderboard((EventDTO)this.cf.getAutoPlayCtxSignalError().getEvent(), (String)this.cf.getAutoPlayCtxSignalError().getContextDefinition().getLeaderboardName());
        if (selectedLeaderboard != null) {
            for (RaceColumnDTO race : selectedLeaderboard.getRaceList()) {
                for (FleetDTO fleet : race.getFleets()) {
                    RegattaAndRaceIdentifier raceIdentifier = race.getRaceIdentifier(fleet);
                    if (raceIdentifier == null || this.raceTimesInfoProvider.containsRaceIdentifier((RaceIdentifier)raceIdentifier)) continue;
                    this.raceTimesInfoProvider.addRaceIdentifier(raceIdentifier, false);
                }
            }
        }
        this.raceTimesInfoProvider.forceTimesInfosUpdate();
        this.raceTimesInfoProvider.addRaceTimesInfoProviderListener((RaceTimesInfoProviderListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static void checkForRaceStarts(AbstractLeaderboardDTO currentLeaderboard, Date serverTimeDuringRequest, RaceTimesInfoProvider raceTimesInfoProvider, ArrayList<Util.Pair<RegattaAndRaceIdentifier, Date>> raceToStartOfRace) {
        Map raceTimesInfos = raceTimesInfoProvider.getRaceTimesInfos();
        for (RaceColumnDTO race : currentLeaderboard.getRaceList()) {
            for (FleetDTO fleet : race.getFleets()) {
                RaceTimesInfoDTO raceTimes;
                RegattaAndRaceIdentifier raceIdentifier = race.getRaceIdentifier(fleet);
                if (raceIdentifier == null || (raceTimes = (RaceTimesInfoDTO)raceTimesInfos.get(raceIdentifier)) == null || raceTimes.startOfTracking == null || raceTimes.getStartOfRace() == null || raceTimes.endOfRace != null) continue;
                raceToStartOfRace.add((Util.Pair<RegattaAndRaceIdentifier, Date>)new Util.Pair((Object)raceIdentifier, (Object)raceTimes.getStartOfRace()));
            }
        }
    }

    static /* synthetic */ RaceTimesInfoProvider access$0(IdleUpNextNode idleUpNextNode) {
        return idleUpNextNode.raceTimesInfoProvider;
    }

    static /* synthetic */ IdleUpNextPlace access$1(IdleUpNextNode idleUpNextNode) {
        return idleUpNextNode.place;
    }
}

