/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.impl;

import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.RaceLogFlagEvent;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.AbortingFlagFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.FinishedTimeFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.LastFlagsFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceLogResolver;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.StartTimeFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.StartTimeFinderResult;
import com.sap.sailing.domain.abstractlog.race.state.ReadonlyRaceState;
import com.sap.sailing.domain.abstractlog.race.state.impl.ReadonlyRaceStateImpl;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.gate.ReadonlyGateStartRacingProcedure;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.common.RaceIdentifier;
import com.sap.sailing.domain.common.racelog.RaceLogRaceStatus;
import com.sap.sailing.domain.racelog.RaceStateOfSameDayHelper;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.shared.json.JsonSerializer;
import java.util.Calendar;
import java.util.List;
import org.json.simple.JSONObject;

public class RaceStateSerializer
implements JsonSerializer<Util.Pair<RaceColumn, Fleet>> {
    private final RaceLogResolver raceLogResolver;

    public RaceStateSerializer(RaceLogResolver raceLogResolver) {
        this.raceLogResolver = raceLogResolver;
    }

    public JSONObject serialize(Util.Pair<RaceColumn, Fleet> raceColumnAndFleet) {
        RaceColumn raceColumn = (RaceColumn)raceColumnAndFleet.getA();
        Fleet fleet = (Fleet)raceColumnAndFleet.getB();
        JSONObject result = new JSONObject();
        result.put((Object)"raceName", (Object)raceColumn.getName());
        result.put((Object)"fleetName", (Object)fleet.getName());
        result.put((Object)"trackedRaceLinked", (Object)(raceColumn.getTrackedRace(fleet) != null ? 1 : 0));
        RaceIdentifier raceIdentifier = raceColumn.getRaceIdentifier(fleet);
        result.put((Object)"trackedRaceName", (Object)(raceIdentifier != null ? raceIdentifier.getRaceName() : null));
        result.put((Object)"trackedRaceId", (Object)(raceIdentifier != null ? raceIdentifier.toString() : null));
        RaceLog raceLog = raceColumn.getRaceLog(fleet);
        if (raceLog != null && !raceLog.isEmpty()) {
            ReadonlyRaceState state = ReadonlyRaceStateImpl.getOrCreate((RaceLogResolver)this.raceLogResolver, (RaceLog)raceLog);
            RaceLogRaceStatus status = state.getStatus();
            TimePoint startTime = state.getStartTime();
            TimePoint finishedTime = state.getFinishedTime();
            JSONObject raceLogStateJson = new JSONObject();
            result.put((Object)"raceState", (Object)raceLogStateJson);
            raceLogStateJson.put((Object)"startTime", (Object)(startTime != null ? startTime.toString() : null));
            raceLogStateJson.put((Object)"endTime", (Object)(finishedTime != null ? finishedTime.toString() : null));
            raceLogStateJson.put((Object)"lastStatus", (Object)status.name());
            ReadonlyGateStartRacingProcedure procedure = (ReadonlyGateStartRacingProcedure)state.getTypedReadonlyRacingProcedure(ReadonlyGateStartRacingProcedure.class);
            if (procedure != null) {
                raceLogStateJson.put((Object)"pathfinderId", (Object)procedure.getPathfinder());
                raceLogStateJson.put((Object)"gateLineOpeningTime", (Object)procedure.getGateLaunchStopTime());
            }
            AbortingFlagFinder abortingFlagFinder = new AbortingFlagFinder(raceLog);
            RaceLogFlagEvent abortingFlagEvent = (RaceLogFlagEvent)abortingFlagFinder.analyze();
            LastFlagsFinder lastFlagFinder = new LastFlagsFinder(raceLog);
            RaceLogFlagEvent lastFlagEvent = LastFlagsFinder.getMostRecent((List)((List)lastFlagFinder.analyze()));
            if (lastFlagEvent != null) {
                this.setLastFlagField(raceLogStateJson, lastFlagEvent.getUpperFlag().name(), lastFlagEvent.getLowerFlag().name(), lastFlagEvent.isDisplayed());
            } else if (status.equals((Object)RaceLogRaceStatus.UNSCHEDULED) && abortingFlagEvent != null) {
                this.setLastFlagField(raceLogStateJson, abortingFlagEvent.getUpperFlag().name(), abortingFlagEvent.getLowerFlag().name(), abortingFlagEvent.isDisplayed());
            } else {
                this.setLastFlagField(raceLogStateJson, null, null, null);
            }
        }
        return result;
    }

    private void setLastFlagField(JSONObject raceLogStateJson, String upperFlagName, String lowerFlagName, Boolean isDisplayed) {
        raceLogStateJson.put((Object)"lastUpperFlag", (Object)upperFlagName);
        raceLogStateJson.put((Object)"lastLowerFlag", (Object)lowerFlagName);
        raceLogStateJson.put((Object)"displayed", (Object)isDisplayed);
    }

    public boolean isRaceStateOfSameDay(Util.Pair<RaceColumn, Fleet> raceColumnAndFleet, Calendar dayToCheck, Duration clientTimeZoneOffset) {
        RaceColumn raceColumn = (RaceColumn)raceColumnAndFleet.getA();
        Fleet fleet = (Fleet)raceColumnAndFleet.getB();
        boolean result = false;
        RaceLog raceLog = raceColumn.getRaceLog(fleet);
        if (raceLog != null && !raceLog.isEmpty()) {
            TimePoint startTime = ((StartTimeFinderResult)new StartTimeFinder(this.raceLogResolver, raceLog).analyze()).getStartTime();
            TimePoint finishedTime = (TimePoint)new FinishedTimeFinder(raceLog).analyze();
            RaceLogFlagEvent abortingFlagEvent = (RaceLogFlagEvent)new AbortingFlagFinder(raceLog).analyze();
            TimePoint abortingTime = abortingFlagEvent != null ? abortingFlagEvent.getLogicalTimePoint() : null;
            result = RaceStateOfSameDayHelper.isRaceStateOfSameDay((TimePoint)startTime, (TimePoint)finishedTime, (TimePoint)abortingTime, (Calendar)dayToCheck, (Duration)clientTimeZoneOffset);
        }
        return result;
    }
}

