/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.maneuverdetection.CompleteManeuverCurveWithEstimationData;
import com.sap.sailing.domain.maneuverdetection.TrackTimeInfo;
import com.sap.sailing.domain.maneuverdetection.impl.ManeuverDetectorImpl;
import com.sap.sailing.domain.maneuverdetection.impl.ManeuverDetectorWithEstimationDataSupportDecoratorImpl;
import com.sap.sailing.domain.polars.PolarDataService;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.server.gateway.serialization.impl.CompetitorTrackElementsJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.CompleteManeuverCurveWithEstimationDataJsonSerializer;
import com.sap.sse.common.TimePoint;
import java.util.List;
import java.util.stream.Collectors;
import org.json.simple.JSONArray;

public class CompleteManeuverCurvesWithEstimationDataJsonSerializer
implements CompetitorTrackElementsJsonSerializer {
    private final PolarDataService polarDataService;
    private final CompleteManeuverCurveWithEstimationDataJsonSerializer maneuverWithEstimationDataJsonSerializer;

    public CompleteManeuverCurvesWithEstimationDataJsonSerializer(PolarDataService polarDataService, CompleteManeuverCurveWithEstimationDataJsonSerializer maneuverWithEstimationDataJsonSerializer) {
        this.polarDataService = polarDataService;
        this.maneuverWithEstimationDataJsonSerializer = maneuverWithEstimationDataJsonSerializer;
    }

    @Override
    public JSONArray serialize(TrackedRace trackedRace, Competitor competitor, TimePoint from, TimePoint to, TrackTimeInfo trackTimeInfo) {
        JSONArray completeManeuverCurvesWithEstimationData = new JSONArray();
        Iterable<CompleteManeuverCurveWithEstimationData> completeManeuvers = trackTimeInfo.getTrackStartTimePoint().equals(from) && trackTimeInfo.getTrackEndTimePoint().equals(to) ? this.getCompleteManeuverCurvesWithEstimationData(trackedRace, competitor) : this.getCompleteManeuverCurvesWithEstimationData(trackedRace, competitor, from, to);
        for (CompleteManeuverCurveWithEstimationData maneuver : completeManeuvers) {
            completeManeuverCurvesWithEstimationData.add((Object)this.maneuverWithEstimationDataJsonSerializer.serialize(maneuver));
        }
        return completeManeuverCurvesWithEstimationData;
    }

    private Iterable<CompleteManeuverCurveWithEstimationData> getCompleteManeuverCurvesWithEstimationData(TrackedRace trackedRace, Competitor competitor, TimePoint from, TimePoint to) {
        ManeuverDetectorImpl maneuverDetector = new ManeuverDetectorImpl(trackedRace, competitor);
        List maneuverSpots = maneuverDetector.detectManeuverSpots(from, to);
        List maneuverCurves = maneuverSpots.stream().filter(maneuverSpot -> maneuverSpot.getManeuverCurve() != null).map(maneuverSpot -> maneuverSpot.getManeuverCurve()).collect(Collectors.toList());
        ManeuverDetectorWithEstimationDataSupportDecoratorImpl maneuverDetectorWithEstimationData = new ManeuverDetectorWithEstimationDataSupportDecoratorImpl(maneuverDetector, this.polarDataService);
        List maneuversWithEstimationData = maneuverDetectorWithEstimationData.getCompleteManeuverCurvesWithEstimationData(maneuverCurves);
        return maneuversWithEstimationData;
    }

    private Iterable<CompleteManeuverCurveWithEstimationData> getCompleteManeuverCurvesWithEstimationData(TrackedRace trackedRace, Competitor competitor) {
        Iterable maneuvers = trackedRace.getManeuvers(competitor, false);
        ManeuverDetectorImpl maneuverDetector = new ManeuverDetectorImpl(trackedRace, competitor);
        ManeuverDetectorWithEstimationDataSupportDecoratorImpl maneuverDetectorWithEstimationData = new ManeuverDetectorWithEstimationDataSupportDecoratorImpl(maneuverDetector, this.polarDataService);
        List maneuverCurves = maneuverDetectorWithEstimationData.getCompleteManeuverCurves(maneuvers);
        List maneuversWithEstimationData = maneuverDetectorWithEstimationData.getCompleteManeuverCurvesWithEstimationData((Iterable)maneuverCurves);
        return maneuversWithEstimationData;
    }
}

