/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.deserialization.impl;

import com.sap.sailing.domain.common.DeviceIdentifier;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.server.gateway.deserialization.TypeBasedJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.Helpers;
import com.sap.sailing.server.gateway.serialization.racelog.tracking.GPSFixJsonHandler;
import com.sap.sse.common.TransformationException;
import com.sap.sse.common.TypeBasedServiceFinder;
import com.sap.sse.common.Util;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonDeserializer;
import com.sap.sse.shared.util.impl.UUIDHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class DeviceAndSessionIdentifierWithGPSFixesDeserializer
implements JsonDeserializer<Util.Triple<DeviceIdentifier, Serializable, List<GPSFix>>> {
    public static final String FIELD_DEVICE = "device";
    public static final String FIELD_SESSION_UUID = "sessionId";
    public static final String FIELD_FIXES = "fixes";
    private final TypeBasedServiceFinder<GPSFixJsonHandler> fixServiceFinder;
    private final JsonDeserializer<DeviceIdentifier> deviceDeserializer;

    public DeviceAndSessionIdentifierWithGPSFixesDeserializer(TypeBasedServiceFinder<GPSFixJsonHandler> fixServiceFinder, JsonDeserializer<DeviceIdentifier> deviceDeserializer) {
        this.fixServiceFinder = fixServiceFinder;
        this.deviceDeserializer = deviceDeserializer;
    }

    public Util.Triple<DeviceIdentifier, Serializable, List<GPSFix>> deserialize(JSONObject object) throws JsonDeserializationException {
        JSONObject deviceIdObject = Helpers.toJSONObjectSafe((Object)object.get((Object)FIELD_DEVICE));
        DeviceIdentifier deviceId = (DeviceIdentifier)this.deviceDeserializer.deserialize(deviceIdObject);
        Object sessionObject = object.get((Object)FIELD_SESSION_UUID);
        Serializable sessionId = sessionObject == null ? null : UUIDHelper.tryUuidConversion((Serializable)((Serializable)sessionObject));
        JSONArray fixesJson = Helpers.getNestedArraySafe((JSONObject)object, (String)FIELD_FIXES);
        ArrayList<GPSFix> fixes = new ArrayList<GPSFix>();
        for (Object fixObject : fixesJson) {
            GPSFix fix;
            JSONObject fixJson = (JSONObject)fixObject;
            try {
                fix = (GPSFix)TypeBasedJsonDeserializer.deserialize(this.fixServiceFinder, (JSONObject)fixJson);
            }
            catch (TransformationException e) {
                throw new JsonDeserializationException((Throwable)e);
            }
            fixes.add(fix);
        }
        return new Util.Triple((Object)deviceId, (Object)sessionId, fixes);
    }
}

