/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking.impl;

import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.tracking.TrackedLeg;
import com.sap.sailing.domain.tracking.impl.TrackedRaceImpl;
import com.sap.sse.common.Util;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.LinkedHashSet;

public class TrackedRaceAsWaypointList
extends AbstractList<Waypoint>
implements Serializable {
    private static final long serialVersionUID = 7167163814845413202L;
    private final TrackedRaceImpl trackedRace;

    public TrackedRaceAsWaypointList(TrackedRaceImpl trackedRace) {
        this.trackedRace = trackedRace;
    }

    @Override
    public Waypoint get(int index) {
        Waypoint result;
        Iterable courseWaypoints;
        boolean isConsistentWithCourse;
        int numberOfLegs = Util.size(this.trackedRace.getTrackedLegs());
        boolean bl = isConsistentWithCourse = numberOfLegs == Util.size((Iterable)(courseWaypoints = this.trackedRace.getRace().getCourse().getWaypoints())) - 1;
        if (index > numberOfLegs) {
            result = null;
        } else if (isConsistentWithCourse) {
            result = index == numberOfLegs ? (numberOfLegs == 0 ? this.trackedRace.getWaypoints().iterator().next() : ((TrackedLeg)Util.get(this.trackedRace.getTrackedLegs(), (int)(numberOfLegs - 1))).getLeg().getTo()) : ((TrackedLeg)Util.get(this.trackedRace.getTrackedLegs(), (int)index)).getLeg().getFrom();
        } else {
            LinkedHashSet excessWaypoints = new LinkedHashSet();
            Util.addAll(this.trackedRace.getWaypoints(), excessWaypoints);
            ArrayList waypoints = new ArrayList();
            Util.addAll((Iterable)courseWaypoints, waypoints);
            Util.removeAll((Iterable)courseWaypoints, excessWaypoints);
            waypoints.addAll(excessWaypoints);
            result = (Waypoint)waypoints.get(index);
        }
        return result;
    }

    @Override
    public int size() {
        return Util.size(this.trackedRace.getWaypoints());
    }

    @Override
    public void add(int index, Waypoint element) {
        this.trackedRace.waypointAdded(index, element);
    }

    @Override
    public Waypoint remove(int zeroBasedIndex) {
        Waypoint waypointThatGotRemoved = this.get(zeroBasedIndex);
        if (waypointThatGotRemoved != null) {
            this.trackedRace.waypointRemoved(zeroBasedIndex, waypointThatGotRemoved);
        }
        return waypointThatGotRemoved;
    }
}

