/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking.impl;

import com.sap.sailing.domain.base.SpeedWithBearingWithConfidence;
import com.sap.sailing.domain.base.SpeedWithConfidence;
import com.sap.sailing.domain.base.impl.SpeedWithBearingWithConfidenceImpl;
import com.sap.sailing.domain.base.impl.SpeedWithConfidenceImpl;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.confidence.BearingWithConfidence;
import com.sap.sailing.domain.common.confidence.BearingWithConfidenceCluster;
import com.sap.sailing.domain.common.confidence.ConfidenceBasedAverager;
import com.sap.sailing.domain.common.confidence.ConfidenceFactory;
import com.sap.sailing.domain.common.confidence.HasConfidence;
import com.sap.sailing.domain.common.confidence.Weigher;
import com.sap.sailing.domain.common.confidence.impl.BearingWithConfidenceImpl;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.common.tracking.impl.CompactionNotPossibleException;
import com.sap.sailing.domain.common.tracking.impl.PreciseCompactGPSFixMovingImpl;
import com.sap.sailing.domain.common.tracking.impl.VeryCompactGPSFixMovingImpl;
import com.sap.sailing.domain.tracking.DynamicGPSFixTrack;
import com.sap.sailing.domain.tracking.impl.GPSFixTrackImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Timed;
import com.sap.sse.common.impl.DegreeBearingImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DynamicGPSFixMovingTrackImpl<ItemType>
extends GPSFixTrackImpl<ItemType, GPSFixMoving>
implements DynamicGPSFixTrack<ItemType, GPSFixMoving> {
    private static final Logger logger = Logger.getLogger(DynamicGPSFixMovingTrackImpl.class.getName());
    private static final long serialVersionUID = 9111448573301259784L;
    private static final double MAX_SPEED_FACTOR_COMPARED_TO_MEASURED_SPEED_FOR_FILTERING = 2.0;
    private static final Bearing MAX_COURSE_DIFFERENCE_BETWEEN_MEASURED_AND_COMPUTED_IN_DEGREES = new DegreeBearingImpl(90.0);
    private long numberOfOutliersDueToCOGDiff;
    private long numberOfFixesCheckedForOutlier;

    public DynamicGPSFixMovingTrackImpl(ItemType trackedItem, long millisecondsOverWhichToAverage) {
        this(trackedItem, millisecondsOverWhichToAverage, false);
    }

    public DynamicGPSFixMovingTrackImpl(ItemType trackedItem, long millisecondsOverWhichToAverage, Speed maxSpeedForSmoothening) {
        this(trackedItem, millisecondsOverWhichToAverage, maxSpeedForSmoothening, false);
    }

    public DynamicGPSFixMovingTrackImpl(ItemType trackedItem, long millisecondsOverWhichToAverage, Speed maxSpeedForSmoothening, boolean losslessCompaction) {
        super(trackedItem, millisecondsOverWhichToAverage, maxSpeedForSmoothening, losslessCompaction);
    }

    public DynamicGPSFixMovingTrackImpl(ItemType trackedItem, long millisecondsOverWhichToAverage, boolean losslessCompaction) {
        super(trackedItem, millisecondsOverWhichToAverage, losslessCompaction);
    }

    @Override
    public boolean addGPSFix(GPSFixMoving gpsFix) {
        return this.add(gpsFix, true);
    }

    @Override
    public boolean add(GPSFixMoving fix) {
        return super.add((Timed)fix);
    }

    @Override
    public boolean add(GPSFixMoving fix, boolean replace) {
        PreciseCompactGPSFixMovingImpl compactFix;
        try {
            compactFix = this.isLosslessCompaction() ? new PreciseCompactGPSFixMovingImpl(fix) : new VeryCompactGPSFixMovingImpl(fix);
        }
        catch (CompactionNotPossibleException e) {
            logger.log(Level.FINE, "Couldn't compact fix " + fix + " for track for " + this.getTrackedItem() + ". Using losslessly-compacted fix instead.", e);
            compactFix = new PreciseCompactGPSFixMovingImpl(fix);
        }
        return super.add(compactFix, replace);
    }

    @Override
    protected Position getEstimatedPositionBetweenTwoValidFixes(TimePoint timePoint, GPSFixMoving lastFixAtOrBefore, GPSFixMoving firstFixAtOrAfter) {
        assert (lastFixAtOrBefore != null);
        assert (firstFixAtOrAfter != null);
        assert (!timePoint.before(lastFixAtOrBefore.getTimePoint()));
        assert (!timePoint.after(firstFixAtOrAfter.getTimePoint()));
        SpeedWithBearing estimatedSpeed = this.estimateSpeedOnTimeDifferenceAndDistanceOnly(lastFixAtOrBefore, firstFixAtOrAfter);
        Distance distance = estimatedSpeed.travel(lastFixAtOrBefore.getTimePoint(), timePoint);
        Position result = lastFixAtOrBefore.getPosition().translateGreatCircle(estimatedSpeed.getBearing(), distance);
        return result;
    }

    private SpeedWithBearing estimateSpeedOnTimeDifferenceAndDistanceOnly(GPSFixMoving fix1, GPSFixMoving fix2) {
        assert (fix1 != null && fix2 != null);
        Distance distance = fix1.getPosition().getDistance(fix2.getPosition());
        return new KnotSpeedWithBearingImpl(distance.inTime(fix1.getTimePoint().until(fix2.getTimePoint())).getKnots(), fix1.getPosition().getBearingGreatCircle(fix2.getPosition()));
    }

    @Override
    protected SpeedWithBearingWithConfidence<TimePoint> getEstimatedSpeed(TimePoint at, NavigableSet<GPSFixMoving> fixesToUseForSpeedEstimation, Weigher<TimePoint> weigher) {
        this.lockForRead();
        try {
            SpeedWithBearingWithConfidenceImpl<TimePoint> result;
            KnotSpeedWithBearingImpl avgSpeed;
            List<GPSFixMoving> relevantFixes = this.getFixesRelevantForSpeedEstimation(at, fixesToUseForSpeedEstimation);
            ArrayList<SpeedWithConfidence<TimePoint>> speeds = new ArrayList<SpeedWithConfidence<TimePoint>>();
            BearingWithConfidenceCluster bearingCluster = new BearingWithConfidenceCluster(weigher);
            if (!relevantFixes.isEmpty()) {
                int i = 0;
                GPSFixMoving last = relevantFixes.get(i);
                if (!(last.getSpeed().getBearing().getDegrees() == 0.0 && !(last.getSpeed().getKnots() > 0.0) || this.maxSpeedForSmoothing != null && last.getSpeed().compareTo((Object)this.maxSpeedForSmoothing) > 0)) {
                    SpeedWithConfidenceImpl<TimePoint> speedWithConfidence = new SpeedWithConfidenceImpl<TimePoint>((Speed)last.getSpeed(), 0.9, last.getTimePoint());
                    speeds.add(speedWithConfidence);
                    bearingCluster.add((BearingWithConfidence)new BearingWithConfidenceImpl(last.getSpeed().getBearing(), 0.9, (Object)last.getTimePoint()));
                }
                while (i < relevantFixes.size() - 1) {
                    GPSFixMoving next = relevantFixes.get(++i);
                    this.aggregateSpeedAndBearingFromLastToNext(speeds, (BearingWithConfidenceCluster<TimePoint>)bearingCluster, (GPSFix)last, (GPSFix)next);
                    if (!(last.getSpeed().getBearing().getDegrees() == 0.0 && !(last.getSpeed().getKnots() > 0.0) || this.maxSpeedForSmoothing != null && next.getSpeed().compareTo((Object)this.maxSpeedForSmoothing) > 0)) {
                        SpeedWithConfidenceImpl<TimePoint> computedSpeedWithConfidence = new SpeedWithConfidenceImpl<TimePoint>((Speed)next.getSpeed(), 0.9, next.getTimePoint());
                        speeds.add(computedSpeedWithConfidence);
                        bearingCluster.add((BearingWithConfidence)new BearingWithConfidenceImpl(next.getSpeed().getBearing(), 0.9, (Object)next.getTimePoint()));
                    }
                    last = next;
                }
            }
            ConfidenceBasedAverager speedAverager = ConfidenceFactory.INSTANCE.createAverager(weigher);
            HasConfidence speedWithConfidence = speedAverager.getAverage(speeds, (Object)at);
            BearingWithConfidence bearingAverage = bearingCluster.getAverage((Object)at);
            Bearing bearing = bearingAverage == null ? null : (Bearing)bearingAverage.getObject();
            KnotSpeedWithBearingImpl knotSpeedWithBearingImpl = avgSpeed = speedWithConfidence == null || bearing == null ? null : new KnotSpeedWithBearingImpl(((Speed)speedWithConfidence.getObject()).getKnots(), bearing);
            SpeedWithBearingWithConfidenceImpl<TimePoint> speedWithBearingWithConfidenceImpl = result = speedWithConfidence == null || bearingAverage == null ? null : new SpeedWithBearingWithConfidenceImpl<TimePoint>((SpeedWithBearing)avgSpeed, ((speedWithConfidence == null ? 0.0 : speedWithConfidence.getConfidence()) + (bearingAverage == null ? 0.0 : bearingAverage.getConfidence())) / 2.0, at);
            return speedWithBearingWithConfidenceImpl;
        }
        finally {
            this.unlockAfterRead();
        }
    }

    private double getSmoothenedSpeedRatio(Speed s1, Speed s2) {
        double offsetForSmallSpeedsInKnots = 0.5;
        double speedToPreviousFactor = s1.compareTo((Object)s2) >= 0 ? (s1.getKnots() + 0.5) / (s2.getKnots() + 0.5) : (s2.getKnots() + 0.5) / (s1.getKnots() + 0.5);
        return speedToPreviousFactor;
    }

    @Override
    protected boolean isValid(NavigableSet<GPSFixMoving> rawFixes, GPSFixMoving e) {
        boolean isValid;
        this.assertReadLock();
        if (e.isValidityCached()) {
            isValid = e.isValidCached();
        } else {
            boolean fixHasValidSogAndCog = !(e.getSpeed().getMetersPerSecond() == 0.0 && e.getSpeed().getBearing().getDegrees() == 0.0 || this.maxSpeedForSmoothing != null && e.getSpeed().compareTo((Object)this.maxSpeedForSmoothing) > 0);
            GPSFixMoving previous = rawFixes.lower(e);
            boolean atLeastOnePreviousFixInRange = previous != null && e.getTimePoint().asMillis() - previous.getTimePoint().asMillis() <= this.getMillisecondsOverWhichToAverageSpeed();
            boolean foundValidPreviousFixInRange = false;
            while (previous != null && !foundValidPreviousFixInRange && e.getTimePoint().asMillis() - previous.getTimePoint().asMillis() <= this.getMillisecondsOverWhichToAverageSpeed()) {
                foundValidPreviousFixInRange = this.isValid(previous, e, e, fixHasValidSogAndCog);
                previous = rawFixes.lower(previous);
            }
            boolean foundValidNextFixInRange = false;
            boolean atLeastOneNextFixInRange = false;
            if (!atLeastOnePreviousFixInRange || foundValidPreviousFixInRange) {
                GPSFixMoving next = rawFixes.higher(e);
                atLeastOneNextFixInRange = next != null && next.getTimePoint().asMillis() - e.getTimePoint().asMillis() <= this.getMillisecondsOverWhichToAverageSpeed();
                while (next != null && !foundValidNextFixInRange && next.getTimePoint().asMillis() - e.getTimePoint().asMillis() <= this.getMillisecondsOverWhichToAverageSpeed()) {
                    foundValidNextFixInRange = this.isValid(e, next, e, fixHasValidSogAndCog);
                    next = rawFixes.higher(next);
                }
            }
            isValid = !(atLeastOnePreviousFixInRange && !foundValidPreviousFixInRange || atLeastOneNextFixInRange && !foundValidNextFixInRange);
            e.cacheValidity(isValid);
        }
        return isValid;
    }

    private boolean isValid(GPSFixMoving from, GPSFixMoving to, GPSFixMoving takeCogAndSogFrom, boolean fixHasValidSogAndCog) {
        boolean foundValidPreviousFixInRange;
        SpeedWithBearing speedToNeighbor = from.getSpeedAndBearingRequiredToReach((GPSFix)to);
        boolean failedDueToCOGDiff = false;
        boolean bl = (this.maxSpeedForSmoothing == null || speedToNeighbor.compareTo((Object)this.maxSpeedForSmoothing) <= 0) && (!fixHasValidSogAndCog || this.getSmoothenedSpeedRatio((Speed)speedToNeighbor, (Speed)takeCogAndSogFrom.getSpeed()) <= 2.0 && !(failedDueToCOGDiff = speedToNeighbor.getBearing().getDifferenceTo(takeCogAndSogFrom.getSpeed().getBearing()).abs().compareTo((Object)MAX_COURSE_DIFFERENCE_BETWEEN_MEASURED_AND_COMPUTED_IN_DEGREES) > 0)) ? true : (foundValidPreviousFixInRange = false);
        if (failedDueToCOGDiff) {
            ++this.numberOfOutliersDueToCOGDiff;
            logger.finer(() -> this + ": computed COG " + speedToNeighbor.getBearing() + " differs significantly (by " + speedToNeighbor.getBearing().getDifferenceTo(takeCogAndSogFrom.getSpeed().getBearing()).abs() + ") from reported COG " + takeCogAndSogFrom.getSpeed().getBearing() + "; time points: " + from.getTimePoint() + " / " + to.getTimePoint());
        } else if (!foundValidPreviousFixInRange) {
            logger.finer(() -> this + ": invalid fix " + to + " due to smoothened speed ratio " + this.getSmoothenedSpeedRatio((Speed)speedToNeighbor, (Speed)takeCogAndSogFrom.getSpeed()) + " greater or equal threshold " + 2.0);
        }
        ++this.numberOfFixesCheckedForOutlier;
        return foundValidPreviousFixInRange;
    }

    @Override
    public void setMillisecondsOverWhichToAverage(long millisecondsOverWhichToAverage) {
        super.setMillisecondsOverWhichToAverage(millisecondsOverWhichToAverage);
    }
}

