/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.ranking;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Leg;
import com.sap.sailing.domain.base.SpeedWithConfidence;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.ranking.AbstractRankingMetric;
import com.sap.sailing.domain.ranking.RankingMetric;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.TrackedLegOfCompetitor;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class NonPerformanceCurveRankingMetric
extends AbstractRankingMetric {
    private static final long serialVersionUID = 2647817114244817444L;

    protected NonPerformanceCurveRankingMetric(TrackedRace trackedRace) {
        super(trackedRace);
    }

    protected abstract Duration getCalculatedTime(Competitor var1, Supplier<Leg> var2, Supplier<Position> var3, Duration var4, Distance var5);

    @Override
    public RankingMetric.RankingInfo getRankingInfo(TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        HashMap<Competitor, RankingMetric.CompetitorRankingInfo> result = new HashMap<Competitor, RankingMetric.CompetitorRankingInfo>();
        Competitor competitorFarthestAhead = this.getCompetitorFarthestAhead(timePoint, cache);
        if (competitorFarthestAhead != null) {
            Distance totalWindwardDistanceTraveled = this.getWindwardDistanceTraveled(competitorFarthestAhead, timePoint, cache);
            TimePoint startOfRace = this.getTrackedRace().getStartOfRace();
            if (startOfRace != null) {
                Duration durationSinceStartOfRaceUntilTimePoint = startOfRace.until(timePoint);
                Waypoint finish = this.getTrackedRace().getRace().getCourse().getLastWaypoint();
                for (Competitor competitor : this.getCompetitors()) {
                    MarkPassing finishMarkPassing = finish == null ? null : this.getTrackedRace().getMarkPassing(competitor, finish);
                    Duration timeElapsed = finishMarkPassing != null && finishMarkPassing.getTimePoint().before(timePoint) ? startOfRace.until(finishMarkPassing.getTimePoint()) : durationSinceStartOfRaceUntilTimePoint;
                    Duration predictedDurationToReachWindwardPositionOfCompetitorFarthestAhead = this.getPredictedDurationToReachWindwardPositionOf(competitor, competitorFarthestAhead, timePoint, cache);
                    Duration totalEstimatedDurationSinceRaceStartToCompetitorFarthestAhead = predictedDurationToReachWindwardPositionOfCompetitorFarthestAhead == null ? null : durationSinceStartOfRaceUntilTimePoint.plus(predictedDurationToReachWindwardPositionOfCompetitorFarthestAhead);
                    Duration calculatedEstimatedTimeWhenReachingCompetitorFarthestAhead = totalEstimatedDurationSinceRaceStartToCompetitorFarthestAhead == null ? null : this.getCalculatedTime(competitor, () -> this.getTrackedRace().getTrackedLeg(competitorFarthestAhead, timePoint).getLeg(), () -> this.getTrackedRace().getTrack(competitorFarthestAhead).getEstimatedPosition(timePoint, true), totalEstimatedDurationSinceRaceStartToCompetitorFarthestAhead, totalWindwardDistanceTraveled);
                    Duration calculatedTime = this.getCalculatedTime(competitor, () -> this.getTrackedRace().getCurrentLeg(competitor, timePoint).getLeg(), () -> this.getTrackedRace().getTrack(competitor).getEstimatedPosition(timePoint, true), this.getTrackedRace().getTimeSailedSinceRaceStart(competitor, timePoint), totalWindwardDistanceTraveled);
                    AbstractRankingMetric.CompetitorRankingInfoImpl rankingInfo = new AbstractRankingMetric.CompetitorRankingInfoImpl(this, timePoint, competitor, this.getWindwardDistanceTraveled(competitor, timePoint, cache), durationSinceStartOfRaceUntilTimePoint, timeElapsed, calculatedTime, predictedDurationToReachWindwardPositionOfCompetitorFarthestAhead, calculatedEstimatedTimeWhenReachingCompetitorFarthestAhead);
                    result.put(competitor, rankingInfo);
                }
            }
        }
        return new NonPerformanceCurveRankingInfoImpl(timePoint, result, competitorFarthestAhead);
    }

    protected Duration getPredictedDurationToReachWindwardPositionOf(Competitor who, Competitor to, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        TrackedLegOfCompetitor currentLegWho = this.getCurrentLegOrLastLegIfAlreadyFinished(who, timePoint);
        TrackedLegOfCompetitor currentLegTo = this.getCurrentLegOrLastLegIfAlreadyFinished(to, timePoint);
        Duration result = this.getPredictedDurationToReachWindwardPositionOf(currentLegWho, currentLegTo, timePoint, cache);
        return result;
    }

    protected Duration getPredictedDurationToReachWindwardPositionOf(TrackedLegOfCompetitor legWho, TrackedLegOfCompetitor legTo, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Duration result;
        assert (legWho == null || legTo == null || this.getTrackedRace().getRace().getCourse().getIndexOfWaypoint(legWho.getTrackedLeg().getLeg().getFrom()) <= this.getTrackedRace().getRace().getCourse().getIndexOfWaypoint(legTo.getTrackedLeg().getLeg().getFrom()));
        if (legWho == null || legTo == null || !this.isAssumedToHaveStartedLeg(timePoint, legWho) && !this.isAssumedToHaveFinishedLeg(timePoint, legWho) || !this.isAssumedToHaveStartedLeg(timePoint, legTo) && !this.isAssumedToHaveFinishedLeg(timePoint, legTo)) {
            result = null;
        } else {
            Competitor to;
            Competitor who = legWho.getCompetitor();
            if (who == (to = legTo.getCompetitor())) {
                result = this.isAssumedToHaveFinishedLeg(timePoint, legWho) && legWho.getFinishTime() != null ? timePoint.until(legWho.getFinishTime()) : Duration.NULL;
            } else {
                assert (this.getTrackedRace().getRace().getCourse().getIndexOfWaypoint(legWho.getLeg().getFrom()) <= this.getTrackedRace().getRace().getCourse().getIndexOfWaypoint(legTo.getLeg().getFrom()));
                Duration toEndOfLegOrTo = this.getPredictedDurationToEndOfLegOrTo(timePoint, legWho, legWho.getTrackedLeg().getTrackedLeg(to), cache);
                if (toEndOfLegOrTo == null) {
                    result = null;
                } else {
                    Duration durationForSubsequentLegsToReachAtEqualPerformance = legWho.getLeg() == legTo.getLeg() ? Duration.NULL : this.getDurationToReachAtEqualPerformance(who, to, legWho.getLeg().getTo(), timePoint, cache);
                    result = durationForSubsequentLegsToReachAtEqualPerformance == null ? null : toEndOfLegOrTo.plus(durationForSubsequentLegsToReachAtEqualPerformance);
                }
            }
        }
        return result;
    }

    protected abstract Duration getDurationToReachAtEqualPerformance(Competitor var1, Competitor var2, Waypoint var3, TimePoint var4, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var5);

    protected Comparator<Competitor> getComparatorByEstimatedCorrectedTimeWhenReachingCompetitorFarthestAhead(Function<Competitor, RankingMetric.CompetitorRankingInfo> rankingInfos) {
        return (c1, c2) -> ((RankingMetric.CompetitorRankingInfo)rankingInfos.apply((Competitor)c1)).getCorrectedTimeAtEstimatedArrivalAtCompetitorFarthestAhead().compareTo((Object)((RankingMetric.CompetitorRankingInfo)rankingInfos.apply((Competitor)c2)).getCorrectedTimeAtEstimatedArrivalAtCompetitorFarthestAhead());
    }

    @Override
    public Speed getReferenceImpliedWind(TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        SpeedWithConfidence<TimePoint> averageWindWithConfidence = this.getTrackedRace().getAverageWindSpeedWithConfidenceWithNumberOfSamples(10);
        return averageWindWithConfidence == null ? null : (Speed)averageWindWithConfidence.getObject();
    }

    public static interface NonPerformanceCurveRankingInfo
    extends RankingMetric.RankingInfoWithLegLeader {
        public Duration getActualTimeFromRaceStartToReachFarthestAheadInLeg(Competitor var1, Leg var2, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var3);
    }

    public class NonPerformanceCurveRankingInfoImpl
    extends AbstractRankingMetric.AbstractRankingInfoWithCompetitorRankingInfoCache
    implements NonPerformanceCurveRankingInfo {
        private static final long serialVersionUID = 7525315823563332681L;

        public NonPerformanceCurveRankingInfoImpl(TimePoint timePoint, Map<Competitor, RankingMetric.CompetitorRankingInfo> competitorRankingInfo, Competitor competitorFarthestAhead) {
            super(NonPerformanceCurveRankingMetric.this, timePoint, competitorRankingInfo, competitorFarthestAhead);
        }

        @Override
        public Duration getActualTimeFromRaceStartToReachFarthestAheadInLeg(Competitor competitor, Leg leg, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
            Duration result;
            TrackedLegOfCompetitor tloc = NonPerformanceCurveRankingMetric.this.getTrackedRace().getTrackedLeg(competitor, leg);
            Duration raceDurationAtTimePoint = NonPerformanceCurveRankingMetric.this.getTrackedRace().getStartOfRace().until(this.getTimePoint());
            if (tloc != null && tloc.hasStartedLeg(this.getTimePoint())) {
                Duration cDurationFromRaceStartToReachFarthestInLeg;
                Competitor competitorFarthestAheadInLeg = this.getCompetitorFarthestAheadInLeg(leg, this.getTimePoint(), cache);
                TrackedLegOfCompetitor tlocOfCompetitorFarthestAheadInLeg = tloc.getTrackedLeg().getTrackedLeg(competitorFarthestAheadInLeg);
                Duration predictedDurationFromTimePointToReachFarthestAheadInLeg = NonPerformanceCurveRankingMetric.this.getPredictedDurationToReachWindwardPositionOf(tloc, tlocOfCompetitorFarthestAheadInLeg, this.getTimePoint(), cache);
                result = predictedDurationFromTimePointToReachFarthestAheadInLeg == null ? null : (cDurationFromRaceStartToReachFarthestInLeg = raceDurationAtTimePoint.plus(predictedDurationFromTimePointToReachFarthestAheadInLeg));
            } else {
                result = null;
            }
            return result;
        }
    }
}

