/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.masterdataimport;

import com.sap.sailing.domain.abstractlog.AbstractLogEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.RaceLogEvent;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLog;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLogEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogDeviceMappingEvent;
import com.sap.sailing.domain.base.CourseArea;
import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.configuration.DeviceConfiguration;
import com.sap.sailing.domain.common.DeviceIdentifier;
import com.sap.sailing.domain.common.RaceIdentifier;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.RegattaIdentifier;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.media.MediaTrack;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboard;
import com.sap.sailing.domain.masterdataimport.WindTrackMasterData;
import com.sap.sailing.domain.racelog.tracking.SensorFixStore;
import com.sap.sailing.domain.tracking.RaceTrackingConnectivityParameters;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sse.common.NoCorrespondingServiceRegisteredException;
import com.sap.sse.common.Timed;
import com.sap.sse.common.TransformationException;
import com.sap.sse.common.Util;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;

public class TopLevelMasterData
implements Serializable {
    private static final Logger logger = Logger.getLogger(TopLevelMasterData.class.getName());
    private static final long serialVersionUID = 4820893865792553281L;
    private final Map<RegattaIdentifier, Set<String>> raceIdStringsForRegatta;
    private final Set<MediaTrack> filteredMediaTracks;
    private final Set<LeaderboardGroup> leaderboardGroups;
    private final Set<WindTrackMasterData> windTrackMasterData;
    private final Map<LeaderboardGroup, Set<Event>> eventForLeaderboardGroup;
    private final Map<DeviceIdentifier, Set<Timed>> raceLogTrackingFixes;
    private final Iterable<DeviceConfiguration> deviceConfigurations;
    private final Set<RaceTrackingConnectivityParameters> connectivityParametersToRestore;

    public TopLevelMasterData(Set<LeaderboardGroup> groupsToExport, Iterable<Event> allEvents, Map<String, Regatta> regattaForRaceIdString, Iterable<MediaTrack> allMediaTracks, SensorFixStore sensorFixStore, boolean exportWind, Iterable<DeviceConfiguration> raceManagerDeviceConfigurations, Set<RaceTrackingConnectivityParameters> connectivityParametersToRestore) {
        this(groupsToExport, TopLevelMasterData.createEventMap(groupsToExport, allEvents), TopLevelMasterData.convertToRaceIdStringsForRegattaMap(regattaForRaceIdString), TopLevelMasterData.filterMediaTracks(allMediaTracks, groupsToExport), TopLevelMasterData.getAllRelevantRaceLogTrackingFixes(sensorFixStore, groupsToExport), exportWind ? TopLevelMasterData.fillWindMap(groupsToExport) : Collections.emptySet(), raceManagerDeviceConfigurations, connectivityParametersToRestore);
    }

    private TopLevelMasterData(Set<LeaderboardGroup> leaderboardGroups, Map<LeaderboardGroup, Set<Event>> eventForLeaderboardGroup, Map<RegattaIdentifier, Set<String>> raceIdStringsForRegatta, Set<MediaTrack> filteredMediaTracks, Map<DeviceIdentifier, Set<Timed>> raceLogTrackingFixes, Set<WindTrackMasterData> windTrackMasterData, Iterable<DeviceConfiguration> deviceConfigurations, Set<RaceTrackingConnectivityParameters> connectivityParametersToRestore) {
        this.raceIdStringsForRegatta = raceIdStringsForRegatta;
        this.leaderboardGroups = leaderboardGroups;
        this.raceLogTrackingFixes = raceLogTrackingFixes;
        this.windTrackMasterData = windTrackMasterData;
        this.deviceConfigurations = deviceConfigurations;
        this.eventForLeaderboardGroup = eventForLeaderboardGroup;
        this.filteredMediaTracks = filteredMediaTracks;
        this.connectivityParametersToRestore = connectivityParametersToRestore;
    }

    public TopLevelMasterData copyAndStripOffDataNotNeededOnReplicas() {
        return new TopLevelMasterData(this.leaderboardGroups, this.eventForLeaderboardGroup, this.raceIdStringsForRegatta, this.filteredMediaTracks, Collections.emptyMap(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
    }

    private static Map<DeviceIdentifier, Set<Timed>> getAllRelevantRaceLogTrackingFixes(SensorFixStore sensorFixStore, Set<LeaderboardGroup> groupsToExport) {
        HashMap<DeviceIdentifier, Set<Timed>> relevantFixes = new HashMap<DeviceIdentifier, Set<Timed>>();
        for (Regatta regatta : TopLevelMasterData.getAllRegattas(groupsToExport)) {
            RegattaLog regattaLog = regatta.getRegattaLog();
            try {
                regattaLog.lockForRead();
                for (RegattaLogEvent logEvent : regattaLog.getRawFixes()) {
                    TopLevelMasterData.addAllFixesIfMappingEvent(sensorFixStore, relevantFixes, logEvent);
                }
            }
            finally {
                regattaLog.unlockAfterRead();
            }
        }
        for (LeaderboardGroup group : groupsToExport) {
            for (Leaderboard leaderboard : group.getLeaderboards()) {
                for (RaceColumn raceColumn : leaderboard.getRaceColumns()) {
                    for (Fleet fleet : raceColumn.getFleets()) {
                        RaceLog raceLog = raceColumn.getRaceLog(fleet);
                        try {
                            raceLog.lockForRead();
                            for (RaceLogEvent logEvent : raceLog.getRawFixes()) {
                                TopLevelMasterData.addAllFixesIfMappingEvent(sensorFixStore, relevantFixes, logEvent);
                            }
                        }
                        finally {
                            raceLog.unlockAfterRead();
                        }
                    }
                }
            }
        }
        return relevantFixes;
    }

    private static void addAllFixesIfMappingEvent(SensorFixStore sensorFixStore, Map<DeviceIdentifier, Set<Timed>> relevantFixes, AbstractLogEvent<?> logEvent) {
        if (logEvent instanceof RegattaLogDeviceMappingEvent) {
            RegattaLogDeviceMappingEvent mappingEvent = (RegattaLogDeviceMappingEvent)logEvent;
            try {
                TopLevelMasterData.addAllFixesForMappingEvent(sensorFixStore, relevantFixes, mappingEvent);
            }
            catch (NoCorrespondingServiceRegisteredException | TransformationException e) {
                logger.severe("Failed to add fixes to exportdata for mapping Event");
                e.printStackTrace();
            }
        }
    }

    private static void addAllFixesForMappingEvent(SensorFixStore sensorFixStore, Map<DeviceIdentifier, Set<Timed>> relevantFixes, RegattaLogDeviceMappingEvent<?> mappingEvent) throws NoCorrespondingServiceRegisteredException, TransformationException {
        DeviceIdentifier device = mappingEvent.getDevice();
        if (!relevantFixes.containsKey(device)) {
            relevantFixes.put(device, new HashSet());
        }
        Set<Timed> fixes = relevantFixes.get(device);
        sensorFixStore.loadFixes(fixes::add, mappingEvent.getDevice(), mappingEvent.getFrom(), mappingEvent.getToInclusive(), true);
    }

    private static Map<LeaderboardGroup, Set<Event>> createEventMap(Set<LeaderboardGroup> groupsToExport, Iterable<Event> allEvents) {
        HashMap<LeaderboardGroup, Set<Event>> eventsForLeaderboardGroup = new HashMap<LeaderboardGroup, Set<Event>>();
        HashMap<CourseArea, Event> eventForCourseArea = new HashMap<CourseArea, Event>();
        for (Event event : allEvents) {
            for (CourseArea courseArea : event.getVenue().getCourseAreas()) {
                eventForCourseArea.put(courseArea, event);
            }
        }
        for (LeaderboardGroup leaderboardGroup : groupsToExport) {
            HashSet<Event> eventSet = new HashSet<Event>();
            eventsForLeaderboardGroup.put(leaderboardGroup, eventSet);
            for (Leaderboard leaderboard : leaderboardGroup.getLeaderboards()) {
                for (CourseArea courseArea : leaderboard.getCourseAreas()) {
                    Event event = (Event)eventForCourseArea.get(courseArea);
                    if (event == null) continue;
                    eventSet.add(event);
                }
            }
        }
        return eventsForLeaderboardGroup;
    }

    private static Map<RegattaIdentifier, Set<String>> convertToRaceIdStringsForRegattaMap(Map<String, Regatta> regattaForRaceIdString) {
        HashMap<RegattaIdentifier, Set<String>> raceIdStringsForRegatta = new HashMap<RegattaIdentifier, Set<String>>();
        for (Map.Entry<String, Regatta> entry : regattaForRaceIdString.entrySet()) {
            Regatta regatta = entry.getValue();
            HashSet<String> raceIds = (HashSet<String>)raceIdStringsForRegatta.get(regatta.getRegattaIdentifier());
            if (raceIds == null) {
                raceIds = new HashSet<String>();
                raceIdStringsForRegatta.put(regatta.getRegattaIdentifier(), raceIds);
            }
            raceIds.add(entry.getKey());
        }
        return raceIdStringsForRegatta;
    }

    private static Set<WindTrackMasterData> fillWindMap(Set<LeaderboardGroup> groupsToExport) {
        HashSet<WindTrackMasterData> windTrackMasterDataSet = new HashSet<WindTrackMasterData>();
        for (LeaderboardGroup group : groupsToExport) {
            for (Leaderboard leaderboard : group.getLeaderboards()) {
                for (RaceColumn raceColumn : leaderboard.getRaceColumns()) {
                    for (Fleet fleet : raceColumn.getFleets()) {
                        TopLevelMasterData.addWindTracksToSetIfExistantAndSourceCanBeStored(windTrackMasterDataSet, raceColumn, fleet);
                    }
                }
            }
        }
        return windTrackMasterDataSet;
    }

    private static void addWindTracksToSetIfExistantAndSourceCanBeStored(Set<WindTrackMasterData> windTrackMasterDataSet, RaceColumn raceColumn, Fleet fleet) {
        TrackedRace trackedRace = raceColumn.getTrackedRace(fleet);
        if (trackedRace != null) {
            Set<WindSource> windSources = trackedRace.getWindSources();
            String raceName = trackedRace.getRace().getName();
            Serializable raceId = trackedRace.getRace().getId();
            String regattaName = trackedRace.getTrackedRegatta().getRegatta().getName();
            if (windSources != null) {
                for (WindSource source : windSources) {
                    if (!source.canBeStored()) continue;
                    windTrackMasterDataSet.add(new WindTrackMasterData(source.getType(), source.getId(), trackedRace.getOrCreateWindTrack(source), regattaName, raceName, raceId));
                }
            }
        }
    }

    public Collection<MediaTrack> getFilteredMediaTracks() {
        return this.filteredMediaTracks;
    }

    public Collection<LeaderboardGroup> getLeaderboardGroups() {
        return this.leaderboardGroups;
    }

    public Set<WindTrackMasterData> getWindTrackMasterData() {
        return this.windTrackMasterData;
    }

    public void setMasterDataExportFlagOnRaceColumns(boolean flagValue) {
        HashSet<LeaderboardGroup> allLeaderboardGroups = new HashSet<LeaderboardGroup>();
        allLeaderboardGroups.addAll(this.leaderboardGroups);
        for (Map.Entry<LeaderboardGroup, Set<Event>> i : this.eventForLeaderboardGroup.entrySet()) {
            for (Event e : i.getValue()) {
                Util.addAll(e.getLeaderboardGroups(), allLeaderboardGroups);
            }
        }
        for (LeaderboardGroup group : allLeaderboardGroups) {
            for (Leaderboard leaderboard : group.getLeaderboards()) {
                for (RaceColumn raceColumn : leaderboard.getRaceColumns()) {
                    raceColumn.setMasterDataExportOngoingThreadFlag(true);
                }
            }
        }
    }

    public Map<RegattaIdentifier, Set<String>> getRaceIdStringsForRegatta() {
        return this.raceIdStringsForRegatta;
    }

    public Map<LeaderboardGroup, Set<Event>> getEventForLeaderboardGroup() {
        return this.eventForLeaderboardGroup;
    }

    public Iterable<Event> getAllEvents() {
        HashMap<UUID, Event> allEventsInMasterData = new HashMap<UUID, Event>();
        for (Set<Event> events : this.eventForLeaderboardGroup.values()) {
            for (Event e : events) {
                allEventsInMasterData.put(e.getId(), e);
            }
        }
        return allEventsInMasterData.values();
    }

    public Iterable<Regatta> getAllRegattas() {
        return TopLevelMasterData.getAllRegattas(this.leaderboardGroups);
    }

    private static Iterable<Regatta> getAllRegattas(Iterable<LeaderboardGroup> groupsToExport) {
        HashSet<Regatta> regattas = new HashSet<Regatta>();
        for (LeaderboardGroup leaderboardGroup : groupsToExport) {
            for (Leaderboard leaderboard : leaderboardGroup.getLeaderboards()) {
                if (!(leaderboard instanceof RegattaLeaderboard)) continue;
                RegattaLeaderboard regattaLeaderboard = (RegattaLeaderboard)leaderboard;
                regattas.add(regattaLeaderboard.getRegatta());
            }
        }
        return regattas;
    }

    private static Set<MediaTrack> filterMediaTracks(Iterable<MediaTrack> allMediaTracks, Set<LeaderboardGroup> leaderboardGroups) {
        HashSet<MediaTrack> result = new HashSet<MediaTrack>();
        Set<RaceIdentifier> raceIdentitifiersForMediaExport = TopLevelMasterData.collectRaceIdentifiersForMediaExport(leaderboardGroups);
        for (MediaTrack mediaTrack : allMediaTracks) {
            for (RegattaAndRaceIdentifier raceIdentifier : mediaTrack.assignedRaces) {
                if (!raceIdentitifiersForMediaExport.contains(raceIdentifier)) continue;
                result.add(mediaTrack);
            }
        }
        return result;
    }

    private static Set<RaceIdentifier> collectRaceIdentifiersForMediaExport(Set<LeaderboardGroup> leaderboardGroups) {
        HashSet<RaceIdentifier> raceIdentifiers = new HashSet<RaceIdentifier>();
        for (LeaderboardGroup leaderboardGroup : leaderboardGroups) {
            for (Leaderboard leaderboard : leaderboardGroup.getLeaderboards()) {
                for (RaceColumn raceColumn : leaderboard.getRaceColumns()) {
                    for (Fleet fleet : raceColumn.getFleets()) {
                        RaceIdentifier raceIdentifier = raceColumn.getRaceIdentifier(fleet);
                        if (raceIdentifier == null) continue;
                        raceIdentifiers.add(raceIdentifier);
                    }
                }
            }
        }
        return raceIdentifiers;
    }

    public Map<DeviceIdentifier, Set<Timed>> getRaceLogTrackingFixes() {
        return this.raceLogTrackingFixes;
    }

    public Iterable<DeviceConfiguration> getDeviceConfigurations() {
        return this.deviceConfigurations;
    }

    public Set<RaceTrackingConnectivityParameters> getConnectivityParametersToRestore() {
        return this.connectivityParametersToRestore;
    }
}

