/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.markpassingcalculation.impl;

import com.sap.sailing.domain.markpassingcalculation.Candidate;
import java.util.function.Supplier;

public class Edge
implements Comparable<Edge> {
    private final Candidate start;
    private final Candidate end;
    private Supplier<Double> estimatedDistanceAndStartTimingProbabilitySupplier;
    private double estimatedDistanceAndStartTimingProbability;
    private static final double PENALTY_FOR_SKIPPED = 0.1;
    private static final double PENALTY_FOR_SKIPPED_TO_END = 0.5;
    private final int numberOfWaypoints;

    public Edge(Candidate start, Candidate end, Supplier<Double> estimatedDistanceAndStartTimingProbabilitySupplier, int numberOfWaypoints) {
        this.start = start;
        this.end = end;
        this.estimatedDistanceAndStartTimingProbabilitySupplier = estimatedDistanceAndStartTimingProbabilitySupplier;
        this.numberOfWaypoints = numberOfWaypoints;
    }

    public Edge(Candidate start, Candidate end, double estimatedDistanceAndStartTimingProbability, int numberOfWaypoints) {
        this.start = start;
        this.end = end;
        this.estimatedDistanceAndStartTimingProbability = estimatedDistanceAndStartTimingProbability;
        this.numberOfWaypoints = numberOfWaypoints;
    }

    public static double getPenaltyForSkipping() {
        return 0.1;
    }

    public double getProbability() {
        double penalty = this.getEnd().getOneBasedIndexOfWaypoint() == this.numberOfWaypoints + 1 ? 0.5 : Edge.getPenaltyForSkipping();
        return this.getEnd().getProbability() * this.getEstimatedDistanceAndStartTimingProbability() * Math.pow(penalty, this.getEnd().getOneBasedIndexOfWaypoint() - this.getStart().getOneBasedIndexOfWaypoint() - 1);
    }

    private double getEstimatedDistanceAndStartTimingProbability() {
        if (this.estimatedDistanceAndStartTimingProbabilitySupplier != null) {
            this.estimatedDistanceAndStartTimingProbability = this.estimatedDistanceAndStartTimingProbabilitySupplier.get();
            this.estimatedDistanceAndStartTimingProbabilitySupplier = null;
        }
        return this.estimatedDistanceAndStartTimingProbability;
    }

    public Candidate getStart() {
        return this.start;
    }

    public Candidate getEnd() {
        return this.end;
    }

    public String toString() {
        return "Edge from Waypoint " + this.start.getOneBasedIndexOfWaypoint() + " (" + this.start.getTimePoint() + ") to " + this.end.getOneBasedIndexOfWaypoint() + " (" + this.end.getTimePoint() + "): " + this.getProbability();
    }

    @Override
    public int compareTo(Edge o) {
        return this.start != o.getStart() ? this.start.compareTo(o.getStart()) : (this.end != o.getEnd() ? this.end.compareTo(o.getEnd()) : Double.compare(this.getProbability(), o.getProbability()));
    }
}

