/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.leaderboard.impl;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CourseArea;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceColumnInSeries;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.impl.RaceColumnInSeriesImpl;
import com.sap.sailing.domain.common.LeaderboardType;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboard;
import com.sap.sailing.domain.leaderboard.ResultDiscardingRule;
import com.sap.sailing.domain.leaderboard.ScoringScheme;
import com.sap.sailing.domain.leaderboard.ThresholdBasedResultDiscardingRule;
import com.sap.sailing.domain.leaderboard.impl.AbstractLeaderboardImpl;
import com.sap.sailing.domain.leaderboard.impl.CompetitorProviderFromRaceColumnsAndRegattaLike;
import com.sap.sailing.domain.leaderboard.impl.PerSeriesResultDiscardingRuleImpl;
import com.sap.sailing.domain.regattalike.IsRegattaLike;
import com.sap.sse.common.Util;
import com.sap.sse.metering.CPUMeter;
import java.io.IOException;
import java.io.ObjectInputStream;

public class RegattaLeaderboardImpl
extends AbstractLeaderboardImpl
implements RegattaLeaderboard {
    private static final long serialVersionUID = 2370461218294770084L;
    private final Regatta regatta;

    public RegattaLeaderboardImpl(Regatta regatta, ThresholdBasedResultDiscardingRule resultDiscardingRule) {
        super(resultDiscardingRule);
        this.regatta = regatta;
        regatta.addRaceColumnListener(this);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
    }

    @Override
    public Regatta getRegatta() {
        return this.regatta;
    }

    public CPUMeter getCPUMeter() {
        return this.getRegatta().getCPUMeter();
    }

    public static String getLeaderboardNameForRegatta(Regatta regatta) {
        return regatta.getName();
    }

    public String getName() {
        return RegattaLeaderboardImpl.getLeaderboardNameForRegatta(this.getRegatta());
    }

    @Override
    public Iterable<RaceColumn> getRaceColumns() {
        Iterable raceColumns = this.getRegatta().getRaceColumns();
        return raceColumns;
    }

    @Override
    public RaceColumnInSeries getRaceColumnByName(String columnName) {
        return (RaceColumnInSeriesImpl)super.getRaceColumnByName(columnName);
    }

    @Override
    public ScoringScheme getScoringScheme() {
        return this.regatta.getScoringScheme();
    }

    @Override
    public Iterable<CourseArea> getCourseAreas() {
        return this.regatta.getCourseAreas();
    }

    @Override
    public ResultDiscardingRule getResultDiscardingRule() {
        if (this.regatta.definesSeriesDiscardThresholds()) {
            return new PerSeriesResultDiscardingRuleImpl(this.regatta);
        }
        return super.getResultDiscardingRule();
    }

    @Override
    public Util.Pair<Iterable<RaceDefinition>, Iterable<Competitor>> getAllCompetitorsWithRaceDefinitionsConsidered() {
        return this.regatta.getAllCompetitorsWithRaceDefinitionsConsidered();
    }

    @Override
    public IsRegattaLike getRegattaLike() {
        return this.regatta;
    }

    @Override
    public LeaderboardType getLeaderboardType() {
        return LeaderboardType.RegattaLeaderboard;
    }

    @Override
    public BoatClass getBoatClass() {
        return this.getRegatta().getBoatClass();
    }

    @Override
    public CompetitorProviderFromRaceColumnsAndRegattaLike getOrCreateCompetitorsProvider() {
        return this.getRegatta().getOrCreateCompetitorsProvider();
    }

    public void setFleetsCanRunInParallelToTrue() {
        this.getRegattaLike().setFleetsCanRunInParallelToTrue();
    }
}

