/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.confidence.impl;

import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.confidence.HasConfidenceAndIsScalable;
import com.sap.sailing.domain.common.confidence.Weigher;
import com.sap.sailing.domain.common.confidence.impl.ConfidenceBasedAveragerImpl;
import com.sap.sailing.domain.common.confidence.impl.ScalableWind;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.impl.WindImpl;
import com.sap.sailing.domain.confidence.ConfidenceBasedWindAverager;
import com.sap.sailing.domain.tracking.WindWithConfidence;
import com.sap.sailing.domain.tracking.impl.WindWithConfidenceImpl;
import com.sap.sse.common.scalablevalue.ScalableValue;
import java.util.Iterator;

public class ConfidenceBasedWindAveragerImpl<RelativeTo>
extends ConfidenceBasedAveragerImpl<ScalableWind, Wind, RelativeTo>
implements ConfidenceBasedWindAverager<RelativeTo> {
    public ConfidenceBasedWindAveragerImpl(Weigher<RelativeTo> weigher) {
        super(weigher);
    }

    @Override
    public WindWithConfidence<RelativeTo> getAverage(Iterable<? extends HasConfidenceAndIsScalable<ScalableWind, Wind, RelativeTo>> values, RelativeTo at) {
        return this.getAverage(values.iterator(), at);
    }

    public WindWithConfidence<RelativeTo> getAverage(Iterator<? extends HasConfidenceAndIsScalable<ScalableWind, Wind, RelativeTo>> values, RelativeTo at) {
        WindWithConfidenceImpl<RelativeTo> result;
        boolean atLeastOneFixWasMarkedToUseSpeed = false;
        if (values == null || !values.hasNext()) {
            result = null;
        } else {
            ScalableWind numerator = null;
            double confidenceSum = 0.0;
            double speedConfidenceSum = 0.0;
            double knotSum = 0.0;
            int count = 0;
            while (values.hasNext()) {
                HasConfidenceAndIsScalable<ScalableWind, Wind, RelativeTo> next = values.next();
                double relativeWeight = this.getWeight(next, at);
                ScalableWind weightedNext = (ScalableWind)next.getScalableValue().multiply(relativeWeight).getValue();
                double weighedNextKnots = ((Wind)next.getObject()).getKnots() * relativeWeight;
                numerator = numerator == null ? weightedNext : numerator.add((ScalableValue)weightedNext);
                confidenceSum += relativeWeight;
                if (weightedNext.useSpeed()) {
                    atLeastOneFixWasMarkedToUseSpeed = true;
                    speedConfidenceSum += relativeWeight;
                    knotSum += weighedNextKnots;
                }
                ++count;
            }
            double newConfidence = confidenceSum / (double)count;
            if (confidenceSum == 0.0) {
                result = null;
            } else {
                Wind preResult = numerator.divide(confidenceSum);
                Object windResult = !atLeastOneFixWasMarkedToUseSpeed ? preResult : new WindImpl(preResult.getPosition(), preResult.getTimePoint(), (SpeedWithBearing)new KnotSpeedWithBearingImpl(knotSum / speedConfidenceSum, preResult.getBearing()));
                result = new WindWithConfidenceImpl<RelativeTo>((Wind)windResult, newConfidence, at, atLeastOneFixWasMarkedToUseSpeed);
            }
        }
        return result;
    }
}

