/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.base.impl;

import com.sap.sailing.domain.base.ControlPoint;
import com.sap.sailing.domain.base.Course;
import com.sap.sailing.domain.base.CourseListener;
import com.sap.sailing.domain.base.DomainFactory;
import com.sap.sailing.domain.base.Leg;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.base.impl.LegImpl;
import com.sap.sailing.domain.common.PassingInstruction;
import com.sap.sailing.util.CourseAsWaypointList;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.RenamableImpl;
import com.sap.sse.concurrent.LockUtil;
import com.sap.sse.concurrent.NamedReentrantReadWriteLock;
import difflib.DiffUtils;
import difflib.Patch;
import difflib.PatchFailedException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CourseImpl
extends RenamableImpl
implements Course {
    private static final long serialVersionUID = -4280487649617132403L;
    private static final Logger logger = Logger.getLogger(CourseImpl.class.getName());
    private final List<Waypoint> waypoints;
    private final Map<Waypoint, Integer> waypointIndexes;
    private Waypoint firstWaypoint;
    private Waypoint lastWaypoint;
    private final List<Leg> legs;
    private UUID originatingCourseTemplateId;
    private final Map<Mark, UUID> associatedRoles = new HashMap<Mark, UUID>();
    private transient Set<CourseListener> listeners;
    private transient NamedReentrantReadWriteLock lock;
    private final Serializable updateMonitor;

    public CourseImpl(String name, Iterable<Waypoint> waypoints) {
        this(name, waypoints, null);
    }

    public CourseImpl(String name, Iterable<Waypoint> waypoints, UUID originatingCourseTemplateId) {
        super(name);
        this.originatingCourseTemplateId = originatingCourseTemplateId;
        this.updateMonitor = "" + new Random().nextDouble();
        this.lock = new NamedReentrantReadWriteLock("lock for CourseImpl " + name, true);
        this.listeners = new HashSet<CourseListener>();
        this.waypoints = new ArrayList<Waypoint>();
        this.waypointIndexes = new HashMap<Waypoint, Integer>();
        this.legs = new ArrayList<Leg>();
        Iterator<Waypoint> waypointIter = waypoints.iterator();
        int i = 0;
        if (waypointIter.hasNext()) {
            Waypoint previous;
            this.firstWaypoint = previous = waypointIter.next();
            this.waypoints.add(previous);
            this.waypointIndexes.put(previous, i++);
            while (waypointIter.hasNext()) {
                Waypoint current = waypointIter.next();
                this.waypoints.add(current);
                int indexOfStartWaypoint = i - 1;
                this.waypointIndexes.put(current, i++);
                LegImpl leg = new LegImpl(this, indexOfStartWaypoint);
                this.legs.add(leg);
                previous = current;
            }
            this.lastWaypoint = previous;
        }
        assert (this.waypoints.size() == this.waypointIndexes.size());
    }

    @Override
    public void lockForRead() {
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.lock);
    }

    @Override
    public void unlockAfterRead() {
        LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.lock);
    }

    public void lockForWrite() {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.lock);
    }

    public void unlockAfterWrite() {
        LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.lock);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.listeners = new HashSet<CourseListener>();
        this.lock = new NamedReentrantReadWriteLock("lock for CourseImpl " + this.getName(), true);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.lockForRead();
        try {
            s.defaultWriteObject();
        }
        finally {
            this.unlockAfterRead();
        }
    }

    Waypoint getWaypoint(int i) {
        return this.waypoints.get(i);
    }

    public void addWaypoint(int zeroBasedPosition, Waypoint waypointToAdd) {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.lock);
        try {
            assert (!this.waypoints.contains(waypointToAdd));
            logger.info("Adding waypoint " + waypointToAdd + " to course '" + this.getName() + "'");
            this.waypoints.add(zeroBasedPosition, waypointToAdd);
            HashMap<Waypoint, Integer> updatesToWaypointIndexes = new HashMap<Waypoint, Integer>();
            updatesToWaypointIndexes.put(waypointToAdd, zeroBasedPosition);
            for (Map.Entry<Waypoint, Integer> e : this.waypointIndexes.entrySet()) {
                if (e.getValue() < zeroBasedPosition) continue;
                updatesToWaypointIndexes.put(e.getKey(), e.getValue() + 1);
            }
            this.waypointIndexes.putAll(updatesToWaypointIndexes);
            if (this.waypoints.size() > 1) {
                this.legs.add(new LegImpl(this, this.waypoints.size() - 2));
            }
            if (zeroBasedPosition == 0) {
                this.firstWaypoint = waypointToAdd;
            }
            if (zeroBasedPosition == this.waypoints.size() - 1) {
                this.lastWaypoint = waypointToAdd;
            }
            logger.info("Waypoint " + waypointToAdd + " added to course '" + this.getName() + "', before notifying listeners");
            this.notifyListenersWaypointAdded(zeroBasedPosition, waypointToAdd);
            logger.info("Waypoint " + waypointToAdd + " added to course '" + this.getName() + "', after notifying listeners");
            assert (this.waypoints.size() == this.waypointIndexes.size());
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.lock);
        }
    }

    public void removeWaypoint(int zeroBasedPosition) {
        if (zeroBasedPosition >= 0) {
            LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.lock);
            try {
                Waypoint removedWaypoint = this.waypoints.remove(zeroBasedPosition);
                logger.info("Removing waypoint " + removedWaypoint + " from course '" + this.getName() + "'");
                this.waypointIndexes.remove(removedWaypoint);
                HashMap<Waypoint, Integer> updatesToWaypointIndexes = new HashMap<Waypoint, Integer>();
                for (Map.Entry<Waypoint, Integer> e : this.waypointIndexes.entrySet()) {
                    if (e.getValue() <= zeroBasedPosition) continue;
                    updatesToWaypointIndexes.put(e.getKey(), e.getValue() - 1);
                }
                this.waypointIndexes.putAll(updatesToWaypointIndexes);
                if (!this.legs.isEmpty()) {
                    this.legs.remove(this.legs.size() - 1);
                }
                if (this.waypoints.isEmpty()) {
                    this.firstWaypoint = null;
                    this.lastWaypoint = null;
                } else {
                    if (zeroBasedPosition == 0) {
                        this.firstWaypoint = this.waypoints.get(0);
                    }
                    if (zeroBasedPosition == this.waypoints.size()) {
                        this.lastWaypoint = this.waypoints.get(this.waypoints.size() - 1);
                    }
                }
                logger.info("Waypoint " + removedWaypoint + " removed from course '" + this.getName() + "', before notifying listeners");
                this.notifyListenersWaypointRemoved(zeroBasedPosition, removedWaypoint);
                logger.info("Waypoint " + removedWaypoint + " removed from course '" + this.getName() + "', after notifying listeners");
                assert (this.waypoints.size() == this.waypointIndexes.size());
            }
            finally {
                LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.lock);
            }
        }
    }

    private void notifyListenersWaypointRemoved(int index, Waypoint waypointToRemove) {
        for (CourseListener listener : this.listeners) {
            try {
                listener.waypointRemoved(index, waypointToRemove);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception while notifying listener about waypoint " + waypointToRemove + " that got removed from course " + this + ": " + e.getMessage());
                logger.log(Level.SEVERE, "notifyListenersWaypointRemoved", e);
            }
        }
    }

    private void notifyListenersWaypointAdded(int zeroBasedPosition, Waypoint waypointToAdd) {
        for (CourseListener listener : this.listeners) {
            try {
                listener.waypointAdded(zeroBasedPosition, waypointToAdd);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception while notifying listener about waypoint " + waypointToAdd + " that got added to course " + this + ": " + e.getMessage());
                logger.log(Level.SEVERE, "notifyListenersWaypointAdded", e);
            }
        }
    }

    public Leg getFirstLeg() {
        Leg result = null;
        if (!this.legs.isEmpty()) {
            try {
                result = this.legs.get(0);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return result;
    }

    public List<Leg> getLegs() {
        this.lockForRead();
        try {
            ArrayList<Leg> arrayList = new ArrayList<Leg>(this.legs);
            return arrayList;
        }
        finally {
            this.unlockAfterRead();
        }
    }

    public Iterable<Waypoint> getWaypoints() {
        this.lockForRead();
        try {
            ArrayList<Waypoint> arrayList = new ArrayList<Waypoint>(this.waypoints);
            return arrayList;
        }
        finally {
            this.unlockAfterRead();
        }
    }

    @Override
    public int getNumberOfWaypoints() {
        return this.waypoints.size();
    }

    @Override
    public Leg getLeg(int zeroBasedIndexOfWaypoint) {
        return this.legs.get(zeroBasedIndexOfWaypoint);
    }

    public String toString() {
        return this.internalToString();
    }

    public int getIndexOfWaypoint(Waypoint waypoint) {
        this.lockForRead();
        try {
            int result = -1;
            Integer indexEntry = this.waypointIndexes.get(waypoint);
            if (indexEntry != null) {
                result = indexEntry;
            }
            int n = result;
            return n;
        }
        finally {
            this.unlockAfterRead();
        }
    }

    public Waypoint getWaypointForControlPoint(ControlPoint controlPoint, int start) {
        this.lockForRead();
        try {
            if (start > this.legs.size()) {
                throw new IllegalArgumentException("Starting to search beyond end of course: " + start + " vs. " + (this.legs.size() + 1));
            }
            int i = 0;
            for (Waypoint waypoint : this.getWaypoints()) {
                if (i >= start && waypoint.getControlPoint() == controlPoint) {
                    Waypoint waypoint2 = waypoint;
                    return waypoint2;
                }
                ++i;
            }
            return null;
        }
        finally {
            this.unlockAfterRead();
        }
    }

    public Waypoint getFirstWaypoint() {
        return this.firstWaypoint;
    }

    public Waypoint getLastWaypoint() {
        return this.lastWaypoint;
    }

    @Override
    public void addCourseListener(CourseListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeCourseListener(CourseListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Iterable<Util.Pair<ControlPoint, PassingInstruction>> newControlPoints, Map<Mark, UUID> associatedRoles, UUID originatingCouseTemplateIdOrNull, DomainFactory baseDomainFactory) throws PatchFailedException {
        Patch patch = null;
        Serializable serializable = this.updateMonitor;
        synchronized (serializable) {
            this.lockForRead();
            try {
                Iterable<Waypoint> courseWaypoints = this.getWaypoints();
                LinkedList<Waypoint> newWaypointList = new LinkedList<Waypoint>();
                HashMap<Util.Pair, ArrayList<Waypoint>> existingWaypointsByControlPoint = new HashMap<Util.Pair, ArrayList<Waypoint>>();
                for (Waypoint waypoint : courseWaypoints) {
                    Util.Pair key = new Util.Pair((Object)waypoint.getControlPoint(), (Object)waypoint.getPassingInstructions());
                    ArrayList<Waypoint> wpl = (ArrayList<Waypoint>)existingWaypointsByControlPoint.get(key);
                    if (wpl == null) {
                        wpl = new ArrayList<Waypoint>();
                        existingWaypointsByControlPoint.put(key, wpl);
                    }
                    wpl.add(waypoint);
                }
                for (Util.Pair pair : newControlPoints) {
                    List waypoints = (List)existingWaypointsByControlPoint.get(new Util.Pair((Object)((ControlPoint)pair.getA()), (Object)((PassingInstruction)pair.getB())));
                    Waypoint waypoint = waypoints == null || waypoints.isEmpty() ? baseDomainFactory.createWaypoint((ControlPoint)pair.getA(), (PassingInstruction)pair.getB()) : (Waypoint)waypoints.remove(0);
                    newWaypointList.add(waypoint);
                }
                patch = DiffUtils.diff(courseWaypoints, newWaypointList);
            }
            finally {
                this.unlockAfterRead();
            }
            if (patch != null && !patch.isEmpty()) {
                this.lockForWrite();
                try {
                    logger.info("applying course update " + patch + " to course " + this);
                    this.getAssociatedRoles().clear();
                    this.getAssociatedRoles().putAll(associatedRoles);
                    this.originatingCourseTemplateId = originatingCouseTemplateIdOrNull;
                    CourseAsWaypointList courseAsWaypointList = new CourseAsWaypointList(this);
                    patch.applyToInPlace((List)courseAsWaypointList);
                }
                finally {
                    this.unlockAfterWrite();
                }
            }
        }
    }

    public UUID getOriginatingCourseTemplateIdOrNull() {
        return this.originatingCourseTemplateId;
    }

    public Map<Mark, UUID> getAssociatedRoles() {
        return this.associatedRoles;
    }

    public void addRoleMapping(Mark mark, UUID markRoleId) {
        this.associatedRoles.put(mark, markRoleId);
    }
}

