/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.ui.client.selection.statistic;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.user.client.ui.HasAnimation;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.MenuItemSeparator;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.common.Util;
import com.sap.sse.datamining.shared.impl.dto.DataRetrieverChainDefinitionDTO;
import com.sap.sse.datamining.ui.client.StringMessages;
import com.sap.sse.datamining.ui.client.selection.statistic.ExtractionFunctionWithContext;
import com.sap.sse.gwt.client.suggestion.AbstractListSuggestOracle;
import com.sap.sse.gwt.client.suggestion.AbstractSuggestOracle;
import com.sap.sse.gwt.client.suggestion.CustomSuggestBox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ExtractionFunctionSuggestBox
extends CustomSuggestBox<ExtractionFunctionWithContext> {
    private final AbstractListSuggestOracle<ExtractionFunctionWithContext> suggestOracle = (AbstractListSuggestOracle)this.getSuggestOracle();
    private final ExtractionFunctionSuggestionDisplay display = (ExtractionFunctionSuggestionDisplay)this.getSuggestionDisplay();
    private ValueChangeHandler valueChangeHandler;
    private ExtractionFunctionWithContext extractionFunction;

    public ExtractionFunctionSuggestBox(Predicate<ExtractionFunctionWithContext> extractionFunctionSupportedPredicate) {
        super((AbstractSuggestOracle)new ExtractionFunctionSuggestOracle(extractionFunctionSupportedPredicate), (SuggestBox.SuggestionDisplay)new ExtractionFunctionSuggestionDisplay());
        this.addSuggestionSelectionHandler(this::setExtractionFunction);
        this.getValueBox().addBlurHandler(this::onBlur);
    }

    public void setValueChangeHandler(ValueChangeHandler valueChangeHandler) {
        this.valueChangeHandler = valueChangeHandler;
    }

    public Collection<ExtractionFunctionWithContext> getSelectableValues() {
        return this.suggestOracle.getSelectableValues();
    }

    public void setSelectableValues(Collection<? extends ExtractionFunctionWithContext> selectableValues) {
        this.suggestOracle.setSelectableValues(selectableValues);
    }

    public void setExtractionFunction(ExtractionFunctionWithContext extractionFunction) {
        if (!Objects.equals(this.extractionFunction, extractionFunction)) {
            ExtractionFunctionWithContext oldValue = this.extractionFunction;
            this.extractionFunction = extractionFunction;
            this.setValue(extractionFunction == null ? null : extractionFunction.getDisplayString(), false);
            if (this.valueChangeHandler != null) {
                this.valueChangeHandler.valueChanged(oldValue, extractionFunction);
            }
        }
        this.setFocus(false);
    }

    public ExtractionFunctionWithContext getExtractionFunction() {
        return this.extractionFunction;
    }

    private void onBlur(BlurEvent event) {
        this.setValue(this.extractionFunction == null ? null : this.extractionFunction.getDisplayString(), false);
    }

    public void hideSuggestionList() {
        this.display.hideSuggestions();
    }

    public boolean isGroupingSuggestionsByRetrieverChain() {
        return this.display.isGroupingSuggestionsByRetrieverChain();
    }

    public void setGroupingSuggestionsByRetrieverChain(boolean groupingSuggestionsByRetrieverChain) {
        this.display.setGroupingSuggestionsByRetrieverChain(groupingSuggestionsByRetrieverChain);
    }

    private static class ExtractionFunctionSeparator
    extends MenuItemSeparator {
        public ExtractionFunctionSeparator(DataRetrieverChainDefinitionDTO retrieverChain) {
            this.setStyleName("separator");
            this.getElement().getFirstChildElement().setInnerText(retrieverChain.getName());
        }
    }

    private static class ExtractionFunctionSuggestOracle
    extends AbstractListSuggestOracle<ExtractionFunctionWithContext> {
        private final Predicate<ExtractionFunctionWithContext> extractionFunctionSupportedPredicate;

        public ExtractionFunctionSuggestOracle(Predicate<ExtractionFunctionWithContext> extractionFunctionSupportedPredicate) {
            this.extractionFunctionSupportedPredicate = extractionFunctionSupportedPredicate;
        }

        protected Iterable<String> getKeywordStrings(Iterable<String> queryTokens) {
            String filterText = (String)Util.first(queryTokens);
            if (filterText == null) {
                return queryTokens;
            }
            return Util.splitAlongWhitespaceRespectingDoubleQuotedPhrases((String)filterText);
        }

        protected Iterable<String> getMatchingStrings(ExtractionFunctionWithContext value) {
            return value.getMatchingStrings();
        }

        protected String createSuggestionKeyString(ExtractionFunctionWithContext value) {
            return value.getDisplayString();
        }

        protected String createSuggestionAdditionalDisplayString(ExtractionFunctionWithContext value) {
            return null;
        }

        protected AbstractSuggestOracle.SimpleSuggestion createSuggestion(ExtractionFunctionWithContext match, Iterable<String> queryTokens) {
            return new ExtractionFunctionSuggestion(match, queryTokens, this.extractionFunctionSupportedPredicate.test(match));
        }

        private class ExtractionFunctionSuggestion
        extends AbstractSuggestOracle.SimpleSuggestion
        implements Comparable<ExtractionFunctionSuggestion> {
            private final boolean supported;

            public ExtractionFunctionSuggestion(ExtractionFunctionWithContext suggestObject, Iterable<String> queryTokens, boolean supported) {
                super((AbstractSuggestOracle)ExtractionFunctionSuggestOracle.this, (Object)suggestObject, queryTokens);
                this.supported = supported;
            }

            public boolean isSupported() {
                return this.supported;
            }

            @Override
            public int compareTo(ExtractionFunctionSuggestion other) {
                if (other == null) {
                    return -1;
                }
                String displayName = ((ExtractionFunctionWithContext)this.getSuggestObject()).getExtractionFunction().getDisplayName();
                String otherDisplayName = ((ExtractionFunctionWithContext)other.getSuggestObject()).getExtractionFunction().getDisplayName();
                return displayName.compareToIgnoreCase(otherDisplayName);
            }
        }
    }

    private static class ExtractionFunctionSuggestionDisplay
    extends SuggestBox.SuggestionDisplay
    implements HasAnimation {
        private final StringMessages stringMessages = StringMessages.INSTANCE;
        private final ExtractionFunctionSuggestionMenu suggestionMenu = new ExtractionFunctionSuggestionMenu(true);
        private final PopupPanel suggestionPopup = new PopupPanel(true, false);
        private boolean groupingSuggestionsByRetrieverChain;
        private Element autoHidePartner;

        public ExtractionFunctionSuggestionDisplay() {
            this.suggestionPopup.setStyleName("statisticSuggestBoxPopup");
            this.suggestionPopup.addStyleName("dataMiningBorderLeft");
            this.suggestionPopup.addStyleName("dataMiningBorderBottom");
            this.suggestionPopup.addStyleName("dataMiningBorderRight");
            this.suggestionPopup.setPreviewingAllNativeEvents(true);
            this.suggestionPopup.setAnimationType(PopupPanel.AnimationType.ROLL_DOWN);
            this.suggestionPopup.setWidget((Widget)this.suggestionMenu);
        }

        protected SuggestOracle.Suggestion getCurrentSelection() {
            return this.suggestionMenu.getSelectedSuggestion();
        }

        public void hideSuggestions() {
            this.suggestionPopup.hide();
        }

        public boolean isSuggestionListShowing() {
            return this.suggestionPopup.isVisible();
        }

        protected void moveSelectionDown() {
            if (this.isSuggestionListShowing()) {
                this.suggestionMenu.selectItem(this.suggestionMenu.getSelectedIndex() + 1);
            }
        }

        protected void moveSelectionUp() {
            if (this.isSuggestionListShowing()) {
                int selectedIndex = this.suggestionMenu.getSelectedIndex();
                if (selectedIndex < 0) {
                    this.suggestionMenu.selectItem(this.suggestionMenu.size() - 1);
                } else {
                    this.suggestionMenu.selectItem(selectedIndex - 1);
                }
            }
        }

        public boolean isGroupingSuggestionsByRetrieverChain() {
            return this.groupingSuggestionsByRetrieverChain;
        }

        public void setGroupingSuggestionsByRetrieverChain(boolean groupingSuggestionsByRetrieverChain) {
            this.groupingSuggestionsByRetrieverChain = groupingSuggestionsByRetrieverChain;
        }

        protected void showSuggestions(SuggestBox suggestBox, Collection<? extends SuggestOracle.Suggestion> suggestions, boolean isDisplayStringHTML, boolean isAutoSelectEnabled, SuggestBox.SuggestionCallback callback) {
            if (this.suggestionPopup.isAttached()) {
                this.suggestionPopup.hide();
            }
            ArrayList<ExtractionFunctionSuggestOracle.ExtractionFunctionSuggestion> supportedSuggestions = new ArrayList<ExtractionFunctionSuggestOracle.ExtractionFunctionSuggestion>();
            ArrayList<ExtractionFunctionSuggestOracle.ExtractionFunctionSuggestion> unsupportedSuggestions = new ArrayList<ExtractionFunctionSuggestOracle.ExtractionFunctionSuggestion>();
            for (SuggestOracle.Suggestion suggestion : suggestions) {
                ExtractionFunctionSuggestOracle.ExtractionFunctionSuggestion extractionFunctionSuggestion = (ExtractionFunctionSuggestOracle.ExtractionFunctionSuggestion)suggestion;
                if (extractionFunctionSuggestion.isSupported()) {
                    supportedSuggestions.add(extractionFunctionSuggestion);
                    continue;
                }
                unsupportedSuggestions.add(extractionFunctionSuggestion);
            }
            this.suggestionMenu.clearItems();
            if (this.groupingSuggestionsByRetrieverChain) {
                this.showSuggestionsGroupedByRetrieverChain(supportedSuggestions, isDisplayStringHTML, callback);
            } else {
                this.addSuggestionMenuItems(supportedSuggestions, isDisplayStringHTML, callback);
            }
            if (!unsupportedSuggestions.isEmpty()) {
                this.suggestionMenu.addSeparator(new UnsupportedExtractionFunctionsSeparator(this.stringMessages.followingStatisticsAreNotSupportedByAggregatorWarning()));
                if (this.groupingSuggestionsByRetrieverChain) {
                    this.showSuggestionsGroupedByRetrieverChain(unsupportedSuggestions, isDisplayStringHTML, callback);
                } else {
                    this.addSuggestionMenuItems(unsupportedSuggestions, isDisplayStringHTML, callback);
                }
            }
            if (isAutoSelectEnabled && this.suggestionMenu.size() > 0) {
                this.suggestionMenu.selectItem(0);
            }
            this.updateAutoHidePartner((Element)suggestBox.getElement());
            this.suggestionPopup.showRelativeTo((UIObject)suggestBox);
        }

        private void showSuggestionsGroupedByRetrieverChain(Collection<? extends SuggestOracle.Suggestion> suggestions, boolean isDisplayStringHTML, SuggestBox.SuggestionCallback callback) {
            Map<DataRetrieverChainDefinitionDTO, List<ExtractionFunctionSuggestOracle.ExtractionFunctionSuggestion>> groupedSuggestions = this.groupSuggestionsByRetrieverChain(suggestions);
            ArrayList<DataRetrieverChainDefinitionDTO> orderedRetrieverChains = new ArrayList<DataRetrieverChainDefinitionDTO>(groupedSuggestions.keySet());
            Collections.sort(orderedRetrieverChains);
            for (DataRetrieverChainDefinitionDTO retrieverChain : orderedRetrieverChains) {
                List<ExtractionFunctionSuggestOracle.ExtractionFunctionSuggestion> suggestionsOfRetrieverChain = groupedSuggestions.get(retrieverChain);
                suggestionsOfRetrieverChain.sort(null);
                ExtractionFunctionSeparator separator = new ExtractionFunctionSeparator(retrieverChain);
                this.suggestionMenu.addSeparator(separator);
                if (!suggestionsOfRetrieverChain.get(0).isSupported()) {
                    separator.addStyleName("separator-unsupported");
                }
                this.addSuggestionMenuItems(suggestionsOfRetrieverChain, isDisplayStringHTML, callback);
            }
        }

        private Map<DataRetrieverChainDefinitionDTO, List<ExtractionFunctionSuggestOracle.ExtractionFunctionSuggestion>> groupSuggestionsByRetrieverChain(Collection<? extends SuggestOracle.Suggestion> suggestions) {
            HashMap<DataRetrieverChainDefinitionDTO, List<ExtractionFunctionSuggestOracle.ExtractionFunctionSuggestion>> groupedSuggestions = new HashMap<DataRetrieverChainDefinitionDTO, List<ExtractionFunctionSuggestOracle.ExtractionFunctionSuggestion>>();
            for (SuggestOracle.Suggestion suggestion : suggestions) {
                ExtractionFunctionSuggestOracle.ExtractionFunctionSuggestion extractionFunctionSuggestion = (ExtractionFunctionSuggestOracle.ExtractionFunctionSuggestion)suggestion;
                ExtractionFunctionWithContext extractionFunction = (ExtractionFunctionWithContext)extractionFunctionSuggestion.getSuggestObject();
                DataRetrieverChainDefinitionDTO retrieverChain = extractionFunction.getRetrieverChain();
                ArrayList<ExtractionFunctionSuggestOracle.ExtractionFunctionSuggestion> suggestionsOfRetrieverChain = (ArrayList<ExtractionFunctionSuggestOracle.ExtractionFunctionSuggestion>)groupedSuggestions.get(retrieverChain);
                if (suggestionsOfRetrieverChain == null) {
                    suggestionsOfRetrieverChain = new ArrayList<ExtractionFunctionSuggestOracle.ExtractionFunctionSuggestion>();
                    groupedSuggestions.put(retrieverChain, suggestionsOfRetrieverChain);
                }
                suggestionsOfRetrieverChain.add(extractionFunctionSuggestion);
            }
            return groupedSuggestions;
        }

        private void addSuggestionMenuItems(Collection<ExtractionFunctionSuggestOracle.ExtractionFunctionSuggestion> suggestions, boolean isDisplayStringHTML, SuggestBox.SuggestionCallback callback) {
            int count = 0;
            for (ExtractionFunctionSuggestOracle.ExtractionFunctionSuggestion suggestion : suggestions) {
                boolean isEven = count % 2 == 0;
                SuggestionMenuItem menuItem = this.createSuggestionMenuItem(suggestion, isDisplayStringHTML, isEven, callback);
                this.suggestionMenu.addItem(menuItem);
                ++count;
            }
        }

        private SuggestionMenuItem createSuggestionMenuItem(ExtractionFunctionSuggestOracle.ExtractionFunctionSuggestion suggestion, boolean isDisplayStringHTML, boolean isEven, SuggestBox.SuggestionCallback callback) {
            SuggestionMenuItem menuItem = new SuggestionMenuItem((SuggestOracle.Suggestion)suggestion, isDisplayStringHTML, () -> callback.onSuggestionSelected((SuggestOracle.Suggestion)suggestion));
            menuItem.addStyleName("item-" + (isEven ? "even" : "odd"));
            if (!suggestion.isSupported()) {
                menuItem.addStyleName("item-unsupported");
            }
            return menuItem;
        }

        private void updateAutoHidePartner(Element newAutoHidePartner) {
            if (this.autoHidePartner != newAutoHidePartner) {
                if (this.autoHidePartner != null) {
                    this.suggestionPopup.removeAutoHidePartner(this.autoHidePartner);
                }
                this.suggestionPopup.addAutoHidePartner(newAutoHidePartner);
                this.autoHidePartner = newAutoHidePartner;
            }
        }

        public boolean isAnimationEnabled() {
            return this.suggestionPopup.isAnimationEnabled();
        }

        public void setAnimationEnabled(boolean enable) {
            this.suggestionPopup.setAnimationEnabled(enable);
        }
    }

    private static class ExtractionFunctionSuggestionMenu
    extends MenuBar {
        public ExtractionFunctionSuggestionMenu(boolean vertical) {
            super(vertical);
            this.setStyleName("statisticSuggestBoxPopupContent");
            this.setFocusOnHoverEnabled(false);
        }

        public int size() {
            return this.getItems().size();
        }

        public int getSelectedIndex() {
            MenuItem selectedItem = this.getSelectedItem();
            return selectedItem == null ? -1 : this.getItems().indexOf(selectedItem);
        }

        public void selectItem(int index) {
            if (index >= 0 && index < this.size()) {
                MenuItem itemToSelect = (MenuItem)this.getItems().get(index);
                this.selectItem(itemToSelect);
                itemToSelect.getElement().scrollIntoView();
            }
        }

        public SuggestOracle.Suggestion getSelectedSuggestion() {
            return ((SuggestionMenuItem)this.getSelectedItem()).getSuggestion();
        }
    }

    private static class SuggestionMenuItem
    extends MenuItem {
        private final SuggestOracle.Suggestion suggestion;

        public SuggestionMenuItem(SuggestOracle.Suggestion suggestion, boolean asHTML, Scheduler.ScheduledCommand command) {
            super(suggestion.getDisplayString(), asHTML, command);
            this.suggestion = suggestion;
            this.setStyleName("item");
        }

        public SuggestOracle.Suggestion getSuggestion() {
            return this.suggestion;
        }
    }

    private static class UnsupportedExtractionFunctionsSeparator
    extends MenuItemSeparator {
        public UnsupportedExtractionFunctionsSeparator(String text) {
            this.setStyleName("separator-message");
            this.getElement().getFirstChildElement().setInnerText(text);
        }
    }

    @FunctionalInterface
    public static interface ValueChangeHandler {
        public void valueChanged(ExtractionFunctionWithContext var1, ExtractionFunctionWithContext var2);
    }
}

