/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.ui.client.selection;

import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.text.shared.Renderer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ValueListBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.common.Util;
import com.sap.sse.common.settings.SerializableSettings;
import com.sap.sse.common.util.NaturalComparator;
import com.sap.sse.datamining.shared.dto.StatisticQueryDefinitionDTO;
import com.sap.sse.datamining.shared.impl.dto.DataRetrieverChainDefinitionDTO;
import com.sap.sse.datamining.shared.impl.dto.FunctionDTO;
import com.sap.sse.datamining.ui.client.AbstractDataMiningComponent;
import com.sap.sse.datamining.ui.client.DataMiningServiceAsync;
import com.sap.sse.datamining.ui.client.DataRetrieverChainDefinitionProvider;
import com.sap.sse.datamining.ui.client.GroupingChangedListener;
import com.sap.sse.datamining.ui.client.GroupingProvider;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import com.sap.sse.gwt.client.shared.controls.AbstractObjectRenderer;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class MultiDimensionalGroupingProvider
extends AbstractDataMiningComponent<SerializableSettings>
implements GroupingProvider {
    private static final String GroupingProviderStyle = "groupingProvider";
    private static final String GroupingProviderLabelStyle = "groupingProviderLabel";
    private static final String GroupingProviderElementStyle = "groupingProviderElement";
    private static final NaturalComparator NaturalComparator = new NaturalComparator();
    private static final Comparator<FunctionDTO> DimensionComparator = (d1, d2) -> {
        if (d1 == null || d2 == null) {
            if (d1 == d2) {
                return 0;
            }
            if (d1 == null) {
                return -1;
            }
            if (d2 == null) {
                return 1;
            }
        }
        return NaturalComparator.compare(d1.getDisplayName(), d2.getDisplayName());
    };
    private final DataMiningServiceAsync dataMiningService;
    private final ErrorReporter errorReporter;
    private final Set<GroupingChangedListener> listeners;
    private final FlowPanel mainPanel;
    private final List<ValueListBox<FunctionDTO>> dimensionToGroupByBoxes;
    private boolean isAwaitingReload;
    private boolean isUpdating;
    private DataRetrieverChainDefinitionDTO currentRetrieverChainDefinition;
    private final List<FunctionDTO> availableDimensions;
    private Iterable<FunctionDTO> dimensionsToSelect;
    private DimensionMatcher dimensionMatcher;
    private Consumer<Iterable<String>> selectionCallback;

    public MultiDimensionalGroupingProvider(Component<?> parent, ComponentContext<?> context, DataMiningServiceAsync dataMiningService, ErrorReporter errorReporter, DataRetrieverChainDefinitionProvider retrieverChainProvider) {
        super(parent, context);
        this.dataMiningService = dataMiningService;
        this.errorReporter = errorReporter;
        this.listeners = new HashSet<GroupingChangedListener>();
        this.currentRetrieverChainDefinition = null;
        this.availableDimensions = new ArrayList<FunctionDTO>();
        this.isAwaitingReload = false;
        this.dimensionToGroupByBoxes = new ArrayList<ValueListBox<FunctionDTO>>();
        this.mainPanel = new FlowPanel();
        this.mainPanel.addStyleName(GroupingProviderStyle);
        Label groupByLabel = new Label(this.getDataMiningStringMessages().groupBy());
        groupByLabel.addStyleName(GroupingProviderLabelStyle);
        groupByLabel.addStyleName("emphasizedLabel");
        this.mainPanel.add((Widget)groupByLabel);
        ValueListBox<FunctionDTO> firstDimensionToGroupByBox = this.createDimensionToGroupByBox();
        this.addDimensionToGroupByBoxAndUpdateAcceptableValues(firstDimensionToGroupByBox);
        retrieverChainProvider.addDataRetrieverChainDefinitionChangedListener(this);
    }

    @Override
    public void awaitReloadComponents() {
        this.isAwaitingReload = true;
    }

    @Override
    public boolean isAwaitingReload() {
        return this.isAwaitingReload;
    }

    @Override
    public void reloadComponents() {
        this.isAwaitingReload = false;
        this.updateAvailableDimensions();
    }

    @Override
    public void dataRetrieverChainDefinitionChanged(DataRetrieverChainDefinitionDTO newRetrieverChainDefinition) {
        if (!Objects.equals(this.currentRetrieverChainDefinition, newRetrieverChainDefinition)) {
            this.currentRetrieverChainDefinition = newRetrieverChainDefinition;
            if (!this.isAwaitingReload) {
                this.updateAvailableDimensions();
            }
        }
    }

    private void updateAvailableDimensions() {
        Collection<FunctionDTO> currentDimensions = this.getDimensionsToGroupBy();
        if (!currentDimensions.isEmpty()) {
            this.dimensionsToSelect = currentDimensions;
            this.dimensionMatcher = (d1, d2) -> {
                if (d1 == d2) {
                    return true;
                }
                if (d1 == null || d2 == null) {
                    return false;
                }
                return d1.getDisplayName().equals(d2.getDisplayName());
            };
            this.selectionCallback = EmptyApplyCallback;
        }
        if (this.currentRetrieverChainDefinition != null) {
            this.isUpdating = true;
            this.dataMiningService.getDimensionsFor(this.currentRetrieverChainDefinition, LocaleInfo.getCurrentLocale().getLocaleName(), new AsyncCallback<HashSet<FunctionDTO>>(){

                public void onSuccess(HashSet<FunctionDTO> dimensions) {
                    MultiDimensionalGroupingProvider.this.clear();
                    for (FunctionDTO dimension : dimensions) {
                        MultiDimensionalGroupingProvider.this.availableDimensions.add(dimension);
                    }
                    ValueListBox firstDimensionToGroupByBox = MultiDimensionalGroupingProvider.this.createDimensionToGroupByBox();
                    MultiDimensionalGroupingProvider.this.addDimensionToGroupByBoxAndUpdateAcceptableValues((ValueListBox<FunctionDTO>)firstDimensionToGroupByBox);
                    if (!MultiDimensionalGroupingProvider.this.availableDimensions.isEmpty()) {
                        Collections.sort(MultiDimensionalGroupingProvider.this.availableDimensions, DimensionComparator);
                        if (MultiDimensionalGroupingProvider.this.dimensionsToSelect != null) {
                            MultiDimensionalGroupingProvider.this.setSelectedDimensions(MultiDimensionalGroupingProvider.this.dimensionsToSelect, MultiDimensionalGroupingProvider.this.dimensionMatcher, MultiDimensionalGroupingProvider.this.selectionCallback);
                        } else {
                            Optional dimensionWithLowestOrdinal = MultiDimensionalGroupingProvider.this.availableDimensions.stream().min((d1, d2) -> {
                                int ordinal1 = d1 == null ? Integer.MAX_VALUE : d1.getOrdinal();
                                int ordinal2 = d2 == null ? Integer.MAX_VALUE : d2.getOrdinal();
                                return Integer.compare(ordinal1, ordinal2);
                            });
                            dimensionWithLowestOrdinal.ifPresent(d -> firstDimensionToGroupByBox.setValue(d, true));
                        }
                        MultiDimensionalGroupingProvider.this.dimensionsToSelect = null;
                        MultiDimensionalGroupingProvider.this.dimensionMatcher = null;
                        MultiDimensionalGroupingProvider.this.selectionCallback = null;
                    } else {
                        MultiDimensionalGroupingProvider.this.notifyListeners();
                    }
                    MultiDimensionalGroupingProvider.this.isUpdating = false;
                }

                public void onFailure(Throwable caught) {
                    MultiDimensionalGroupingProvider.this.errorReporter.reportError("Error fetching the dimensions from the server: " + caught.getMessage());
                    MultiDimensionalGroupingProvider.this.dimensionsToSelect = null;
                    MultiDimensionalGroupingProvider.this.dimensionMatcher = null;
                    MultiDimensionalGroupingProvider.this.selectionCallback = null;
                    MultiDimensionalGroupingProvider.this.isUpdating = false;
                }
            });
        } else {
            this.clear();
            ValueListBox<FunctionDTO> firstDimensionToGroupByBox = this.createDimensionToGroupByBox();
            this.addDimensionToGroupByBoxAndUpdateAcceptableValues(firstDimensionToGroupByBox);
        }
    }

    private void clear() {
        this.clearDimensionBoxes();
        this.availableDimensions.clear();
    }

    private void clearDimensionBoxes() {
        for (ValueListBox<FunctionDTO> dimensionBox : this.dimensionToGroupByBoxes) {
            dimensionBox.removeFromParent();
        }
        this.dimensionToGroupByBoxes.clear();
    }

    @Override
    public Iterable<FunctionDTO> getAvailableDimensions() {
        return Collections.unmodifiableList(this.availableDimensions);
    }

    @Override
    public void setDimensionToGroupBy(int i, FunctionDTO dimensionToGroupBy) {
        this.dimensionToGroupByBoxes.get(i).setValue((Object)dimensionToGroupBy, true);
    }

    private ValueListBox<FunctionDTO> createDimensionToGroupByBox() {
        final ValueListBox<FunctionDTO> dimensionToGroupByBox = this.createDimensionToGroupByBoxWithoutEventHandler();
        dimensionToGroupByBox.addStyleName("dataMiningListBox");
        dimensionToGroupByBox.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<FunctionDTO>(){
            private boolean firstChange = true;

            public void onValueChange(ValueChangeEvent<FunctionDTO> event) {
                if (this.firstChange && event.getValue() != null) {
                    ValueListBox newDimensionToGroupByBox = MultiDimensionalGroupingProvider.this.createDimensionToGroupByBox();
                    MultiDimensionalGroupingProvider.this.addDimensionToGroupByBox((ValueListBox<FunctionDTO>)newDimensionToGroupByBox);
                    this.firstChange = false;
                } else if (event.getValue() == null) {
                    MultiDimensionalGroupingProvider.this.mainPanel.remove((Widget)dimensionToGroupByBox);
                    MultiDimensionalGroupingProvider.this.dimensionToGroupByBoxes.remove(dimensionToGroupByBox);
                }
                MultiDimensionalGroupingProvider.this.updateAcceptableValues();
                MultiDimensionalGroupingProvider.this.notifyListeners();
            }
        });
        return dimensionToGroupByBox;
    }

    @Override
    public ValueListBox<FunctionDTO> createDimensionToGroupByBoxWithoutEventHandler() {
        ValueListBox dimensionToGroupByBox = new ValueListBox((Renderer)new AbstractObjectRenderer<FunctionDTO>(){

            protected String convertObjectToString(FunctionDTO function) {
                return function.getDisplayName();
            }
        });
        dimensionToGroupByBox.addStyleName(GroupingProviderElementStyle);
        return dimensionToGroupByBox;
    }

    private void addDimensionToGroupByBoxAndUpdateAcceptableValues(ValueListBox<FunctionDTO> dimensionToGroupByBox) {
        this.addDimensionToGroupByBox(dimensionToGroupByBox);
        this.updateAcceptableValues();
    }

    private void addDimensionToGroupByBox(ValueListBox<FunctionDTO> dimensionToGroupByBox) {
        this.mainPanel.add(dimensionToGroupByBox);
        this.dimensionToGroupByBoxes.add(dimensionToGroupByBox);
    }

    private void updateAcceptableValues() {
        for (ValueListBox<FunctionDTO> dimensionToGroupByBox : this.dimensionToGroupByBoxes) {
            ArrayList<FunctionDTO> acceptableValues = new ArrayList<FunctionDTO>(this.availableDimensions);
            acceptableValues.removeAll(this.getDimensionsToGroupBy());
            if (dimensionToGroupByBox.getValue() != null) {
                acceptableValues.add((FunctionDTO)dimensionToGroupByBox.getValue());
            }
            if (!acceptableValues.isEmpty()) {
                acceptableValues.add(null);
                Collections.sort(acceptableValues, DimensionComparator);
            } else {
                dimensionToGroupByBox.setEnabled(false);
            }
            dimensionToGroupByBox.setAcceptableValues(acceptableValues);
        }
    }

    @Override
    public Collection<FunctionDTO> getDimensionsToGroupBy() {
        ArrayList<FunctionDTO> dimensionsToGroupBy = new ArrayList<FunctionDTO>();
        for (ValueListBox<FunctionDTO> dimensionListBox : this.dimensionToGroupByBoxes) {
            if (dimensionListBox.getValue() == null) continue;
            dimensionsToGroupBy.add((FunctionDTO)dimensionListBox.getValue());
        }
        return dimensionsToGroupBy;
    }

    @Override
    public void removeDimensionToGroupBy(FunctionDTO dimension) {
        Iterator<ValueListBox<FunctionDTO>> i = this.dimensionToGroupByBoxes.iterator();
        while (i.hasNext()) {
            ValueListBox<FunctionDTO> dimensionListBox = i.next();
            if (!Util.equalsWithNull((Object)dimension, (Object)dimensionListBox.getValue())) continue;
            i.remove();
            dimensionListBox.removeFromParent();
            this.updateAcceptableValues();
            this.notifyListeners();
        }
    }

    @Override
    public void applyQueryDefinition(StatisticQueryDefinitionDTO queryDefinition, Consumer<Iterable<String>> callback) {
        DataRetrieverChainDefinitionDTO newRetrieverChain = queryDefinition.getDataRetrieverChainDefinition();
        this.dimensionsToSelect = queryDefinition.getDimensionsToGroupBy();
        this.dimensionMatcher = Objects::equals;
        this.selectionCallback = callback;
        if (!this.isAwaitingReload && !this.isUpdating && this.currentRetrieverChainDefinition.equals((Object)newRetrieverChain)) {
            this.clearDimensionBoxes();
            ValueListBox<FunctionDTO> firstDimensionToGroupByBox = this.createDimensionToGroupByBox();
            this.addDimensionToGroupByBoxAndUpdateAcceptableValues(firstDimensionToGroupByBox);
            this.setSelectedDimensions(this.dimensionsToSelect, this.dimensionMatcher, this.selectionCallback);
            this.dimensionsToSelect = null;
            this.dimensionMatcher = null;
            this.selectionCallback = null;
        }
    }

    private void setSelectedDimensions(Iterable<FunctionDTO> dimensions, DimensionMatcher matcher, Consumer<Iterable<String>> callback) {
        ArrayList<FunctionDTO> missingDimensions = new ArrayList<FunctionDTO>();
        int boxIndex = 0;
        for (FunctionDTO dimension : dimensions) {
            FunctionDTO dimensionToSelect = null;
            int i = 0;
            while (i < this.availableDimensions.size()) {
                FunctionDTO availableDimension = this.availableDimensions.get(i);
                if (matcher.test(dimension, availableDimension)) {
                    dimensionToSelect = availableDimension;
                    break;
                }
                ++i;
            }
            if (dimensionToSelect != null) {
                this.setDimensionToGroupBy(boxIndex, dimensionToSelect);
                ++boxIndex;
                continue;
            }
            missingDimensions.add(dimension);
        }
        if (!missingDimensions.isEmpty()) {
            String listedDimensions = missingDimensions.stream().map(FunctionDTO::getDisplayName).collect(Collectors.joining(", "));
            callback.accept(Collections.singleton(this.getDataMiningStringMessages().groupingDimensionsAreNotAvailable(listedDimensions)));
        } else {
            callback.accept(Collections.emptySet());
        }
    }

    @Override
    public void addGroupingChangedListener(GroupingChangedListener listener) {
        this.listeners.add(listener);
    }

    private void notifyListeners() {
        for (GroupingChangedListener listener : this.listeners) {
            listener.groupingChanged();
        }
    }

    public String getLocalizedShortName() {
        return this.getDataMiningStringMessages().groupingProvider();
    }

    public Widget getEntryWidget() {
        return this.mainPanel;
    }

    public boolean isVisible() {
        return this.mainPanel.isVisible();
    }

    public void setVisible(boolean visibility) {
        this.mainPanel.setVisible(visibility);
    }

    public boolean hasSettings() {
        return false;
    }

    public SettingsDialogComponent<SerializableSettings> getSettingsDialogComponent(SerializableSettings settings) {
        return null;
    }

    public void updateSettings(SerializableSettings newSettings) {
    }

    public String getDependentCssClassName() {
        return "multiDimensionalGroupingProvider";
    }

    public SerializableSettings getSettings() {
        return null;
    }

    public String getId() {
        return "MultiDimensionalGroupingProvider";
    }

    @FunctionalInterface
    private static interface DimensionMatcher
    extends BiPredicate<FunctionDTO, FunctionDTO> {
    }
}

