/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.ui.client.selection;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CheckboxCell;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.shared.GWT;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Style;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.user.cellview.client.AbstractCellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.DataGrid;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.LayoutPanel;
import com.google.gwt.user.client.ui.ToggleButton;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.DefaultSelectionEventManager;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.MultiSelectionModel;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.sap.sse.common.Util;
import com.sap.sse.common.settings.SerializableSettings;
import com.sap.sse.common.util.NaturalComparator;
import com.sap.sse.datamining.shared.DataMiningSession;
import com.sap.sse.datamining.shared.data.ReportParameterToDimensionFilterBindings;
import com.sap.sse.datamining.shared.dto.DataMiningReportDTO;
import com.sap.sse.datamining.shared.dto.FilterDimensionIdentifier;
import com.sap.sse.datamining.shared.dto.FilterDimensionParameter;
import com.sap.sse.datamining.shared.impl.GenericGroupKey;
import com.sap.sse.datamining.shared.impl.dto.DataRetrieverLevelDTO;
import com.sap.sse.datamining.shared.impl.dto.FunctionDTO;
import com.sap.sse.datamining.shared.impl.dto.QueryResultDTO;
import com.sap.sse.datamining.shared.impl.dto.parameters.ParameterModelListener;
import com.sap.sse.datamining.ui.client.AbstractDataMiningComponent;
import com.sap.sse.datamining.ui.client.DataMiningServiceAsync;
import com.sap.sse.datamining.ui.client.DataRetrieverChainDefinitionProvider;
import com.sap.sse.datamining.ui.client.FilterSelectionChangedListener;
import com.sap.sse.datamining.ui.client.FilterSelectionProvider;
import com.sap.sse.datamining.ui.client.ReportProvider;
import com.sap.sse.datamining.ui.client.resources.DataMiningDataGridResources;
import com.sap.sse.datamining.ui.client.resources.DataMiningResources;
import com.sap.sse.datamining.ui.client.selection.PickOrCreateReportParameterDialog;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.StringMessages;
import com.sap.sse.gwt.client.controls.busyindicator.SimpleBusyIndicator;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.panels.AbstractFilterablePanel;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class DimensionFilterSelectionProvider
extends AbstractDataMiningComponent<SerializableSettings>
implements ParameterModelListener {
    private static final DataMiningResources Resources = (DataMiningResources)GWT.create(DataMiningResources.class);
    private static final NaturalComparator NaturalComparator = new NaturalComparator();
    private final DataMiningServiceAsync dataMiningService;
    private final ErrorReporter errorReporter;
    private final DataMiningSession session;
    private final Set<FilterSelectionChangedListener> listeners;
    private final DataRetrieverChainDefinitionProvider retrieverChainProvider;
    private final FilterSelectionProvider filterSelectionProvider;
    private final DataRetrieverLevelDTO retrieverLevel;
    private final FunctionDTO dimension;
    private final DockLayoutPanel mainPanel;
    private final AbstractFilterablePanel<Serializable> filterPanel;
    private final LayoutPanel contentContainer;
    private final SimpleBusyIndicator busyIndicator;
    private final Set<Serializable> availableData;
    private final ListDataProvider<Serializable> filteredData;
    private final MultiSelectionModel<Serializable> selectionModel;
    private final DataGrid<Serializable> dataGrid;
    private final Column<Serializable, Boolean> checkboxColumn;
    private FilterDimensionParameter parameter;
    private ReportProvider reportProvider;
    private final ToggleButton parameterSettingsButton;
    private final ReportParameterToDimensionFilterBindings reportParameterBindings;
    private String searchInputToApply;
    private Iterable<? extends Serializable> selectionToBeApplied;
    private Consumer<Iterable<String>> selectionCallback;
    private boolean dontPropagateNextSelectionChangeEventToBoundParameter;

    public DimensionFilterSelectionProvider(Component<?> parent, ComponentContext<?> componentContext, DataMiningServiceAsync dataMiningService, ErrorReporter errorReporter, DataMiningSession session, DataRetrieverChainDefinitionProvider retrieverChainProvider, FilterSelectionProvider filterSelectionProvider, DataRetrieverLevelDTO retrieverLevel, FunctionDTO dimension, ReportParameterToDimensionFilterBindings reportParameterBindings, ReportProvider reportProvider) {
        super(parent, componentContext);
        this.dataMiningService = dataMiningService;
        this.errorReporter = errorReporter;
        this.session = session;
        this.retrieverChainProvider = retrieverChainProvider;
        this.filterSelectionProvider = filterSelectionProvider;
        this.retrieverLevel = retrieverLevel;
        this.dimension = dimension;
        this.reportParameterBindings = reportParameterBindings;
        this.reportProvider = reportProvider;
        this.listeners = new HashSet<FilterSelectionChangedListener>();
        DataMiningDataGridResources dataGridResources = (DataMiningDataGridResources)GWT.create(DataMiningDataGridResources.class);
        this.dataGrid = new DataGrid(Integer.MAX_VALUE, (DataGrid.Resources)dataGridResources);
        this.dataGrid.setAutoHeaderRefreshDisabled(true);
        this.dataGrid.setAutoFooterRefreshDisabled(true);
        this.dataGrid.addStyleName("dataMiningBorderTop");
        this.availableData = new HashSet<Serializable>();
        this.filteredData = new ListDataProvider(this::elementAsString);
        this.filterPanel = new AbstractFilterablePanel<Serializable>(null, this.filteredData, (StringMessages)this.getDataMiningStringMessages()){

            public Iterable<String> getSearchableStrings(Serializable element) {
                return Collections.singleton(DimensionFilterSelectionProvider.this.elementAsString(element));
            }

            public AbstractCellTable<Serializable> getCellTable() {
                return DimensionFilterSelectionProvider.this.dataGrid;
            }
        };
        this.filterPanel.setWidth("100%");
        this.filterPanel.setSpacing(1);
        this.filterPanel.getTextBox().setWidth("100%");
        this.filteredData.addDataDisplay(this.dataGrid);
        this.selectionModel = new MultiSelectionModel(this::elementAsString);
        this.selectionModel.addSelectionChangeHandler(this::selectionChanged);
        this.dataGrid.setSelectionModel(this.selectionModel, (CellPreviewEvent.Handler)DefaultSelectionEventManager.createCustomManager((DefaultSelectionEventManager.EventTranslator)new CustomCheckboxEventTranslator()));
        this.checkboxColumn = new Column<Serializable, Boolean>((Cell)new CheckboxCell(true, false)){

            public Boolean getValue(Serializable object) {
                return DimensionFilterSelectionProvider.this.selectionModel.isSelected((Object)object);
            }
        };
        this.dataGrid.addColumn(this.checkboxColumn);
        TextColumn<Serializable> contentColumn = new TextColumn<Serializable>(){

            public String getValue(Serializable element) {
                return DimensionFilterSelectionProvider.this.elementAsString(element);
            }
        };
        contentColumn.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        this.dataGrid.addColumn((Column)contentColumn);
        this.busyIndicator = new SimpleBusyIndicator(false, 0.85f);
        this.busyIndicator.getElement().getStyle().setTextAlign(Style.TextAlign.CENTER);
        this.contentContainer = new LayoutPanel();
        this.contentContainer.add((Widget)this.busyIndicator);
        this.contentContainer.setWidgetTopBottom((Widget)this.busyIndicator, 10.0, Style.Unit.PX, 10.0, Style.Unit.PX);
        this.contentContainer.setWidgetLeftRight((Widget)this.busyIndicator, 10.0, Style.Unit.PX, 10.0, Style.Unit.PX);
        Image parameterIcon = new Image(Resources.parameterIcon().getSafeUri());
        parameterIcon.setSize("16px", "16px");
        this.parameterSettingsButton = new ToggleButton(parameterIcon);
        this.parameterSettingsButton.addStyleName("query-parameter");
        this.updateParameterFromReportParameterBindings();
        this.mainPanel = new DockLayoutPanel(Style.Unit.PX);
        this.mainPanel.addNorth(this.createHeaderPanel(), 40.0);
        this.mainPanel.addNorth(this.filterPanel, 35.0);
        this.mainPanel.setWidgetHidden(this.filterPanel, true);
        this.mainPanel.add((Widget)this.contentContainer);
        this.updateContent(null);
    }

    private Widget createHeaderPanel() {
        HorizontalPanel headerPanel = new HorizontalPanel();
        headerPanel.setSpacing(2);
        headerPanel.setWidth("100%");
        headerPanel.setHeight("100%");
        headerPanel.addStyleName("dimensionFilterSelectionHeader");
        headerPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        Label headerLabel = new Label(this.dimension.getDisplayName());
        headerLabel.addStyleName("emphasizedLabel");
        headerPanel.add((Widget)headerLabel);
        headerPanel.setCellWidth((Widget)headerLabel, "100%");
        headerPanel.setCellHorizontalAlignment((Widget)headerLabel, HasHorizontalAlignment.ALIGN_CENTER);
        this.parameterSettingsButton.addClickHandler(e -> {
            if (this.parameter == null) {
                DataMiningReportDTO currentReport = this.reportProvider.getCurrentReport().getReport();
                final Set reportParametersBeforeDialogShown = Util.asNewSet((Iterable)currentReport.getParameters());
                new PickOrCreateReportParameterDialog(currentReport, this.dimension.getReturnTypeName(), this.getDataMiningStringMessages(), new DataEntryDialog.DialogCallback<FilterDimensionParameter>(){

                    public void ok(FilterDimensionParameter editedObject) {
                        if (editedObject == null) {
                            if (DimensionFilterSelectionProvider.this.parameter != null) {
                                DimensionFilterSelectionProvider.this.unbindFromParameter(DimensionFilterSelectionProvider.this.parameter);
                            }
                            DimensionFilterSelectionProvider.this.parameterSettingsButton.setDown(false);
                        } else {
                            DimensionFilterSelectionProvider.this.parameter = editedObject;
                            DimensionFilterSelectionProvider.this.reportParameterBindings.setParameterBinding(new FilterDimensionIdentifier(DimensionFilterSelectionProvider.this.retrieverLevel, DimensionFilterSelectionProvider.this.dimension), editedObject);
                            GWT.log((String)("New parameter bindings " + DimensionFilterSelectionProvider.this.reportParameterBindings));
                            if (Util.contains((Iterable)reportParametersBeforeDialogShown, (Object)editedObject)) {
                                GWT.log((String)("Propagating parameter value of " + DimensionFilterSelectionProvider.this.parameter.getName() + " to " + DimensionFilterSelectionProvider.this.retrieverLevel + "/" + DimensionFilterSelectionProvider.this.dimension + ": " + editedObject.getValues()));
                                DimensionFilterSelectionProvider.this.parameterValueChanged(editedObject, Collections.emptySet());
                            } else {
                                GWT.log((String)("Setting parameter value of " + DimensionFilterSelectionProvider.this.parameter.getName() + " from " + DimensionFilterSelectionProvider.this.retrieverLevel + "/" + DimensionFilterSelectionProvider.this.dimension + " to " + DimensionFilterSelectionProvider.this.selectionModel.getSelectedSet()));
                                DimensionFilterSelectionProvider.this.dontPropagateNextSelectionChangeEventToBoundParameter = true;
                                DimensionFilterSelectionProvider.this.parameter.setValues((Iterable)DimensionFilterSelectionProvider.this.selectionModel.getSelectedSet());
                                DimensionFilterSelectionProvider.this.dontPropagateNextSelectionChangeEventToBoundParameter = false;
                            }
                            editedObject.addParameterModelListener((ParameterModelListener)DimensionFilterSelectionProvider.this);
                        }
                    }

                    public void cancel() {
                        DimensionFilterSelectionProvider.this.parameterSettingsButton.setDown(false);
                    }
                }).show();
            } else {
                this.unbindFromParameter(this.parameter);
            }
        });
        headerPanel.add((Widget)this.parameterSettingsButton);
        headerPanel.setCellHorizontalAlignment((Widget)this.parameterSettingsButton, HasHorizontalAlignment.ALIGN_RIGHT);
        ToggleButton toggleFilterButton = new ToggleButton(new Image(Resources.searchIcon()));
        toggleFilterButton.setTitle(this.getDataMiningStringMessages().filterDimensionValues());
        toggleFilterButton.addClickHandler(e -> {
            boolean enabled = toggleFilterButton.isDown();
            this.mainPanel.setWidgetHidden(this.filterPanel, !enabled);
            if (enabled) {
                Scheduler.get().scheduleDeferred(() -> {
                    this.filterPanel.getTextBox().setFocus(true);
                    this.filterPanel.getTextBox().selectAll();
                });
            }
            if (enabled) {
                this.filterPanel.search(this.searchInputToApply);
            } else {
                this.searchInputToApply = this.filterPanel.getTextBox().getValue();
                this.filterPanel.search(null);
            }
        });
        headerPanel.add((Widget)toggleFilterButton);
        headerPanel.setCellHorizontalAlignment((Widget)toggleFilterButton, HasHorizontalAlignment.ALIGN_RIGHT);
        return headerPanel;
    }

    public void removedFromContainer() {
        if (this.parameter != null) {
            this.parameter.removeParameterModelListener((ParameterModelListener)this);
            this.parameter = null;
        }
    }

    public void updateContent(final Runnable callback) {
        HashMap<DataRetrieverLevelDTO, SerializableSettings> retrieverSettings = this.retrieverChainProvider.getRetrieverSettings();
        HashMap<DataRetrieverLevelDTO, HashMap<FunctionDTO, HashSet<? extends Serializable>>> filterSelection = this.filterSelectionProvider.getSelection();
        if (filterSelection.containsKey(this.retrieverLevel)) {
            filterSelection.get(this.retrieverLevel).remove(this.dimension);
        }
        HashSet<FunctionDTO> dimensions = new HashSet<FunctionDTO>();
        dimensions.add(this.dimension);
        this.availableData.clear();
        this.contentContainer.remove(this.dataGrid);
        this.busyIndicator.setBusy(true);
        this.dataMiningService.getDimensionValuesFor(this.session, this.retrieverChainProvider.getDataRetrieverChainDefinition(), this.retrieverLevel, dimensions, retrieverSettings, filterSelection, LocaleInfo.getCurrentLocale().getLocaleName(), new AsyncCallback<QueryResultDTO<HashSet<Object>>>(){

            public void onSuccess(QueryResultDTO<HashSet<Object>> result) {
                Map results = result.getResults();
                ArrayList sortedData = new ArrayList();
                if (!results.isEmpty()) {
                    GenericGroupKey contentKey = new GenericGroupKey((Object)DimensionFilterSelectionProvider.this.dimension);
                    Collection resultsForContentKey = (Collection)results.get(contentKey);
                    DimensionFilterSelectionProvider.this.availableData.addAll(resultsForContentKey);
                    sortedData.addAll(DimensionFilterSelectionProvider.this.availableData);
                    sortedData.sort((o1, o2) -> NaturalComparator.compare(o1.toString(), o2.toString()));
                }
                DimensionFilterSelectionProvider.this.busyIndicator.setBusy(false);
                DimensionFilterSelectionProvider.this.filterPanel.updateAll(sortedData);
                DimensionFilterSelectionProvider.this.contentContainer.add((Widget)DimensionFilterSelectionProvider.this.dataGrid);
                DimensionFilterSelectionProvider.this.internalSetSelection(DimensionFilterSelectionProvider.this.selectionToBeApplied != null ? DimensionFilterSelectionProvider.this.selectionToBeApplied : DimensionFilterSelectionProvider.this.selectionModel.getSelectedSet(), DimensionFilterSelectionProvider.this.selectionCallback != null ? DimensionFilterSelectionProvider.this.selectionCallback : m -> {});
                DimensionFilterSelectionProvider.this.selectionToBeApplied = null;
                DimensionFilterSelectionProvider.this.selectionCallback = null;
                if (callback != null) {
                    callback.run();
                }
            }

            public void onFailure(Throwable caught) {
                DimensionFilterSelectionProvider.this.errorReporter.reportError("Error fetching the dimension values of " + DimensionFilterSelectionProvider.this.dimension + ": " + caught.getMessage());
                DimensionFilterSelectionProvider.this.selectionToBeApplied = null;
                DimensionFilterSelectionProvider.this.selectionCallback = null;
            }
        });
    }

    private String elementAsString(Object element) {
        return element.toString();
    }

    private void selectionChanged(SelectionChangeEvent event) {
        if (this.parameter != null) {
            if (this.dontPropagateNextSelectionChangeEventToBoundParameter) {
                GWT.log((String)("Ignoring selection change for " + this.retrieverLevel + "/" + this.dimension));
            } else {
                GWT.log((String)("Propagating selection change for " + this.retrieverLevel + "/" + this.dimension + " to parameter " + this.parameter.getName() + "; new value set: " + this.selectionModel.getSelectedSet()));
                this.parameter.removeParameterModelListener((ParameterModelListener)this);
                this.parameter.setValues((Iterable)this.selectionModel.getSelectedSet());
                this.parameter.addParameterModelListener((ParameterModelListener)this);
            }
        }
        this.notifyListeners();
    }

    public HashSet<? extends Serializable> getSelection() {
        return new HashSet(this.selectionModel.getSelectedSet());
    }

    public void setSelection(Iterable<? extends Serializable> selection, Consumer<Iterable<String>> callback) {
        this.updateParameterFromReportParameterBindings();
        this.selectionToBeApplied = selection;
        this.selectionCallback = callback;
        if (!this.busyIndicator.isBusy()) {
            this.internalSetSelection(this.selectionToBeApplied, this.selectionCallback);
            this.selectionToBeApplied = null;
            this.selectionCallback = null;
        }
    }

    private void updateParameterFromReportParameterBindings() {
        FilterDimensionParameter newParameter = this.reportParameterBindings.getParameterBinding(new FilterDimensionIdentifier(this.retrieverLevel, this.dimension));
        if (this.parameter != newParameter) {
            if (this.parameter != null) {
                this.parameter.removeParameterModelListener((ParameterModelListener)this);
            }
            if (newParameter != null) {
                newParameter.addParameterModelListener((ParameterModelListener)this);
            }
        }
        this.parameterSettingsButton.setDown(newParameter != null);
        this.parameter = newParameter;
    }

    private void internalSetSelection(Iterable<? extends Serializable> selection, Consumer<Iterable<String>> callback) {
        this.dontPropagateNextSelectionChangeEventToBoundParameter = true;
        this.clearSelection();
        ArrayList<Serializable> missingValues = new ArrayList<Serializable>();
        for (Serializable serializable : selection) {
            if (this.availableData.contains(serializable)) {
                this.selectionModel.setSelected((Object)serializable, true);
                continue;
            }
            if (this.parameter != null && Util.contains((Iterable)this.parameter.getValues(), (Object)serializable)) continue;
            missingValues.add(serializable);
        }
        this.selectionModel.getSelectedSet();
        this.dontPropagateNextSelectionChangeEventToBoundParameter = false;
        if (!missingValues.isEmpty()) {
            String string = missingValues.stream().map(this::elementAsString).collect(Collectors.joining(", "));
            callback.accept(Collections.singleton(this.getDataMiningStringMessages().filterValuesOfDimensionAreNotAvailable(this.dimension.getDisplayName(), string)));
        } else {
            callback.accept(Collections.emptySet());
        }
    }

    public void clearSelection() {
        this.selectionModel.clear();
    }

    public void addListener(FilterSelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    private void notifyListeners() {
        for (FilterSelectionChangedListener listener : this.listeners) {
            listener.selectionChanged();
        }
    }

    public Widget getEntryWidget() {
        return this.mainPanel;
    }

    public String getId() {
        return "DimensionFilterSelectionProvider";
    }

    public String getLocalizedShortName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public boolean isVisible() {
        return this.getEntryWidget().isVisible();
    }

    public void setVisible(boolean visibility) {
        this.getEntryWidget().setVisible(visibility);
    }

    public boolean hasSettings() {
        return false;
    }

    public SettingsDialogComponent<SerializableSettings> getSettingsDialogComponent(SerializableSettings settings) {
        return null;
    }

    public SerializableSettings getSettings() {
        return null;
    }

    public void updateSettings(SerializableSettings newSettings) {
    }

    public String getDependentCssClassName() {
        return "dimensionFilterSelectionProvider";
    }

    public void parameterAdded(DataMiningReportDTO report, FilterDimensionParameter parameter) {
    }

    public void parameterRemoved(DataMiningReportDTO report, FilterDimensionParameter parameter) {
        if (parameter == this.parameter) {
            this.unbindFromParameter(parameter);
        }
    }

    private void unbindFromParameter(FilterDimensionParameter parameter) {
        parameter.removeParameterModelListener((ParameterModelListener)this);
        this.reportParameterBindings.removeParameterBinding(new FilterDimensionIdentifier(this.retrieverLevel, this.dimension));
        this.parameter = null;
    }

    public void parameterValueChanged(FilterDimensionParameter parameter, Iterable<? extends Serializable> oldValues) {
        GWT.log((String)("Filter parameter " + parameter.getName() + " with type " + parameter.getTypeName() + " and bound to dimension filter " + this.retrieverLevel + "/" + this.dimension + " changed from " + oldValues + " to " + parameter.getValues()));
        this.dontPropagateNextSelectionChangeEventToBoundParameter = true;
        this.selectionModel.clear();
        for (Serializable newValue : parameter.getValues()) {
            this.selectionModel.setSelected((Object)newValue, true);
        }
        this.selectionModel.getSelectedSet();
        this.dontPropagateNextSelectionChangeEventToBoundParameter = false;
    }

    private class CustomCheckboxEventTranslator
    implements DefaultSelectionEventManager.EventTranslator<Serializable> {
        private CustomCheckboxEventTranslator() {
        }

        public boolean clearCurrentSelection(CellPreviewEvent<Serializable> event) {
            return !this.isCheckboxColumn(event.getColumn());
        }

        public DefaultSelectionEventManager.SelectAction translateSelectionEvent(CellPreviewEvent<Serializable> event) {
            NativeEvent nativeEvent = event.getNativeEvent();
            if ("click".equals(nativeEvent.getType())) {
                if (nativeEvent.getCtrlKey()) {
                    Serializable value = (Serializable)event.getValue();
                    DimensionFilterSelectionProvider.this.selectionModel.setSelected((Object)value, !DimensionFilterSelectionProvider.this.selectionModel.isSelected((Object)value));
                    return DefaultSelectionEventManager.SelectAction.IGNORE;
                }
                if (!DimensionFilterSelectionProvider.this.selectionModel.getSelectedSet().isEmpty() && !this.isCheckboxColumn(event.getColumn())) {
                    return DefaultSelectionEventManager.SelectAction.DEFAULT;
                }
            }
            return DefaultSelectionEventManager.SelectAction.TOGGLE;
        }

        private boolean isCheckboxColumn(int columnIndex) {
            return columnIndex == DimensionFilterSelectionProvider.this.dataGrid.getColumnIndex(DimensionFilterSelectionProvider.this.checkboxColumn);
        }
    }
}

