/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.ui.client.presentation.dataproviders;

import com.sap.sse.datamining.shared.impl.dto.QueryResultDTO;
import com.sap.sse.datamining.ui.client.presentation.dataproviders.AbstractNumericDataProvider;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.function.Function;

public abstract class AbstractNumericDataProviderWithStaticMappings<T extends Serializable>
extends AbstractNumericDataProvider<T> {
    private final LinkedHashMap<String, Function<T, Number>> mappings;

    protected AbstractNumericDataProviderWithStaticMappings(Class<T> resultType, LinkedHashMap<String, Function<T, Number>> mappings) {
        super(resultType);
        this.mappings = mappings;
    }

    @Override
    public Collection<String> getDataKeys(QueryResultDTO<?> result) {
        return this.mappings.keySet();
    }

    @Override
    public boolean isValidDataKey(QueryResultDTO<?> result, String dataKey) {
        return this.mappings.containsKey(dataKey);
    }

    @Override
    public String getDefaultDataKeyFor(QueryResultDTO<?> result) {
        return this.mappings.keySet().iterator().next();
    }

    @Override
    protected Function<T, Number> getMapping(QueryResultDTO<?> result, String dataKey) {
        return this.mappings.get(dataKey);
    }
}

