/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.queclinkadapter.impl;

import com.sap.sailing.domain.common.DeviceIdentifier;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.impl.GPSFixImpl;
import com.sap.sailing.domain.common.tracking.impl.GPSFixMovingImpl;
import com.sap.sailing.domain.queclinkadapter.FRIReport;
import com.sap.sailing.domain.queclinkadapter.MessageWithDeviceOrigin;
import com.sap.sailing.domain.queclinkadapter.PositionRelatedReport;
import com.sap.sailing.domain.racelog.tracking.SensorFixStore;
import com.sap.sailing.domain.racelogtracking.SmartphoneImeiIdentifier;
import com.sap.sailing.domain.racelogtracking.impl.SmartphoneImeiIdentifierImpl;
import com.sap.sse.common.Util;
import java.util.Arrays;

public class PositionRelatedReportToGPSFixConverter {
    public GPSFix createGPSFixFromPositionRelatedReport(PositionRelatedReport report) {
        Object result = report.getCogAndSog() != null ? new GPSFixMovingImpl(report.getPosition(), report.getValidityTime(), report.getCogAndSog(), null) : new GPSFixImpl(report.getPosition(), report.getValidityTime());
        return result;
    }

    public SmartphoneImeiIdentifier getDeviceIdentifier(MessageWithDeviceOrigin message) {
        return new SmartphoneImeiIdentifierImpl(message.getImei());
    }

    public void ingestFixesToStore(SensorFixStore store, FRIReport fixesReceived) {
        SmartphoneImeiIdentifier deviceIdentifier = this.getDeviceIdentifier(fixesReceived);
        Iterable fixes = Util.map(Arrays.asList(fixesReceived.getPositionRelatedReports()), this::createGPSFixFromPositionRelatedReport);
        store.storeFixes((DeviceIdentifier)deviceIdentifier, fixes, false, false);
    }
}

