/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.filestorage.impl;

import com.sap.sse.common.NoCorrespondingServiceRegisteredException;
import com.sap.sse.common.TypeBasedServiceFinder;
import com.sap.sse.filestorage.FileStorageService;
import com.sap.sse.filestorage.FileStorageServiceProperty;
import com.sap.sse.filestorage.FileStorageServicePropertyStore;
import com.sap.sse.filestorage.FileStorageServiceResolver;
import com.sap.sse.filestorage.impl.EmptyFileStorageServicePropertyStoreImpl;
import com.sap.sse.filestorage.impl.FileStorageServiceResolverAgainstOsgiRegistryImpl;
import com.sap.sse.filestorage.impl.ObjectInputStreamResolvingAgainstFileStorageServiceResolver;
import com.sap.sse.filestorage.impl.ReplicableFileStorageManagementService;
import com.sap.sse.filestorage.impl.ServiceAddedListener;
import com.sap.sse.filestorage.operations.FileStorageServiceOperation;
import com.sap.sse.filestorage.operations.SetActiveFileStorageServiceOperation;
import com.sap.sse.filestorage.operations.SetFileStorageServicePropertyOperation;
import com.sap.sse.replication.interfaces.impl.AbstractReplicableWithObjectInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileStorageManagementServiceImpl
extends AbstractReplicableWithObjectInputStream<ReplicableFileStorageManagementService, FileStorageServiceOperation<?>>
implements ReplicableFileStorageManagementService,
ServiceAddedListener<FileStorageService> {
    private final Logger logger = Logger.getLogger(FileStorageManagementServiceImpl.class.getName());
    private FileStorageService active;
    private final TypeBasedServiceFinder<FileStorageService> serviceFinder;
    private FileStorageServicePropertyStore propertyStore;
    private final FileStorageServiceResolver serviceResolver;

    public FileStorageManagementServiceImpl(TypeBasedServiceFinder<FileStorageService> serviceFinder, FileStorageServicePropertyStore propertyStore) {
        this.serviceFinder = serviceFinder;
        this.propertyStore = propertyStore;
        this.serviceResolver = new FileStorageServiceResolverAgainstOsgiRegistryImpl(serviceFinder);
        this.active = this.getFileStorageService(propertyStore.readActiveServiceName());
    }

    @Override
    public FileStorageService getActiveFileStorageService() {
        if (this.active == null) {
            throw new NoCorrespondingServiceRegisteredException();
        }
        return this.active;
    }

    @Override
    public void setActiveFileStorageService(FileStorageService service) {
        this.apply(new SetActiveFileStorageServiceOperation(service));
    }

    @Override
    public FileStorageService[] getAvailableFileStorageServices() {
        return this.serviceFinder.findAllServices().toArray(new FileStorageService[0]);
    }

    @Override
    public FileStorageService getFileStorageService(String name) {
        return this.serviceResolver.getFileStorageService(name);
    }

    @Override
    public void setFileStorageServiceProperty(FileStorageService service, String propertyName, String propertyValue) throws NoCorrespondingServiceRegisteredException, IllegalArgumentException {
        this.apply(new SetFileStorageServicePropertyOperation(service, propertyName, propertyValue));
    }

    @Override
    public void onServiceAdded(FileStorageService service) {
        this.logger.info("Found new FileStorageService: adding properties to " + service.getName());
        for (Map.Entry<String, String> property : this.propertyStore.readAllProperties(service.getName()).entrySet()) {
            try {
                service.internalSetProperty(property.getKey(), property.getValue());
            }
            catch (IllegalArgumentException e) {
                this.logger.log(Level.WARNING, "Couldn't add property " + property.getValue() + ": " + e.getMessage(), e);
            }
        }
    }

    @Override
    public Void internalSetFileStorageServiceProperty(FileStorageService service, String propertyName, String propertyValue) throws NoCorrespondingServiceRegisteredException, IllegalArgumentException {
        this.propertyStore.writeProperty(service.getName(), propertyName, propertyValue);
        service.internalSetProperty(propertyName, propertyValue);
        return null;
    }

    @Override
    public Void internalSetActiveFileStorageService(FileStorageService service) {
        this.propertyStore.writeActiveService(service == null ? null : service.getName());
        this.active = service;
        return null;
    }

    public ObjectInputStream createObjectInputStreamResolvingAgainstCache(InputStream is, Map<String, Class<?>> classLoaderCache) throws IOException {
        return new ObjectInputStreamResolvingAgainstFileStorageServiceResolver(is, this.serviceResolver, null, classLoaderCache);
    }

    public void initiallyFillFromInternal(ObjectInputStream is) throws IOException, ClassNotFoundException, InterruptedException {
        this.logger.info("Initializing file storage mgmt service state from initial load");
        this.propertyStore = EmptyFileStorageServicePropertyStoreImpl.INSTANCE;
        FileStorageService activeService = (FileStorageService)is.readObject();
        this.logger.info("Setting active file storage service: " + activeService);
        this.internalSetActiveFileStorageService(activeService);
        Map properties = (Map)is.readObject();
        for (FileStorageService service : properties.keySet()) {
            FileStorageServiceProperty[] fileStorageServicePropertyArray = (FileStorageServiceProperty[])properties.get(service);
            int n = fileStorageServicePropertyArray.length;
            int n2 = 0;
            while (n2 < n) {
                FileStorageServiceProperty property = fileStorageServicePropertyArray[n2];
                this.logger.info("Setting file storage service property for " + service + ": " + property);
                this.internalSetFileStorageServiceProperty(service, property.getName(), property.getValue());
                ++n2;
            }
        }
    }

    public void serializeForInitialReplicationInternal(ObjectOutputStream os) throws IOException {
        os.writeObject(this.active);
        HashMap<FileStorageService, FileStorageServiceProperty[]> properties = new HashMap<FileStorageService, FileStorageServiceProperty[]>();
        FileStorageService[] fileStorageServiceArray = this.getAvailableFileStorageServices();
        int n = fileStorageServiceArray.length;
        int n2 = 0;
        while (n2 < n) {
            FileStorageService service = fileStorageServiceArray[n2];
            properties.put(service, service.getProperties());
            ++n2;
        }
        os.writeObject(properties);
    }

    public void clearReplicaState() throws MalformedURLException, IOException, InterruptedException {
    }
}

