/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.anniversary.checker;

import com.sap.sailing.domain.common.dto.AnniversaryType;
import com.sap.sailing.server.interfaces.AnniversaryRaceDeterminator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class SameDigitChecker
implements AnniversaryRaceDeterminator.AnniversaryChecker {
    private final List<Integer> pastAnniversaries = new CopyOnWriteArrayList<Integer>();
    private Integer nextAnniversary = null;

    public void update(int raceCount) {
        if (raceCount < 0) {
            throw new IllegalStateException("Negative Raceamount " + raceCount);
        }
        this.pastAnniversaries.clear();
        int amount = 5;
        while (true) {
            int digit = 1;
            while (digit < 9) {
                String digitAsString = String.valueOf(digit);
                String toTest = "";
                int magnitude = 0;
                while (magnitude < amount) {
                    toTest = String.valueOf(toTest) + digitAsString;
                    ++magnitude;
                }
                int candidate = Integer.parseInt(toTest);
                if (candidate > raceCount) {
                    this.nextAnniversary = candidate;
                    return;
                }
                this.pastAnniversaries.add(candidate);
                ++digit;
            }
            ++amount;
        }
    }

    public List<Integer> getAnniversaries() {
        return this.pastAnniversaries;
    }

    public Integer getNextAnniversary() {
        return this.nextAnniversary;
    }

    public AnniversaryType getType() {
        return AnniversaryType.REPEATED_DIGIT;
    }
}

