/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.mapreduce;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.redisson.api.RExecutorFuture;
import org.redisson.api.RExecutorService;
import org.redisson.mapreduce.MapReduceTimeoutException;

public class SubTasksExecutor {
    private final List<CompletableFuture<?>> futures = new ArrayList();
    private final RExecutorService executor;
    private final long startTime;
    private final long timeout;

    public SubTasksExecutor(RExecutorService executor, long startTime, long timeout) {
        this.executor = executor;
        this.startTime = startTime;
        this.timeout = timeout;
    }

    public void submit(Runnable runnable) {
        RExecutorFuture<?> future = this.executor.submitAsync(runnable);
        this.futures.add(future.toCompletableFuture());
    }

    private void cancel(List<CompletableFuture<?>> futures) {
        for (CompletableFuture<?> future : futures) {
            future.cancel(true);
        }
    }

    private boolean isTimeoutExpired(long timeSpent) {
        return timeSpent > this.timeout && this.timeout > 0L;
    }

    public boolean await() throws Exception {
        block10: {
            if (Thread.currentThread().isInterrupted()) {
                this.cancel(this.futures);
                return false;
            }
            long timeSpent = System.currentTimeMillis() - this.startTime;
            if (this.isTimeoutExpired(timeSpent)) {
                this.cancel(this.futures);
                throw new MapReduceTimeoutException();
            }
            CompletableFuture<Void> future = CompletableFuture.allOf(this.futures.toArray(new CompletableFuture[0]));
            try {
                if (this.timeout > 0L) {
                    try {
                        future.get(this.timeout - timeSpent, TimeUnit.MILLISECONDS);
                        break block10;
                    }
                    catch (ExecutionException executionException) {
                        break block10;
                    }
                    catch (TimeoutException e) {
                        this.cancel(this.futures);
                        throw new MapReduceTimeoutException();
                    }
                }
                if (this.timeout != 0L) break block10;
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                    throw (Exception)e.getCause();
                }
            }
            catch (InterruptedException e) {
                this.cancel(this.futures);
                return false;
            }
        }
        return true;
    }
}

