/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.subscription.chargebee;

import com.chargebee.models.Subscription;
import com.sap.sse.security.shared.subscription.chargebee.ChargebeeSubscription;
import com.sap.sse.security.subscription.SubscriptionApiBaseService;
import com.sap.sse.security.subscription.SubscriptionApiRequestProcessor;
import com.sap.sse.security.subscription.SubscriptionCancelResult;
import com.sap.sse.security.subscription.chargebee.ChargebeeApiSubscriptionData;
import com.sap.sse.security.subscription.chargebee.ChargebeeCancelSubscriptionRequest;
import java.util.logging.Logger;

public class ChargebeeCancelSubscriptionTask
implements ChargebeeCancelSubscriptionRequest.OnResultListener {
    private static final Logger logger = Logger.getLogger(ChargebeeCancelSubscriptionTask.class.getName());
    private final String subscriptionId;
    private final SubscriptionApiRequestProcessor requestProcessor;
    private final OnResultListener listener;
    private final SubscriptionApiBaseService chargebeeApiServiceParams;

    public ChargebeeCancelSubscriptionTask(String subscriptionId, SubscriptionApiRequestProcessor requestProcessor, OnResultListener listener, SubscriptionApiBaseService chargebeeApiServiceParams) {
        this.subscriptionId = subscriptionId;
        this.requestProcessor = requestProcessor;
        this.listener = listener;
        this.chargebeeApiServiceParams = chargebeeApiServiceParams;
    }

    public void run() {
        logger.info(() -> "Schedule cancel Chargebee subscription, id: " + this.subscriptionId);
        this.requestProcessor.addRequest(new ChargebeeCancelSubscriptionRequest(this.subscriptionId, this, this.requestProcessor, this.chargebeeApiServiceParams));
    }

    @Override
    public void onSubscriptionCancelResult(Subscription subscriptionModel) {
        if (subscriptionModel != null) {
            ChargebeeApiSubscriptionData apiSubscriptionData = new ChargebeeApiSubscriptionData(subscriptionModel, null, null);
            ChargebeeSubscription subscription = apiSubscriptionData.toSubscription(this.chargebeeApiServiceParams.getSubscriptionPlanProvider());
            boolean success = subscription.getSubscriptionStatus().equals("cancelled");
            this.onDone(new SubscriptionCancelResult(success, (com.sap.sse.security.shared.subscription.Subscription)subscription, false));
        } else {
            this.onDone(new SubscriptionCancelResult(false, null, true));
        }
    }

    private void onDone(SubscriptionCancelResult result) {
        logger.info("Subscription cancelation is done with success = " + result.isSuccess() + ", deleted = " + result.isDeleted() + ", subscription = " + result.getSubscription());
        if (this.listener != null) {
            this.listener.onCancelResult(result);
        }
    }

    @FunctionalInterface
    public static interface OnResultListener {
        public void onCancelResult(SubscriptionCancelResult var1);
    }
}

