/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.impl;

import com.sap.sse.common.Util;
import com.sap.sse.security.interfaces.AccessControlStore;
import com.sap.sse.security.shared.AccessControlListAnnotation;
import com.sap.sse.security.shared.OwnershipAnnotation;
import com.sap.sse.security.shared.PermissionChecker;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.impl.AccessControlList;
import com.sap.sse.security.shared.impl.Ownership;
import com.sap.sse.security.shared.impl.QualifiedObjectIdentifierImpl;
import com.sap.sse.security.shared.impl.User;
import com.sap.sse.security.shared.impl.UserGroup;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public class SecurityServiceAclResolver
implements PermissionChecker.AclResolver<AccessControlList, Ownership> {
    private final AccessControlStore accessControlStore;

    SecurityServiceAclResolver(AccessControlStore accessControlStore) {
        this.accessControlStore = accessControlStore;
    }

    public Iterable<AccessControlList> resolveDenyingAclsAndCheckIfAnyMatches(Ownership ownership, String type, Iterable<String> objectIdentifiersAsString, Predicate<AccessControlList> filterCondition, Iterable<AccessControlList> allDenyingAclsForTypeAndObjectIdsOrNull) {
        Iterable<AccessControlList> result;
        if (allDenyingAclsForTypeAndObjectIdsOrNull == null) {
            result = this.enumerateAndCheckApplicableDenyingAcls(ownership, type, objectIdentifiersAsString, filterCondition);
        } else {
            for (AccessControlList acl : allDenyingAclsForTypeAndObjectIdsOrNull) {
                if (!filterCondition.test(acl)) continue;
                return null;
            }
            result = allDenyingAclsForTypeAndObjectIdsOrNull;
        }
        return result;
    }

    private Iterable<AccessControlList> enumerateAndCheckApplicableDenyingAcls(Ownership ownershipSpecification, String type, Iterable<String> objectIdentifiersAsString, Predicate<AccessControlList> filterCondition) {
        LinkedList<AccessControlList> result;
        block12: {
            block11: {
                assert (type != null);
                result = new LinkedList<AccessControlList>();
                if (objectIdentifiersAsString == null || Util.isEmpty(objectIdentifiersAsString)) break block11;
                for (String id : objectIdentifiersAsString) {
                    QualifiedObjectIdentifierImpl idOfAccessControlledObject = new QualifiedObjectIdentifierImpl(type, new TypeRelativeObjectIdentifier(new String[]{id}));
                    AccessControlListAnnotation acl = this.accessControlStore.getAccessControlList((QualifiedObjectIdentifier)idOfAccessControlledObject);
                    if (acl == null || !Util.filter(((AccessControlList)acl.getAnnotation()).getDeniedActions().entrySet(), e -> !((Set)e.getValue()).isEmpty()).iterator().hasNext() || ownershipSpecification != null && !this.doesOwnershipSpecificationMatchThatOfObject(ownershipSpecification, (QualifiedObjectIdentifier)idOfAccessControlledObject)) continue;
                    if (filterCondition.test((AccessControlList)acl.getAnnotation())) {
                        return null;
                    }
                    result.add((AccessControlList)acl.getAnnotation());
                }
                break block12;
            }
            Map denyingAclsForType = this.accessControlStore.getAccessControlListsWithDenials(type);
            if (denyingAclsForType == null) break block12;
            if (ownershipSpecification != null) {
                for (Set qoids : denyingAclsForType.values()) {
                    for (AccessControlList acl : Util.map((Iterable)Util.filter((Iterable)qoids, qoid -> this.doesOwnershipSpecificationMatchThatOfObject(ownershipSpecification, (QualifiedObjectIdentifier)qoid)), qoid -> (AccessControlList)this.accessControlStore.getAccessControlList(qoid).getAnnotation())) {
                        if (filterCondition.test(acl)) {
                            return null;
                        }
                        result.add(acl);
                    }
                }
            } else {
                for (Set qoids : denyingAclsForType.values()) {
                    for (QualifiedObjectIdentifier qoid2 : qoids) {
                        AccessControlListAnnotation acla = this.accessControlStore.getAccessControlList(qoid2);
                        if (acla != null && filterCondition.test((AccessControlList)acla.getAnnotation())) {
                            return null;
                        }
                        result.add((AccessControlList)acla.getAnnotation());
                    }
                }
            }
        }
        return result;
    }

    private boolean doesOwnershipSpecificationMatchThatOfObject(Ownership ownershipSpecification, QualifiedObjectIdentifier qoid) {
        OwnershipAnnotation ownershipOfObject = this.accessControlStore.getOwnership(qoid);
        User userOwnerSpecification = (User)ownershipSpecification.getUserOwner();
        UserGroup tenantOwnerSpecification = (UserGroup)ownershipSpecification.getTenantOwner();
        return (userOwnerSpecification == null || ownershipOfObject != null && Util.equalsWithNull((Object)((Ownership)ownershipOfObject.getAnnotation()).getUserOwner(), (Object)userOwnerSpecification)) && (tenantOwnerSpecification == null || ownershipOfObject != null && Util.equalsWithNull((Object)((Ownership)ownershipOfObject.getAnnotation()).getTenantOwner(), (Object)tenantOwnerSpecification));
    }
}

