/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.impl;

import com.sap.sse.security.impl.Activator;
import com.sap.sse.security.impl.ReplicableSecurityService;
import com.sap.sse.security.impl.ReplicatingCache;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheException;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.session.Session;

public class ReplicatingCacheManager
implements CacheManager,
Serializable {
    private static final Logger logger = Logger.getLogger(ReplicatingCacheManager.class.getName());
    private static final long serialVersionUID = -8035346668009900228L;
    private ConcurrentMap<String, ReplicatingCache<?, ?>> caches = new ConcurrentHashMap();

    public <K, V> Cache<K, V> getCache(String name, ReplicableSecurityService securityService) throws CacheException {
        if (securityService == null) {
            throw new IllegalArgumentException("SecurityService is null");
        }
        ReplicatingCache cache = (ReplicatingCache)this.caches.get(name);
        if (cache == null) {
            cache = new ReplicatingCache(securityService, name);
            this.caches.put(name, cache);
        }
        return cache;
    }

    public <K, V> Cache<K, V> getCache(String name) throws CacheException {
        ReplicableSecurityService securityService = (ReplicableSecurityService)Activator.getSecurityService();
        if (securityService == null) {
            return null;
        }
        ReplicatingCache cache = (ReplicatingCache)this.caches.get(name);
        if (cache == null) {
            cache = new ReplicatingCache(securityService, name);
            this.caches.put(name, cache);
        }
        return cache;
    }

    public void replaceContentsFrom(ReplicatingCacheManager other) {
        for (Map.Entry i : other.caches.entrySet()) {
            this.replaceOrUpdateWithoutStorage((String)i.getKey(), (ReplicatingCache)i.getValue());
        }
    }

    private <K, V> void replaceOrUpdateWithoutStorage(String name, ReplicatingCache<K, V> otherCache) {
        ReplicatingCache castCache = (ReplicatingCache)this.caches.get(name);
        if (castCache == null) {
            this.caches.put(name, otherCache);
        } else {
            this.putAllWithoutStorage(otherCache, castCache);
        }
    }

    private <K, V> void putAllWithoutStorage(ReplicatingCache<K, V> from, ReplicatingCache<K, V> to) {
        to.clear();
        for (K k : from.keys()) {
            to.put(k, from.get(k), false);
        }
    }

    public <V> void clear() {
        ReplicableSecurityService securityService = (ReplicableSecurityService)Activator.getSecurityService();
        for (Map.Entry cacheNameAndCache : this.caches.entrySet()) {
            for (Object s : ((ReplicatingCache)cacheNameAndCache.getValue()).values()) {
                if (!(s instanceof Session)) continue;
                Session session = (Session)s;
                securityService.removeSession((String)cacheNameAndCache.getKey(), session);
                session.stop();
                logger.info("clearing Session " + session.getId());
            }
        }
    }
}

