/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security;

import com.sap.sse.common.TimedLock;
import com.sap.sse.security.BearerAuthenticationToken;
import com.sap.sse.security.BearerTokenRealm;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.UsernamePasswordRealm;
import com.sap.sse.security.impl.Activator;
import com.sap.sse.security.shared.impl.User;
import com.sap.sse.util.ServiceTrackerFactory;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.pam.AtLeastOneSuccessfulStrategy;
import org.apache.shiro.realm.Realm;
import org.osgi.framework.BundleContext;

public class AtLeastOneSuccessfulStrategyWithTimedLocks
extends AtLeastOneSuccessfulStrategy {
    private static final Logger logger = Logger.getLogger(AtLeastOneSuccessfulStrategyWithTimedLocks.class.getName());
    private final Future<SecurityService> securityService = Activator.getContext() != null ? ServiceTrackerFactory.createServiceFuture((BundleContext)Activator.getContext(), SecurityService.class) : null;

    private SecurityService getSecurityService() {
        SecurityService result;
        try {
            result = this.securityService == null ? null : this.securityService.get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.log(Level.SEVERE, "Error retrieving security service", e);
            result = null;
        }
        return result;
    }

    public AuthenticationInfo afterAttempt(Realm realm, AuthenticationToken token, AuthenticationInfo singleRealmInfo, AuthenticationInfo aggregateInfo, Throwable t) throws AuthenticationException {
        if (token != null && token.getPrincipal() != null && realm instanceof UsernamePasswordRealm) {
            UsernamePasswordRealm upRealm = (UsernamePasswordRealm)realm;
            String username = token.getPrincipal().toString();
            User user = upRealm.getUserStore().getUserByName(username);
            if (user != null) {
                if (t != null) {
                    if (t instanceof IncorrectCredentialsException) {
                        logger.info("failed password authentication for user " + username);
                        SecurityService mySecurityService = this.getSecurityService();
                        if (mySecurityService != null) {
                            TimedLock timedLock = mySecurityService.failedPasswordAuthentication(user);
                            if (timedLock != null) {
                                logger.info("User " + username + " locked for password authentication: " + timedLock);
                            }
                        } else {
                            logger.warning("Account locking due to failed password authentication for user " + username + " not possible; security service not found");
                        }
                    }
                } else {
                    SecurityService mySecurityService = this.getSecurityService();
                    if (mySecurityService != null) {
                        mySecurityService.successfulPasswordAuthentication(user);
                    }
                }
            }
        } else if (token != null && realm instanceof BearerTokenRealm) {
            BearerAuthenticationToken bearerToken = (BearerAuthenticationToken)token;
            if (singleRealmInfo == null || singleRealmInfo.getPrincipals().isEmpty()) {
                if (t != null && t instanceof LockedAccountException) {
                    logger.fine(() -> "Bearer token authentication from client IP " + bearerToken.getClientIP() + " with user agent " + bearerToken.getUserAgent() + " currently locked");
                } else {
                    logger.info("failed bearer token authentication for client IP " + bearerToken.getClientIP() + " with user agent " + bearerToken.getUserAgent());
                    SecurityService mySecurityService = this.getSecurityService();
                    if (mySecurityService != null) {
                        TimedLock timedLock = mySecurityService.failedBearerTokenAuthentication(bearerToken.getClientIP());
                        if (timedLock != null) {
                            logger.info("Client IP " + bearerToken.getClientIP() + " locked for bearer token authentication: " + timedLock);
                        }
                    } else {
                        logger.warning("Client IP locking due to failed bearer token authentication for client IP " + bearerToken.getClientIP() + " with user agent " + bearerToken.getUserAgent() + " not possible; security service not found");
                    }
                }
            } else {
                SecurityService mySecurityService = this.getSecurityService();
                if (mySecurityService != null) {
                    mySecurityService.successfulBearerTokenAuthentication(bearerToken.getClientIP());
                }
            }
        }
        return super.afterAttempt(realm, token, singleRealmInfo, aggregateInfo, t);
    }
}

