/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.dashboards.gwt.client.widgets.startanalysis.card;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.dashboards.gwt.client.widgets.startanalysis.StartAnalysisPageChangeListener;
import com.sap.sailing.dashboards.gwt.client.widgets.startanalysis.card.StartAnalysisCard;
import com.sap.sailing.dashboards.gwt.client.widgets.startanalysis.rankingtable.StartAnalysisStartRankTable;
import com.sap.sailing.dashboards.gwt.shared.StartlineAdvantageType;
import com.sap.sailing.dashboards.gwt.shared.dto.StartAnalysisDTO;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.racelog.RacingProcedureType;
import com.sap.sailing.gwt.ui.client.CompetitorSelectionChangeListener;
import com.sap.sailing.gwt.ui.client.CompetitorSelectionModel;
import com.sap.sailing.gwt.ui.client.RaceCompetitorSelectionModel;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMap;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMapHelpLinesSettings;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMapResources;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMapZoomSettings;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.player.Timer;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.subscription.SubscriptionServiceFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;

public class StartAnalysisCard
extends Composite
implements HasWidgets,
StartAnalysisPageChangeListener {
    private static StartlineAnalysisCardUiBinder uiBinder = (StartlineAnalysisCardUiBinder)GWT.create(StartlineAnalysisCardUiBinder.class);
    @UiField
    HTMLPanel startanalysis_card;
    @UiField
    HTMLPanel card_map_container;
    @UiField
    HTMLPanel startanalysis_card_table;
    @UiField
    DivElement startanalysis_card_line_advantage;
    @UiField
    DivElement startanalysis_card_race_time;
    private int cardid;
    private StartAnalysisDTO startAnalysisDTO;
    private RaceMap raceMap;
    private final SailingServiceAsync sailingServiceAsync;
    private final UserService userService;
    private final SubscriptionServiceFactory subscriptionServiceFactory;
    private final ErrorReporter errorReporter;
    private final StringMessages stringMessages;
    private final RaceCompetitorSelectionModel competitorSelectionModel;
    private final double WIND_LINE_ADVANTAGE_DIV_WIDTH_IN_PT = 185.0;
    private final double GEOMETRIC_LINE_ADVANTAGE_DIV_WIDTH_IN_PT = 210.0;
    private final String RACE_TIME_START = "00:00:00";
    private RaceMapResources raceMapResources;

    public StartAnalysisCard(double leftCSSProperty, int cardId, StartAnalysisDTO startAnalysisDTO, SailingServiceAsync sailingServiceAsync, ErrorReporter errorReporter, RaceMapResources raceMapResources, SubscriptionServiceFactory subscriptionServiceFactory, UserService userService) {
        this.userService = userService;
        this.subscriptionServiceFactory = subscriptionServiceFactory;
        this.stringMessages = StringMessages.INSTANCE;
        this.sailingServiceAsync = sailingServiceAsync;
        this.errorReporter = errorReporter;
        this.raceMapResources = raceMapResources;
        Map<CompetitorDTO, BoatDTO> competitorsToBoats = startAnalysisDTO.startAnalysisCompetitorDTOs.stream().collect(Collectors.toMap(c -> c.competitorDTO, c -> c.boatDTO));
        this.competitorSelectionModel = new RaceCompetitorSelectionModel(true, competitorsToBoats);
        this.competitorSelectionModel.setCompetitors((Iterable)startAnalysisDTO.getCompetitorDTOsFromStartAnaylsisCompetitorDTOs(), new CompetitorSelectionChangeListener[]{this.raceMap});
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.startanalysis_card.getElement().getStyle().setLeft(leftCSSProperty, Style.Unit.PCT);
        this.startAnalysisDTO = startAnalysisDTO;
        this.cardid = cardId;
        this.startanalysis_card_table.add((Widget)new StartAnalysisStartRankTable(startAnalysisDTO.startAnalysisCompetitorDTOs, (CompetitorSelectionModel)this.competitorSelectionModel));
        this.fillWindAndStartLineData(this.startAnalysisDTO);
    }

    private void fillWindAndStartLineData(StartAnalysisDTO startAnalysisDTO) {
        if (startAnalysisDTO.startAnalysisWindLineInfoDTO != null) {
            this.setLineAdvantageDivWidth(startAnalysisDTO.startAnalysisWindLineInfoDTO.startLineAdvantage.startLineAdvantageType);
            String startLineAdvantageType = startAnalysisDTO.startAnalysisWindLineInfoDTO.startLineAdvantage.startLineAdvantageType.equals((Object)StartlineAdvantageType.GEOMETRIC) ? this.stringMessages.dashboardStartlineAdvantageByGeometryHeader() : this.stringMessages.dashboardStartlineAdvantagesByWindHeader();
            if (startAnalysisDTO.startAnalysisWindLineInfoDTO.startLineAdvantage.startLineAdvantage == null) {
                this.startanalysis_card_line_advantage.setInnerHTML("");
            } else {
                this.startanalysis_card_line_advantage.setInnerHTML(SafeHtmlUtils.fromString((String)(String.valueOf(startLineAdvantageType) + ": " + NumberFormat.getFormat((String)"#0.0").format((Number)startAnalysisDTO.startAnalysisWindLineInfoDTO.startLineAdvantage.startLineAdvantage) + " m")).asString());
            }
            String formattedTimeSinceStart = startAnalysisDTO.racingProcedureType.equals((Object)RacingProcedureType.GateStart) ? this.getRaceTimeStringFromMilliseconds(startAnalysisDTO.tailLenghtInMilliseconds) : "00:00:00";
            this.startanalysis_card_race_time.setInnerHTML("Elapsed Time: " + formattedTimeSinceStart);
        }
    }

    private String getRaceTimeStringFromMilliseconds(long milliseconds) {
        int seconds = (int)(milliseconds / 1000L) % 60;
        int minutes = (int)(milliseconds / 60000L % 60L);
        int hours = (int)(milliseconds / 3600000L % 24L);
        return String.valueOf(NumberFormat.getFormat((String)"00").format((double)hours)) + ":" + NumberFormat.getFormat((String)"00").format((double)minutes) + ":" + NumberFormat.getFormat((String)"00").format((double)seconds);
    }

    private void setLineAdvantageDivWidth(StartlineAdvantageType startlineAdvantageType) {
        if (this.startAnalysisDTO.startAnalysisWindLineInfoDTO.startLineAdvantage.startLineAdvantageType == StartlineAdvantageType.GEOMETRIC) {
            this.startanalysis_card_line_advantage.getStyle().setWidth(210.0, Style.Unit.PT);
        } else {
            this.startanalysis_card_line_advantage.getStyle().setWidth(185.0, Style.Unit.PT);
        }
    }

    private void addMap(int cardID, StartAnalysisDTO startAnalysisDTO, RaceMapResources raceMapResources) {
        Timer timer = new Timer(Timer.PlayModes.Live, 1000L);
        timer.pause();
        ArrayList<RaceMapZoomSettings.ZoomTypes> zoomTypes = new ArrayList<RaceMapZoomSettings.ZoomTypes>();
        if (startAnalysisDTO.racingProcedureType.equals((Object)RacingProcedureType.GateStart)) {
            timer.setTime(startAnalysisDTO.timeOfStartInMilliSeconds + startAnalysisDTO.tailLenghtInMilliseconds);
            zoomTypes.add(RaceMapZoomSettings.ZoomTypes.BUOYS);
        } else {
            timer.setTime(startAnalysisDTO.timeOfStartInMilliSeconds);
            zoomTypes.add(RaceMapZoomSettings.ZoomTypes.BUOYS);
        }
        this.userService.createEssentialSecuredDTOByIdAndType(startAnalysisDTO.regattaAndRaceIdentifier.getPermissionType(), startAnalysisDTO.regattaAndRaceIdentifier.getName(), startAnalysisDTO.regattaAndRaceIdentifier.getTypeRelativeObjectIdentifier(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private double getHeightForRaceMapInPixels() {
        return this.getElement().getOffsetHeight() - this.startanalysis_card_table.getElement().getOffsetHeight() - 30;
    }

    private RaceMapHelpLinesSettings getHelpLineSettings() {
        HashSet<RaceMapHelpLinesSettings.HelpLineTypes> visibleHelpLines = new HashSet<RaceMapHelpLinesSettings.HelpLineTypes>();
        visibleHelpLines.add(RaceMapHelpLinesSettings.HelpLineTypes.STARTLINE);
        visibleHelpLines.add(RaceMapHelpLinesSettings.HelpLineTypes.BOATTAILS);
        visibleHelpLines.add(RaceMapHelpLinesSettings.HelpLineTypes.STARTLINETOFIRSTMARKTRIANGLE);
        visibleHelpLines.add(RaceMapHelpLinesSettings.HelpLineTypes.ADVANTAGELINE);
        return new RaceMapHelpLinesSettings(visibleHelpLines);
    }

    private void removeMap() {
        if (this.raceMap != null && this.raceMap.isAttached()) {
            this.card_map_container.remove((Widget)this.raceMap);
        }
    }

    public void startAnalysisComponentPageChangedToIndexAndStartAnalysis(int newPageIndex, StartAnalysisDTO startAnalysisDTO) {
        this.removeMap();
        if (this.cardid == newPageIndex) {
            Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void add(Widget w) {
        throw new UnsupportedOperationException("The method add(Widget w) is not supported.");
    }

    public void clear() {
        throw new UnsupportedOperationException("The method clear() is not supported.");
    }

    public Iterator<Widget> iterator() {
        return null;
    }

    public boolean remove(Widget w) {
        return false;
    }

    static /* synthetic */ UserService access$0(StartAnalysisCard startAnalysisCard) {
        return startAnalysisCard.userService;
    }

    static /* synthetic */ SubscriptionServiceFactory access$1(StartAnalysisCard startAnalysisCard) {
        return startAnalysisCard.subscriptionServiceFactory;
    }

    static /* synthetic */ RaceMapHelpLinesSettings access$2(StartAnalysisCard startAnalysisCard) {
        return startAnalysisCard.getHelpLineSettings();
    }

    static /* synthetic */ SailingServiceAsync access$3(StartAnalysisCard startAnalysisCard) {
        return startAnalysisCard.sailingServiceAsync;
    }

    static /* synthetic */ ErrorReporter access$4(StartAnalysisCard startAnalysisCard) {
        return startAnalysisCard.errorReporter;
    }

    static /* synthetic */ RaceCompetitorSelectionModel access$5(StartAnalysisCard startAnalysisCard) {
        return startAnalysisCard.competitorSelectionModel;
    }

    static /* synthetic */ void access$6(StartAnalysisCard startAnalysisCard, RaceMap raceMap) {
        startAnalysisCard.raceMap = raceMap;
    }

    static /* synthetic */ RaceMap access$7(StartAnalysisCard startAnalysisCard) {
        return startAnalysisCard.raceMap;
    }

    static /* synthetic */ double access$8(StartAnalysisCard startAnalysisCard) {
        return startAnalysisCard.getHeightForRaceMapInPixels();
    }

    static /* synthetic */ RaceMapResources access$9(StartAnalysisCard startAnalysisCard) {
        return startAnalysisCard.raceMapResources;
    }

    static /* synthetic */ void access$10(StartAnalysisCard startAnalysisCard, int n, StartAnalysisDTO startAnalysisDTO, RaceMapResources raceMapResources) {
        startAnalysisCard.addMap(n, startAnalysisDTO, raceMapResources);
    }
}

