/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.io;

import net.sf.marineapi.nmea.io.ActivityMonitor;
import net.sf.marineapi.nmea.io.DataReader;
import net.sf.marineapi.nmea.io.SentenceReader;
import net.sf.marineapi.nmea.parser.SentenceFactory;
import net.sf.marineapi.nmea.sentence.Sentence;
import net.sf.marineapi.nmea.sentence.SentenceValidator;

abstract class AbstractDataReader
implements DataReader {
    private static final int SLEEP_TIME = 100;
    private final SentenceReader parent;
    private volatile boolean isRunning = true;

    public AbstractDataReader(SentenceReader parent) {
        this.parent = parent;
    }

    protected SentenceReader getParent() {
        return this.parent;
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    public abstract String read() throws Exception;

    @Override
    public void run() {
        ActivityMonitor monitor = new ActivityMonitor(this.parent);
        SentenceFactory factory = SentenceFactory.getInstance();
        while (this.isRunning) {
            try {
                try {
                    String data = this.read();
                    if (data == null) {
                        if (this.isRunning()) {
                            Thread.sleep(100L);
                        }
                    } else if (SentenceValidator.isValid(data)) {
                        monitor.refresh();
                        Sentence s = factory.createParser(data);
                        this.parent.fireSentenceEvent(s);
                    } else if (!SentenceValidator.isSentence(data)) {
                        this.parent.fireDataEvent(data);
                    }
                }
                catch (Exception e) {
                    this.parent.handleException("Data read failed", e);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    monitor.tick();
                    continue;
                }
            }
            catch (Throwable throwable) {
                monitor.tick();
                throw throwable;
            }
            monitor.tick();
        }
        monitor.reset();
        this.parent.fireReadingStopped();
    }

    @Override
    public void stop() {
        this.isRunning = false;
    }
}

