/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.aws.orchestration;

import com.sap.sse.landscape.DefaultProcessConfigurationVariables;
import com.sap.sse.landscape.InboundReplicationConfiguration;
import com.sap.sse.landscape.OutboundReplicationConfiguration;
import com.sap.sse.landscape.ProcessConfigurationVariable;
import com.sap.sse.landscape.Release;
import com.sap.sse.landscape.UserDataProvider;
import com.sap.sse.landscape.application.ApplicationProcess;
import com.sap.sse.landscape.application.ApplicationProcessMetrics;
import com.sap.sse.landscape.aws.AwsLandscape;
import com.sap.sse.landscape.aws.impl.AwsRegion;
import com.sap.sse.landscape.mongodb.Database;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public abstract class AwsApplicationConfiguration<ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>>
implements UserDataProvider {
    private final Map<ProcessConfigurationVariable, String> userData;
    private final String serverName;
    private final Optional<Release> release;

    protected AwsApplicationConfiguration(BuilderImpl<?, ?, ShardingKey, MetricsT, ProcessT> builder) {
        this.userData = Collections.unmodifiableMap(builder.getUserData());
        this.serverName = builder.getServerName();
        this.release = builder.getRelease();
    }

    public Map<ProcessConfigurationVariable, String> getUserData() {
        return this.userData;
    }

    protected String getServerName() {
        return this.serverName;
    }

    public Optional<Release> getRelease() {
        return this.release;
    }

    public static interface Builder<BuilderT extends Builder<BuilderT, T, ShardingKey, MetricsT, ProcessT>, T extends AwsApplicationConfiguration<ShardingKey, MetricsT, ProcessT>, ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>>
    extends com.sap.sse.common.Builder<BuilderT, T> {
        public BuilderT setRegion(AwsRegion var1);

        public BuilderT setLandscape(AwsLandscape<ShardingKey> var1);

        public BuilderT setRelease(Release var1);

        public BuilderT setServerName(String var1);

        public BuilderT setDatabaseName(String var1);

        public BuilderT setInboundReplicationConfiguration(InboundReplicationConfiguration var1);

        public Optional<InboundReplicationConfiguration> getInboundReplicationConfiguration();

        public BuilderT setOutboundReplicationConfiguration(OutboundReplicationConfiguration var1);

        public BuilderT setDatabaseConfiguration(Database var1);

        public BuilderT setCommaSeparatedEmailAddressesToNotifyOfStartup(String var1);

        public BuilderT setMailFrom(String var1);

        public BuilderT setMailSmtpHost(String var1);

        public BuilderT setMailSmtpPort(int var1);

        public BuilderT setMailSmtpAuth(boolean var1);

        public BuilderT setMailSmtpUser(String var1);

        public BuilderT setMailSmtpPassword(String var1);

        public BuilderT setMemoryInMegabytes(int var1);

        public BuilderT setMemoryTotalSizeFactor(int var1);
    }

    protected static abstract class BuilderImpl<BuilderT extends Builder<BuilderT, T, ShardingKey, MetricsT, ProcessT>, T extends AwsApplicationConfiguration<ShardingKey, MetricsT, ProcessT>, ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>>
    implements Builder<BuilderT, T, ShardingKey, MetricsT, ProcessT> {
        private static final String DEFAULT_SMTP_HOSTNAME_PATTERN = "email-smtp.%s.amazonaws.com";
        private static final Integer DEFAULT_SMTP_PORT = 25;
        private AwsLandscape<ShardingKey> landscape;
        private AwsRegion region;
        private Optional<Release> release = Optional.empty();
        private String serverName;
        private String databaseName;
        private Database databaseConfiguration;
        private Optional<InboundReplicationConfiguration> inboundReplicationConfiguration = Optional.empty();
        private OutboundReplicationConfiguration outboundReplicationConfiguration;
        private String commaSeparatedEmailAddressesToNotifyOfStartup;
        private String mailFrom;
        private String mailSmtpHost;
        private Integer mailSmtpPort;
        private Boolean mailSmtpAuth;
        private String mailSmtpUser;
        private String mailSmtpPassword;
        private Optional<Integer> memoryInMegabytes = Optional.empty();
        private Optional<Integer> memoryTotalSizeFactor = Optional.empty();

        protected BuilderImpl() {
        }

        @Override
        public BuilderT setRegion(AwsRegion region) {
            this.region = region;
            return (BuilderT)((Builder)this.self());
        }

        protected AwsRegion getRegion() {
            return this.region;
        }

        @Override
        public BuilderT setLandscape(AwsLandscape<ShardingKey> landscape) {
            this.landscape = landscape;
            return (BuilderT)((Builder)this.self());
        }

        protected AwsLandscape<ShardingKey> getLandscape() {
            return this.landscape;
        }

        protected Optional<Release> getRelease() {
            return this.release;
        }

        @Override
        public BuilderT setRelease(Release release) {
            this.release = Optional.ofNullable(release);
            return (BuilderT)((Builder)this.self());
        }

        protected String getServerName() {
            return this.serverName;
        }

        @Override
        public BuilderT setServerName(String serverName) {
            this.serverName = serverName;
            return (BuilderT)((Builder)this.self());
        }

        protected String getDatabaseName() {
            return this.databaseName == null ? this.getServerName() : this.databaseName;
        }

        protected boolean isDatabaseNameSet() {
            return this.databaseName != null;
        }

        @Override
        public BuilderT setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return (BuilderT)((Builder)this.self());
        }

        protected Database getDatabaseConfiguration() {
            return this.isDatabaseConfigurationSet() ? this.databaseConfiguration : this.getLandscape().getDatabase(this.getRegion(), this.getDatabaseName());
        }

        protected boolean isDatabaseConfigurationSet() {
            return this.databaseConfiguration != null;
        }

        @Override
        public BuilderT setDatabaseConfiguration(Database databaseConfiguration) {
            this.databaseConfiguration = databaseConfiguration;
            return (BuilderT)((Builder)this.self());
        }

        @Override
        public BuilderT setMemoryInMegabytes(int megabytes) {
            this.memoryInMegabytes = Optional.of(megabytes);
            return (BuilderT)((Builder)this.self());
        }

        protected Optional<Integer> getMemoryInMegabytes() {
            return this.memoryInMegabytes;
        }

        @Override
        public BuilderT setMemoryTotalSizeFactor(int totalMemoryAvailableToApplicationsDividedByMemoryForThisProcess) {
            this.memoryTotalSizeFactor = Optional.of(totalMemoryAvailableToApplicationsDividedByMemoryForThisProcess);
            return (BuilderT)((Builder)this.self());
        }

        protected Optional<Integer> getMemoryTotalSizeFactor() {
            return this.memoryTotalSizeFactor;
        }

        protected boolean isOutboundReplicationExchangeNameSet() {
            return this.outboundReplicationConfiguration != null && this.outboundReplicationConfiguration.getOutboundReplicationExchangeName() != null;
        }

        protected boolean isInboundReplicationRabbitMQEndpointSet() {
            return this.inboundReplicationConfiguration != null && this.inboundReplicationConfiguration.isPresent() && this.inboundReplicationConfiguration.get().getInboundRabbitMQEndpoint() != null;
        }

        protected boolean isInboundReplicationExchangeNameSet() {
            return this.inboundReplicationConfiguration != null && this.inboundReplicationConfiguration.isPresent() && this.inboundReplicationConfiguration.get().getInboundMasterExchangeName() != null;
        }

        protected boolean isInboundMasterServletHostSet() {
            return this.inboundReplicationConfiguration != null && this.inboundReplicationConfiguration.isPresent() && this.inboundReplicationConfiguration.get().getMasterHostname() != null;
        }

        protected boolean isOutboundReplicationRabbitMQEndpointSet() {
            return this.outboundReplicationConfiguration != null && this.outboundReplicationConfiguration.getOutboundRabbitMQEndpoint() != null;
        }

        protected OutboundReplicationConfiguration getOutboundReplicationConfiguration() {
            OutboundReplicationConfiguration.Builder resultBuilder = this.outboundReplicationConfiguration != null ? OutboundReplicationConfiguration.copy((OutboundReplicationConfiguration)this.outboundReplicationConfiguration) : OutboundReplicationConfiguration.builder();
            if (!this.isOutboundReplicationExchangeNameSet()) {
                resultBuilder.setOutboundReplicationExchangeName(this.getServerName());
            }
            if (!this.isOutboundReplicationRabbitMQEndpointSet()) {
                this.getInboundReplicationConfiguration().ifPresent(irc -> {
                    OutboundReplicationConfiguration.Builder builder2 = resultBuilder.setOutboundRabbitMQEndpoint(irc.getInboundRabbitMQEndpoint());
                });
            }
            return resultBuilder.build();
        }

        @Override
        public BuilderT setOutboundReplicationConfiguration(OutboundReplicationConfiguration outboundReplicationConfiguration) {
            this.outboundReplicationConfiguration = outboundReplicationConfiguration;
            return (BuilderT)((Builder)this.self());
        }

        @Override
        public Optional<InboundReplicationConfiguration> getInboundReplicationConfiguration() {
            InboundReplicationConfiguration.Builder resultBuilder = this.inboundReplicationConfiguration == null || !this.inboundReplicationConfiguration.isPresent() ? InboundReplicationConfiguration.builder() : InboundReplicationConfiguration.copy((InboundReplicationConfiguration)this.inboundReplicationConfiguration.get());
            return !this.isInboundReplicationRabbitMQEndpointSet() ? Optional.of(resultBuilder.setInboundRabbitMQEndpoint(this.getLandscape().getDefaultRabbitConfiguration(this.getRegion())).build()) : this.inboundReplicationConfiguration;
        }

        @Override
        public BuilderT setInboundReplicationConfiguration(InboundReplicationConfiguration replicationConfiguration) {
            this.inboundReplicationConfiguration = Optional.of(replicationConfiguration);
            return (BuilderT)((Builder)this.self());
        }

        protected String getCommaSeparatedEmailAddressesToNotifyOfStartup() {
            return this.commaSeparatedEmailAddressesToNotifyOfStartup;
        }

        @Override
        public BuilderT setCommaSeparatedEmailAddressesToNotifyOfStartup(String commaSeparatedEmailAddressesToNotifyOfStartup) {
            this.commaSeparatedEmailAddressesToNotifyOfStartup = commaSeparatedEmailAddressesToNotifyOfStartup;
            return (BuilderT)((Builder)this.self());
        }

        @Override
        public BuilderT setMailFrom(String mailFrom) {
            this.mailFrom = mailFrom;
            return (BuilderT)((Builder)this.self());
        }

        @Override
        public BuilderT setMailSmtpHost(String mailSmtpHost) {
            this.mailSmtpHost = mailSmtpHost;
            return (BuilderT)((Builder)this.self());
        }

        @Override
        public BuilderT setMailSmtpPort(int mailSmtpPort) {
            this.mailSmtpPort = mailSmtpPort;
            return (BuilderT)((Builder)this.self());
        }

        @Override
        public BuilderT setMailSmtpAuth(boolean mailSmtpAuth) {
            this.mailSmtpAuth = mailSmtpAuth;
            return (BuilderT)((Builder)this.self());
        }

        @Override
        public BuilderT setMailSmtpUser(String mailSmtpUser) {
            this.mailSmtpUser = mailSmtpUser;
            return (BuilderT)((Builder)this.self());
        }

        @Override
        public BuilderT setMailSmtpPassword(String mailSmtpPassword) {
            this.mailSmtpPassword = mailSmtpPassword;
            return (BuilderT)((Builder)this.self());
        }

        protected Map<ProcessConfigurationVariable, String> getUserData() {
            HashMap<ProcessConfigurationVariable, String> userData = new HashMap<ProcessConfigurationVariable, String>();
            this.getRelease().ifPresent(release -> userData.putAll(release.getUserData()));
            userData.putAll(this.getDatabaseConfiguration().getUserData());
            userData.putAll(this.getOutboundReplicationConfiguration().getUserData());
            if (this.getServerName() != null) {
                userData.put((ProcessConfigurationVariable)DefaultProcessConfigurationVariables.SERVER_NAME, this.getServerName());
            }
            this.getInboundReplicationConfiguration().ifPresent(inboundReplicationConfiguration -> userData.putAll(inboundReplicationConfiguration.getUserData()));
            if (this.getCommaSeparatedEmailAddressesToNotifyOfStartup() != null) {
                userData.put((ProcessConfigurationVariable)DefaultProcessConfigurationVariables.SERVER_STARTUP_NOTIFY, this.getCommaSeparatedEmailAddressesToNotifyOfStartup());
            }
            userData.put((ProcessConfigurationVariable)DefaultProcessConfigurationVariables.MAIL_FROM, this.mailFrom == null ? "noreply@sapsailing.com" : this.mailFrom);
            userData.put((ProcessConfigurationVariable)DefaultProcessConfigurationVariables.MAIL_SMTP_HOST, this.mailSmtpHost == null ? this.getDefaultAwsSesMailHostForRegion() : this.mailSmtpHost);
            userData.put((ProcessConfigurationVariable)DefaultProcessConfigurationVariables.MAIL_SMTP_PORT, this.mailSmtpPort == null ? DEFAULT_SMTP_PORT.toString() : this.mailSmtpPort.toString());
            userData.put((ProcessConfigurationVariable)DefaultProcessConfigurationVariables.MAIL_SMTP_AUTH, this.mailSmtpAuth == null ? Boolean.TRUE.toString() : this.mailSmtpAuth.toString());
            if (this.mailSmtpUser != null) {
                userData.put((ProcessConfigurationVariable)DefaultProcessConfigurationVariables.MAIL_SMTP_USER, this.mailSmtpUser);
            }
            if (this.mailSmtpPassword != null) {
                userData.put((ProcessConfigurationVariable)DefaultProcessConfigurationVariables.MAIL_SMTP_PASSWORD, this.mailSmtpPassword);
            }
            if (this.getMemoryInMegabytes().isPresent()) {
                userData.put((ProcessConfigurationVariable)DefaultProcessConfigurationVariables.MEMORY, this.getMemoryInMegabytes().get() + "m");
            } else if (this.getMemoryTotalSizeFactor().isPresent()) {
                userData.put((ProcessConfigurationVariable)DefaultProcessConfigurationVariables.TOTAL_MEMORY_SIZE_FACTOR, "" + this.getMemoryTotalSizeFactor().get());
            }
            return userData;
        }

        private String getDefaultAwsSesMailHostForRegion() {
            return String.format(DEFAULT_SMTP_HOSTNAME_PATTERN, this.getRegion().getId());
        }
    }
}

