/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.aws.impl;

import com.sap.sse.common.TimePoint;
import com.sap.sse.landscape.Region;
import com.sap.sse.landscape.aws.AmazonMachineImage;
import com.sap.sse.landscape.aws.AwsLandscape;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.Image;
import software.amazon.awssdk.services.ec2.model.ImageState;
import software.amazon.awssdk.services.ec2.model.Tag;

public class AmazonMachineImageImpl<ShardingKey>
implements AmazonMachineImage<ShardingKey> {
    private static final long serialVersionUID = 1615200981492476022L;
    private final Image image;
    private final Region region;
    private final AwsLandscape<ShardingKey> landscape;

    public AmazonMachineImageImpl(Image image, Region region, AwsLandscape<ShardingKey> landscape) {
        this.image = image;
        this.region = region;
        this.landscape = landscape;
    }

    @Override
    public String getId() {
        return this.image.imageId();
    }

    public String getName() {
        return this.image.name();
    }

    public Region getRegion() {
        return this.region;
    }

    @Override
    public Iterable<Tag> getTags() {
        return this.image.tags();
    }

    public TimePoint getCreatedAt() {
        Date date;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            date = dateFormat.parse(this.image.creationDate());
        }
        catch (ParseException e) {
            date = null;
        }
        return date == null ? null : TimePoint.of(date);
    }

    public AmazonMachineImage<ShardingKey> updateAllPackages() {
        return null;
    }

    public void delete() {
        this.landscape.deleteImage(this.getRegion(), this.getId());
        for (BlockDeviceMapping blockDeviceMapping : this.getBlockDeviceMappings()) {
            if (blockDeviceMapping.ebs() == null) continue;
            this.landscape.deleteSnapshot(this.getRegion(), blockDeviceMapping.ebs().snapshotId());
        }
    }

    @Override
    public Iterable<BlockDeviceMapping> getBlockDeviceMappings() {
        return this.image.blockDeviceMappings();
    }

    @Override
    public ImageState getState() {
        return this.image.state();
    }

    public String toString() {
        return "AMI [imageId=" + this.image.imageId() + ", region=" + this.region + "]";
    }
}

