/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.landscape.ui.client;

import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.landscape.ui.client.LandscapeDialogUtil;
import com.sap.sailing.landscape.ui.client.LandscapeManagementWriteServiceAsync;
import com.sap.sailing.landscape.ui.client.i18n.StringMessages;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.controls.IntegerBox;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;

public class MoveMasterProcessDialog
extends DataEntryDialog<MoveMasterToOtherInstanceInstructions> {
    private final StringMessages stringMessages;
    private final CheckBox sharedMasterInstanceBox;
    private final ListBox instanceTypeListBox;
    private final Label instanceTypeLabel;
    private final TextBox masterReplicationBearerTokenBox;
    private final TextBox replicaReplicationBearerTokenBox;
    private final IntegerBox memoryInMegabytesBox;
    private final IntegerBox memoryTotalSizeFactorBox;
    private boolean memoryAsFactorToTotalMemoryAdjusted;

    public MoveMasterProcessDialog(LandscapeManagementWriteServiceAsync landscapeManagementService, StringMessages stringMessages, ErrorReporter errorReporter, DataEntryDialog.DialogCallback<MoveMasterToOtherInstanceInstructions> callback) {
        super(stringMessages.moveMasterToOtherInstance(), null, stringMessages.ok(), stringMessages.cancel(), null, callback);
        this.stringMessages = stringMessages;
        this.instanceTypeListBox = LandscapeDialogUtil.createInstanceTypeListBox(this, landscapeManagementService, stringMessages, "C5_2_XLARGE", errorReporter, false);
        this.instanceTypeLabel = new Label();
        this.masterReplicationBearerTokenBox = this.createTextBox("", 40);
        this.replicaReplicationBearerTokenBox = this.createTextBox("", 40);
        this.memoryInMegabytesBox = this.createIntegerBox(null, 7);
        this.memoryTotalSizeFactorBox = this.createIntegerBox(null, 2);
        this.memoryTotalSizeFactorBox.addValueChangeHandler(e -> {
            boolean bl = this.memoryAsFactorToTotalMemoryAdjusted = true;
        });
        this.memoryInMegabytesBox.addValueChangeHandler(e -> this.memoryTotalSizeFactorBox.setEnabled(e.getValue() == null));
        this.sharedMasterInstanceBox = this.createCheckbox(stringMessages.sharedMasterInstance());
        this.sharedMasterInstanceBox.addValueChangeHandler(e -> this.updateInstanceTypeBasedOnSharedMasterInstanceBox());
        this.updateInstanceTypeBasedOnSharedMasterInstanceBox();
    }

    private void updateInstanceTypeBasedOnSharedMasterInstanceBox() {
        this.instanceTypeLabel.setText(this.sharedMasterInstanceBox.getValue() != false ? this.stringMessages.sharedMasterInstanceType() : this.stringMessages.dedicatedInstanceType());
        LandscapeDialogUtil.selectInstanceType(this.instanceTypeListBox, this.sharedMasterInstanceBox.getValue() != false ? "I3_2_XLARGE" : "C5_2_XLARGE");
        if (!this.memoryAsFactorToTotalMemoryAdjusted) {
            if (this.sharedMasterInstanceBox.getValue().booleanValue()) {
                this.memoryTotalSizeFactorBox.setValue((Object)4);
            } else {
                this.memoryTotalSizeFactorBox.setText("");
            }
        }
    }

    protected Widget getAdditionalWidget() {
        Grid result = new Grid(6, 2);
        int row = 0;
        result.setWidget(row, 0, (Widget)new Label(this.stringMessages.sharedMasterInstance()));
        result.setWidget(row++, 1, (Widget)this.sharedMasterInstanceBox);
        result.setWidget(row, 0, (Widget)this.instanceTypeLabel);
        result.setWidget(row++, 1, (Widget)this.instanceTypeListBox);
        result.setWidget(row, 0, (Widget)new Label(this.stringMessages.bearerTokenForSecurityReplication()));
        result.setWidget(row++, 1, (Widget)this.masterReplicationBearerTokenBox);
        result.setWidget(row, 0, (Widget)new Label(this.stringMessages.replicaReplicationBearerToken()));
        result.setWidget(row++, 1, (Widget)this.replicaReplicationBearerTokenBox);
        result.setWidget(row, 0, (Widget)new Label(this.stringMessages.memoryInMegabytes()));
        result.setWidget(row++, 1, (Widget)this.memoryInMegabytesBox);
        result.setWidget(row, 0, (Widget)new Label(this.stringMessages.memoryTotalSizeFactor()));
        result.setWidget(row++, 1, (Widget)this.memoryTotalSizeFactorBox);
        return result;
    }

    protected MoveMasterToOtherInstanceInstructions getResult() {
        return new MoveMasterToOtherInstanceInstructions(this.sharedMasterInstanceBox.getValue(), this.instanceTypeListBox.getSelectedValue(), this.masterReplicationBearerTokenBox.getValue(), this.replicaReplicationBearerTokenBox.getValue(), (Integer)this.memoryInMegabytesBox.getValue(), (Integer)this.memoryTotalSizeFactorBox.getValue());
    }

    public static class MoveMasterToOtherInstanceInstructions {
        private final boolean sharedMasterInstance;
        private final String instanceTypeOrNull;
        private final Integer optionalMemoryInMegabytesOrNull;
        private final Integer optionalMemoryTotalSizeFactorOrNull;
        private final String masterReplicationBearerToken;
        private final String replicaReplicationBearerToken;

        public MoveMasterToOtherInstanceInstructions(boolean sharedMasterInstance, String instanceTypeOrNull, String masterReplicationBearerToken, String replicaReplicationBearerToken, Integer optionalMemoryInMegabytesOrNull, Integer optionalMemoryTotalSizeFactorOrNull) {
            this.sharedMasterInstance = sharedMasterInstance;
            this.instanceTypeOrNull = instanceTypeOrNull;
            this.optionalMemoryInMegabytesOrNull = optionalMemoryInMegabytesOrNull;
            this.optionalMemoryTotalSizeFactorOrNull = optionalMemoryTotalSizeFactorOrNull;
            this.masterReplicationBearerToken = masterReplicationBearerToken;
            this.replicaReplicationBearerToken = replicaReplicationBearerToken;
        }

        public boolean isSharedMasterInstance() {
            return this.sharedMasterInstance;
        }

        public String getDedicatedInstanceType() {
            return this.instanceTypeOrNull;
        }

        public Integer getOptionalMemoryInMegabytesOrNull() {
            return this.optionalMemoryInMegabytesOrNull;
        }

        public Integer getOptionalMemoryTotalSizeFactorOrNull() {
            return this.optionalMemoryTotalSizeFactorOrNull;
        }

        public String getInstanceTypeOrNull() {
            return this.instanceTypeOrNull;
        }

        public String getMasterReplicationBearerToken() {
            return this.masterReplicationBearerToken;
        }

        public String getReplicaReplicationBearerToken() {
            return this.replicaReplicationBearerToken;
        }
    }
}

