/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.server;

import com.sap.sailing.gwt.ui.server.StoredDataMiningQueryPersister;
import com.sap.sailing.server.impl.preferences.model.StoredDataMiningQueryPreference;
import com.sap.sailing.server.impl.preferences.model.StoredDataMiningQueryPreferences;
import com.sap.sse.common.Util;
import com.sap.sse.datamining.DataMiningServer;
import com.sap.sse.datamining.shared.dto.StatisticQueryDefinitionDTO;
import com.sap.sse.datamining.shared.dto.StoredDataMiningQueryDTO;
import com.sap.sse.datamining.shared.impl.dto.StoredDataMiningQueryDTOImpl;
import com.sap.sse.gwt.dispatch.shared.exceptions.ServerDispatchException;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.impl.User;
import com.sap.sse.serialization.Base64SerializerDeserializer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.shiro.authz.AuthorizationException;
import org.osgi.util.tracker.ServiceTracker;

public class StoredDataMiningQueryPersisterImpl
implements StoredDataMiningQueryPersister {
    private final SecurityService securityService;
    private final ServiceTracker<DataMiningServer, DataMiningServer> dataMiningServerTracker;

    public StoredDataMiningQueryPersisterImpl(SecurityService securityService, ServiceTracker<DataMiningServer, DataMiningServer> dataMiningServerTracker) {
        this.securityService = securityService;
        this.dataMiningServerTracker = dataMiningServerTracker;
    }

    public ArrayList<StoredDataMiningQueryDTOImpl> retrieveStoredQueries() {
        StoredDataMiningQueryPreferences prefs = (StoredDataMiningQueryPreferences)this.getPreferenceForCurrentUser("sailing.datamining.storedqueries");
        if (prefs == null) {
            return new ArrayList<StoredDataMiningQueryDTOImpl>();
        }
        return new ArrayList<StoredDataMiningQueryDTOImpl>(StreamSupport.stream(prefs.getStoredQueries().spliterator(), false).map(arg_0 -> this.transform(arg_0)).collect(Collectors.toList()));
    }

    public StoredDataMiningQueryDTO updateOrCreateStoredQuery(StoredDataMiningQueryDTO query) {
        StoredDataMiningQueryPreferences prefs = (StoredDataMiningQueryPreferences)this.getPreferenceForCurrentUser("sailing.datamining.storedqueries");
        Collection updatedQueries = this.removeQueryFromIterable(query, prefs);
        updatedQueries.add(this.transform(query));
        prefs = new StoredDataMiningQueryPreferences();
        prefs.setStoredQueries((Iterable)updatedQueries);
        this.setPreferenceForCurrentUser("sailing.datamining.storedqueries", (Object)prefs);
        return query;
    }

    public StoredDataMiningQueryDTO removeStoredQuery(StoredDataMiningQueryDTO query) {
        StoredDataMiningQueryPreferences prefs = (StoredDataMiningQueryPreferences)this.getPreferenceForCurrentUser("sailing.datamining.storedqueries");
        Collection updatedQueries = this.removeQueryFromIterable(query, prefs);
        prefs = new StoredDataMiningQueryPreferences();
        prefs.setStoredQueries((Iterable)updatedQueries);
        this.setPreferenceForCurrentUser("sailing.datamining.storedqueries", (Object)prefs);
        return query;
    }

    private Collection<StoredDataMiningQueryPreference> removeQueryFromIterable(StoredDataMiningQueryDTO query, StoredDataMiningQueryPreferences prefs) {
        if (prefs != null) {
            Iterable storedPrefs = prefs.getStoredQueries();
            storedPrefs = StreamSupport.stream(storedPrefs.spliterator(), false).filter(q -> !q.getId().equals(query.getId())).collect(Collectors.toList());
            ArrayList<StoredDataMiningQueryPreference> updatedEntries = new ArrayList<StoredDataMiningQueryPreference>();
            Util.addAll((Iterable)storedPrefs, updatedEntries);
            return updatedEntries;
        }
        return new ArrayList<StoredDataMiningQueryPreference>();
    }

    private void setPreferenceForCurrentUser(String preferenceKey, Object preference) {
        User currentUser = this.securityService.getCurrentUser();
        if (currentUser != null) {
            try {
                this.securityService.setPreferenceObject(currentUser.getName(), preferenceKey, preference);
            }
            catch (AuthorizationException e) {
                throw new ServerDispatchException((Throwable)e);
            }
        }
    }

    private StoredDataMiningQueryDTO transform(StoredDataMiningQueryPreference pref) {
        StatisticQueryDefinitionDTO query = ((DataMiningServer)this.dataMiningServerTracker.getService()).fromBase64String(pref.getSerializedQuery());
        return new StoredDataMiningQueryDTOImpl(pref.getName(), pref.getId(), query);
    }

    private StoredDataMiningQueryPreference transform(StoredDataMiningQueryDTO dto) {
        String serializedQuery = Base64SerializerDeserializer.toBase64((Serializable)dto.getQuery());
        return new StoredDataMiningQueryPreference(dto.getName(), dto.getId(), serializedQuery);
    }

    private <T> T getPreferenceForCurrentUser(String preferenceKey) {
        User currentUser = this.securityService.getCurrentUser();
        if (currentUser != null) {
            return (T)this.securityService.getPreferenceObject(currentUser.getName(), preferenceKey);
        }
        return null;
    }
}

