/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.datamining.presentation;

import com.google.gwt.user.client.ui.SimpleLayoutPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.datamining.presentation.AbstractSailingResultsPresenter;
import com.sap.sse.common.Util;
import com.sap.sse.common.settings.Settings;
import com.sap.sse.datamining.shared.GroupKey;
import com.sap.sse.datamining.shared.data.PairWithStats;
import com.sap.sse.datamining.shared.dto.StatisticQueryDefinitionDTO;
import com.sap.sse.datamining.shared.impl.CompoundGroupKey;
import com.sap.sse.datamining.shared.impl.dto.QueryResultDTO;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;
import java.util.HashMap;
import java.util.Map;
import org.moxieapps.gwt.highcharts.client.Chart;
import org.moxieapps.gwt.highcharts.client.ChartSubtitle;
import org.moxieapps.gwt.highcharts.client.ChartTitle;
import org.moxieapps.gwt.highcharts.client.Color;
import org.moxieapps.gwt.highcharts.client.Credits;
import org.moxieapps.gwt.highcharts.client.Exporting;
import org.moxieapps.gwt.highcharts.client.Point;
import org.moxieapps.gwt.highcharts.client.Series;
import org.moxieapps.gwt.highcharts.client.ToolTip;
import org.moxieapps.gwt.highcharts.client.ToolTipFormatter;
import org.moxieapps.gwt.highcharts.client.plotOptions.Marker;
import org.moxieapps.gwt.highcharts.client.plotOptions.SeriesPlotOptions;

public class NumberPairResultsPresenter
extends AbstractSailingResultsPresenter<Settings> {
    private QueryResultDTO<?> result;
    private final SimpleLayoutPanel chartPanel;
    private final Chart chart;
    private final Map<GroupKey, Series> seriesMappedByGroupKey = new HashMap();

    public NumberPairResultsPresenter(Component<?> parent, ComponentContext<?> context, StringMessages stringMessages) {
        super(parent, context, stringMessages);
        this.chartPanel = new /* Unavailable Anonymous Inner Class!! */;
        this.chart = this.createChart();
        this.chartPanel.setWidget((Widget)this.chart);
    }

    private Chart createChart() {
        Chart chart = (Chart)((Chart)((Chart)((Chart)((Chart)((Chart)((Chart)((Chart)((Chart)((Chart)new Chart().setType(Series.Type.SCATTER)).setMarginLeft((Number)100)).setMarginRight((Number)45)).setWidth100()).setHeight100()).setBorderColor(new Color("#F0AB00"))).setPlotBorderWidth((Number)0)).setCredits(new Credits().setEnabled(false))).setChartTitle(new ChartTitle().setText(""))).setChartSubtitle(new ChartSubtitle().setText(""));
        chart.setExporting(new Exporting().setEnabled(false));
        chart.getXAxis().setAllowDecimals(false);
        chart.getYAxis().setAxisTitleText("");
        chart.setToolTip(new ToolTip().setFormatter((ToolTipFormatter)new /* Unavailable Anonymous Inner Class!! */));
        return chart;
    }

    protected Widget getPresentationWidget() {
        return this.chartPanel;
    }

    protected void internalShowResults(StatisticQueryDefinitionDTO queryDefinition, QueryResultDTO<?> res) {
        this.chart.removeAllSeries(false);
        this.seriesMappedByGroupKey.clear();
        this.result = res;
        this.createAndAddSeriesToChart();
        for (Map.Entry resultEntry : this.result.getResults().entrySet()) {
            PairWithStats value = (PairWithStats)resultEntry.getValue();
            if (value.getIndividualPairs() != null) {
                for (Util.Pair pair : value.getIndividualPairs()) {
                    this.createAndAddPoint((GroupKey)resultEntry.getKey(), (Number)pair.getA(), (Number)pair.getB());
                }
                continue;
            }
            this.createAndAddPoint((GroupKey)resultEntry.getKey(), (Number)value.getAverage().getA(), (Number)value.getAverage().getB());
        }
        this.chart.getXAxis().setAxisTitleText(this.result.getResultSignifier());
    }

    private void createAndAddPoint(GroupKey key, Number x, Number y) {
        Point point = new Point(x, y);
        point.setName(key.asString());
        ((Series)this.seriesMappedByGroupKey.get(this.groupKeyToSeriesKey(key))).addPoint(point, false, false, false);
    }

    private void createAndAddSeriesToChart() {
        for (GroupKey groupKey : this.result.getResults().keySet()) {
            GroupKey seriesKey = this.groupKeyToSeriesKey(groupKey);
            if (this.seriesMappedByGroupKey.containsKey(seriesKey)) continue;
            this.seriesMappedByGroupKey.put(seriesKey, this.chart.createSeries().setPlotOptions(new SeriesPlotOptions().setMarker(new Marker().setSymbol(Marker.Symbol.CIRCLE))).setName(seriesKey.asString()));
            this.chart.addSeries((Series)this.seriesMappedByGroupKey.get(seriesKey), false, false);
        }
    }

    private GroupKey groupKeyToSeriesKey(GroupKey groupKey) {
        return new CompoundGroupKey(groupKey.getKeys());
    }

    public String getLocalizedShortName() {
        return this.getDataMiningStringMessages().numberPairResultsPresenter();
    }

    public boolean hasSettings() {
        return false;
    }

    public SettingsDialogComponent<Settings> getSettingsDialogComponent(Settings settings) {
        return null;
    }

    public void updateSettings(Settings newSettings) {
    }

    public Settings getSettings() {
        return null;
    }

    public String getId() {
        return "NumberPairResultsPresenter";
    }

    public String getDependentCssClassName() {
        return null;
    }

    static /* synthetic */ Chart access$0(NumberPairResultsPresenter numberPairResultsPresenter) {
        return numberPairResultsPresenter.chart;
    }
}

