/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.filter;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.filter.CompetitorsFilterSets;
import com.sap.sailing.gwt.ui.client.shared.filter.CompetitorsFilterSetsDialog;
import com.sap.sailing.gwt.ui.client.shared.filter.FilterWithUI;
import com.sap.sse.common.filter.FilterSet;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import java.util.ArrayList;
import java.util.List;

public class CompetitorsFilterSetsDialog
extends DataEntryDialog<CompetitorsFilterSets> {
    private final CompetitorsFilterSets competitorsFilterSets;
    private final StringMessages stringMessages;
    private final Button addFilterSetButton;
    private Grid competitorsFilterSetsGrid;
    private VerticalPanel mainPanel;
    private final List<String> availableCompetitorFilterNames;
    private final List<RadioButton> activeFilterSetRadioButtons;
    private final List<Button> editFilterSetButtons;
    private final List<Button> deleteFilterSetButtons;
    private final List<FilterSet<CompetitorDTO, FilterWithUI<CompetitorDTO>>> filterSets;
    private final String ACTIVE_FILTERSET_RADIOBUTTON_GROUPNAME = "ActiveFilterSetRB";
    private final String filterNothingFiltersetName;

    public CompetitorsFilterSetsDialog(CompetitorsFilterSets competitorsFilterSets, StringMessages stringMessages, DataEntryDialog.DialogCallback<CompetitorsFilterSets> callback) {
        super(stringMessages.competitorsFilter(), null, stringMessages.ok(), stringMessages.cancel(), (DataEntryDialog.Validator)new CompetitorsFilterSetsValidator(), callback);
        this.competitorsFilterSets = competitorsFilterSets;
        this.stringMessages = stringMessages;
        this.filterNothingFiltersetName = stringMessages.filterNothing();
        this.competitorsFilterSetsGrid = new Grid(0, 0);
        this.activeFilterSetRadioButtons = new ArrayList();
        this.editFilterSetButtons = new ArrayList();
        this.deleteFilterSetButtons = new ArrayList();
        this.filterSets = new ArrayList();
        this.addFilterSetButton = new Button(stringMessages.actionAddFilter());
        this.addFilterSetButton.addStyleName("btn-secondary");
        this.availableCompetitorFilterNames = new ArrayList();
        this.availableCompetitorFilterNames.add("CompetitorTotalRankFilter");
        this.availableCompetitorFilterNames.add("Race Rank");
        this.availableCompetitorFilterNames.add("CompetitorNationalityFilter");
        this.availableCompetitorFilterNames.add("CompetitorSailNumbersFilter");
    }

    protected Widget getAdditionalWidget() {
        this.mainPanel = new VerticalPanel();
        String headLineText = this.competitorsFilterSets.getFilterSets().size() < 1 ? this.stringMessages.createFilterHint() : this.stringMessages.availableFilters();
        this.mainPanel.add((Widget)new Label(headLineText));
        this.mainPanel.add((Widget)this.competitorsFilterSetsGrid);
        FilterSet noFilterSet = new FilterSet(this.filterNothingFiltersetName);
        this.createActiveFilterSetRadioButton(noFilterSet, this.competitorsFilterSets.getActiveFilterSet() == null);
        Button noFilterSetEditBtn = this.createEditFilterSetButton(noFilterSet);
        Button noFilterSetDeleteBtn = this.createDeleteFilterSetButton(noFilterSet);
        this.filterSets.add(noFilterSet);
        noFilterSetEditBtn.setVisible(false);
        noFilterSetDeleteBtn.setVisible(false);
        for (FilterSet filterSet : this.competitorsFilterSets.getFilterSets()) {
            this.createActiveFilterSetRadioButton(filterSet, this.competitorsFilterSets.getActiveFilterSet() == filterSet);
            this.createEditFilterSetButton(filterSet);
            this.createDeleteFilterSetButton(filterSet);
            this.filterSets.add(filterSet);
        }
        this.updateCompetitorsFilterSetsGrid(this.mainPanel);
        this.mainPanel.add((Widget)this.addFilterSetButton);
        this.addFilterSetButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return this.mainPanel;
    }

    private RadioButton createActiveFilterSetRadioButton(FilterSet<CompetitorDTO, FilterWithUI<CompetitorDTO>> filterSet, boolean isActiveFilterSet) {
        RadioButton activeFilterSetRadioButton = this.createRadioButton("ActiveFilterSetRB", filterSet.getName());
        activeFilterSetRadioButton.setValue(Boolean.valueOf(isActiveFilterSet));
        this.activeFilterSetRadioButtons.add(activeFilterSetRadioButton);
        return activeFilterSetRadioButton;
    }

    private Button createEditFilterSetButton(FilterSet<CompetitorDTO, FilterWithUI<CompetitorDTO>> filterSetToEdit) {
        Button editFilterSetBtn = new Button(this.stringMessages.edit());
        String filterSetToEditName = filterSetToEdit.getName();
        editFilterSetBtn.addStyleName("inlineButton");
        editFilterSetBtn.addStyleName("btn-secondary");
        editFilterSetBtn.setVisible(filterSetToEdit.isEditable());
        this.editFilterSetButtons.add(editFilterSetBtn);
        editFilterSetBtn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return editFilterSetBtn;
    }

    private Button createDeleteFilterSetButton(FilterSet<CompetitorDTO, FilterWithUI<CompetitorDTO>> filterSet) {
        Button deleteFilterSetBtn = new Button(this.stringMessages.delete());
        deleteFilterSetBtn.addStyleName("inlineButton");
        deleteFilterSetBtn.addStyleName("btn-secondary");
        deleteFilterSetBtn.setVisible(filterSet.isEditable());
        this.deleteFilterSetButtons.add(deleteFilterSetBtn);
        deleteFilterSetBtn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return deleteFilterSetBtn;
    }

    protected CompetitorsFilterSets getResult() {
        CompetitorsFilterSets result = new CompetitorsFilterSets();
        int filterSetCount = this.activeFilterSetRadioButtons.size();
        int i = 0;
        while (i < filterSetCount) {
            FilterSet filterSet = (FilterSet)this.filterSets.get(i);
            boolean isActiveFilterSet = ((RadioButton)this.activeFilterSetRadioButtons.get(i)).getValue();
            if (!filterSet.getName().equals(this.filterNothingFiltersetName)) {
                result.addFilterSet(filterSet);
                if (isActiveFilterSet) {
                    result.setActiveFilterSet(filterSet);
                }
            } else if (isActiveFilterSet) {
                result.setActiveFilterSet(null);
            }
            ++i;
        }
        return result;
    }

    private void updateCompetitorsFilterSetsGrid(VerticalPanel parentPanel) {
        int widgetIndex = parentPanel.getWidgetIndex((Widget)this.competitorsFilterSetsGrid);
        parentPanel.remove((Widget)this.competitorsFilterSetsGrid);
        int filterCount = this.activeFilterSetRadioButtons.size();
        if (filterCount > 0) {
            this.competitorsFilterSetsGrid = new Grid(filterCount, 3);
            this.competitorsFilterSetsGrid.setCellSpacing(3);
            int i = 0;
            while (i < filterCount) {
                this.competitorsFilterSetsGrid.setWidget(i, 0, (Widget)this.activeFilterSetRadioButtons.get(i));
                this.competitorsFilterSetsGrid.setWidget(i, 1, (Widget)this.editFilterSetButtons.get(i));
                this.competitorsFilterSetsGrid.setWidget(i, 2, (Widget)this.deleteFilterSetButtons.get(i));
                this.competitorsFilterSetsGrid.getCellFormatter().setVerticalAlignment(i, 0, HasVerticalAlignment.ALIGN_MIDDLE);
                this.competitorsFilterSetsGrid.getCellFormatter().setVerticalAlignment(i, 1, HasVerticalAlignment.ALIGN_MIDDLE);
                this.competitorsFilterSetsGrid.getCellFormatter().setVerticalAlignment(i, 2, HasVerticalAlignment.ALIGN_MIDDLE);
                ++i;
            }
        } else {
            this.competitorsFilterSetsGrid = new Grid(0, 0);
        }
        parentPanel.insert((Widget)this.competitorsFilterSetsGrid, widgetIndex);
    }

    static /* synthetic */ List access$1(CompetitorsFilterSetsDialog competitorsFilterSetsDialog) {
        return competitorsFilterSetsDialog.availableCompetitorFilterNames;
    }

    static /* synthetic */ StringMessages access$2(CompetitorsFilterSetsDialog competitorsFilterSetsDialog) {
        return competitorsFilterSetsDialog.stringMessages;
    }

    static /* synthetic */ RadioButton access$3(CompetitorsFilterSetsDialog competitorsFilterSetsDialog, FilterSet filterSet, boolean bl) {
        return competitorsFilterSetsDialog.createActiveFilterSetRadioButton(filterSet, bl);
    }

    static /* synthetic */ Button access$4(CompetitorsFilterSetsDialog competitorsFilterSetsDialog, FilterSet filterSet) {
        return competitorsFilterSetsDialog.createEditFilterSetButton(filterSet);
    }

    static /* synthetic */ Button access$5(CompetitorsFilterSetsDialog competitorsFilterSetsDialog, FilterSet filterSet) {
        return competitorsFilterSetsDialog.createDeleteFilterSetButton(filterSet);
    }

    static /* synthetic */ List access$6(CompetitorsFilterSetsDialog competitorsFilterSetsDialog) {
        return competitorsFilterSetsDialog.filterSets;
    }

    static /* synthetic */ VerticalPanel access$7(CompetitorsFilterSetsDialog competitorsFilterSetsDialog) {
        return competitorsFilterSetsDialog.mainPanel;
    }

    static /* synthetic */ void access$8(CompetitorsFilterSetsDialog competitorsFilterSetsDialog, VerticalPanel verticalPanel) {
        competitorsFilterSetsDialog.updateCompetitorsFilterSetsGrid(verticalPanel);
    }

    static /* synthetic */ void access$9(CompetitorsFilterSetsDialog competitorsFilterSetsDialog) {
        competitorsFilterSetsDialog.validateAndUpdate();
    }

    static /* synthetic */ List access$10(CompetitorsFilterSetsDialog competitorsFilterSetsDialog) {
        return competitorsFilterSetsDialog.activeFilterSetRadioButtons;
    }

    static /* synthetic */ List access$11(CompetitorsFilterSetsDialog competitorsFilterSetsDialog) {
        return competitorsFilterSetsDialog.editFilterSetButtons;
    }

    static /* synthetic */ List access$12(CompetitorsFilterSetsDialog competitorsFilterSetsDialog) {
        return competitorsFilterSetsDialog.deleteFilterSetButtons;
    }
}

