/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.filter;

import com.sap.sailing.domain.common.RaceIdentifier;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.LeaderboardDTO;
import com.sap.sailing.domain.common.dto.LeaderboardEntryDTO;
import com.sap.sailing.domain.common.dto.LeaderboardRowDTO;
import com.sap.sailing.domain.common.dto.RaceColumnDTO;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.filter.CompetitorRaceRankFilterUIFactory;
import com.sap.sailing.gwt.ui.client.shared.filter.FilterUIFactory;
import com.sap.sailing.gwt.ui.client.shared.filter.FilterWithUI;
import com.sap.sailing.gwt.ui.client.shared.filter.LeaderboardFetcher;
import com.sap.sailing.gwt.ui.client.shared.filter.LeaderboardFilterContext;
import com.sap.sailing.gwt.ui.client.shared.filter.QuickFlagDataValuesProvider;
import com.sap.sailing.gwt.ui.client.shared.filter.SelectedRaceFilterContext;
import com.sap.sse.common.filter.AbstractNumberFilter;
import java.util.LinkedHashSet;

public class CompetitorRaceRankFilter
extends AbstractNumberFilter<CompetitorDTO, Integer>
implements LeaderboardFilterContext,
SelectedRaceFilterContext,
FilterWithUI<CompetitorDTO> {
    public static final String FILTER_NAME = "Race Rank";
    private LeaderboardFetcher leaderboardFetcher;
    private RaceIdentifier selectedRace;
    private QuickFlagDataValuesProvider quickRankProvider;

    private LeaderboardDTO getLeaderboard() {
        return this.leaderboardFetcher != null ? this.leaderboardFetcher.getLeaderboard() : null;
    }

    public boolean matches(CompetitorDTO competitorDTO) {
        Integer raceRank = null;
        if (this.value != null && this.operator != null) {
            if (this.quickRankProvider != null) {
                raceRank = this.quickRankProvider.getRank(competitorDTO);
            } else if (this.getLeaderboard() != null && this.getSelectedRace() != null) {
                raceRank = this.getRankFromLeaderboard(competitorDTO);
            }
        }
        boolean result = raceRank != null ? this.operator.matchValues((Object)((Integer)this.value), raceRank) : false;
        return result;
    }

    private Integer getRankFromLeaderboard(CompetitorDTO competitorDTO) {
        Integer raceRank = null;
        RaceColumnDTO theRaceColumnDTOThatContainsCompetitorRace = null;
        for (RaceColumnDTO raceColumnDTO : this.getLeaderboard().getRaceList()) {
            if (!raceColumnDTO.containsRace(this.getSelectedRace())) continue;
            theRaceColumnDTOThatContainsCompetitorRace = raceColumnDTO;
            break;
        }
        LeaderboardRowDTO competitorRow = (LeaderboardRowDTO)this.getLeaderboard().rows.get(competitorDTO);
        LinkedHashSet<CompetitorDTO> competitorsRankedInColumn = new LinkedHashSet<CompetitorDTO>();
        if (theRaceColumnDTOThatContainsCompetitorRace != null && competitorRow != null) {
            LeaderboardEntryDTO entryDTO = (LeaderboardEntryDTO)competitorRow.fieldsByRaceColumnName.get(theRaceColumnDTOThatContainsCompetitorRace.getName());
            for (CompetitorDTO competitor : this.getLeaderboard().getCompetitorsFromBestToWorst(theRaceColumnDTOThatContainsCompetitorRace)) {
                competitorsRankedInColumn.add(competitor);
            }
            for (CompetitorDTO competitor : this.getLeaderboard().competitors) {
                if (competitorsRankedInColumn.contains(competitor)) continue;
                competitorsRankedInColumn.add(competitor);
            }
            raceRank = 0;
            for (CompetitorDTO competitor : competitorsRankedInColumn) {
                LeaderboardEntryDTO entryDTOIterated = (LeaderboardEntryDTO)((LeaderboardRowDTO)this.getLeaderboard().rows.get((Object)competitor)).fieldsByRaceColumnName.get(theRaceColumnDTOThatContainsCompetitorRace.getName());
                if (entryDTOIterated.fleet == null || entryDTO.fleet == null || entryDTOIterated.fleet.equals((Object)entryDTO.fleet)) {
                    raceRank = raceRank + 1;
                }
                if (competitor.equals(competitorDTO)) break;
            }
        }
        return raceRank;
    }

    public CompetitorRaceRankFilter copy() {
        CompetitorRaceRankFilter result = new CompetitorRaceRankFilter();
        result.setValue((Number)((Integer)this.getValue()));
        result.setOperator(this.getOperator());
        return result;
    }

    public String getName() {
        return FILTER_NAME;
    }

    public String getLocalizedName(StringMessages stringMessages) {
        return stringMessages.raceRank();
    }

    public String getLocalizedDescription(StringMessages stringMessages) {
        return "Top " + this.getValue() + " " + stringMessages.raceRank();
    }

    public String validate(StringMessages stringMessages) {
        String errorMessage = null;
        if (this.value != null) {
            Integer intfilterValue = (Integer)this.value;
            if (intfilterValue <= 0) {
                errorMessage = stringMessages.numberMustBePositive();
            }
        } else {
            errorMessage = stringMessages.pleaseEnterANumber();
        }
        return errorMessage;
    }

    public LeaderboardFetcher getLeaderboardFetcher() {
        return this.leaderboardFetcher;
    }

    public void setLeaderboardFetcher(LeaderboardFetcher leaderboardFetcher) {
        this.leaderboardFetcher = leaderboardFetcher;
    }

    public RaceIdentifier getSelectedRace() {
        return this.selectedRace;
    }

    public void setSelectedRace(RaceIdentifier selectedRace) {
        this.selectedRace = selectedRace;
    }

    public void setQuickRankProvider(QuickFlagDataValuesProvider quickRankProvider) {
        this.quickRankProvider = quickRankProvider;
    }

    public FilterUIFactory<CompetitorDTO> createUIFactory() {
        return new CompetitorRaceRankFilterUIFactory(this);
    }
}

