/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.media;

import com.google.gwt.event.logical.shared.AttachEvent;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.media.MediaTrackWithSecurityDTO;
import com.sap.sailing.gwt.ui.client.media.MediaSynchAdapter;
import com.sap.sailing.gwt.ui.client.media.VideoYoutubePlayer;
import com.sap.sailing.gwt.ui.client.media.YoutubeVideoControl;
import com.sap.sailing.gwt.ui.client.media.shared.AbstractMediaPlayer;
import com.sap.sailing.gwt.ui.client.media.shared.MediaSynchPlayer;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.gwt.client.media.MediaMenuIcon;
import com.sap.sse.gwt.client.media.TakedownNoticeService;
import com.sap.sse.gwt.client.player.Timer;
import com.sap.sse.gwt.common.CommonSharedResources;
import java.util.ArrayList;
import java.util.List;

public class VideoYoutubePlayer
extends AbstractMediaPlayer
implements MediaSynchPlayer,
MediaSynchAdapter,
IsWidget {
    private final Panel mediaWrapper;
    private final Panel videoContainer;
    private static int videoCounter;
    private final TimePoint raceStartTime;
    private final Timer raceTimer;
    private MediaSynchAdapter.EditFlag editFlag;
    private YoutubeVideoControl videoControl;
    private final MediaMenuIcon takedownButton;
    private boolean closing = false;
    private final List<DeferredAction> deferredActions = new ArrayList();

    public VideoYoutubePlayer(MediaTrackWithSecurityDTO videoTrack, TimePoint raceStartTime, Timer raceTimer, TakedownNoticeService takedownNoticeService, RegattaAndRaceIdentifier raceIdentifier) {
        super(videoTrack);
        this.raceTimer = raceTimer;
        this.raceStartTime = raceStartTime;
        this.mediaWrapper = new FlowPanel();
        this.mediaWrapper.addStyleName(CommonSharedResources.INSTANCE.mainCss().media_wrapper());
        this.mediaWrapper.setHeight("100%");
        this.mediaWrapper.setWidth("100%");
        this.takedownButton = new MediaMenuIcon(takedownNoticeService, "takedownRequestForRaceVideo");
        this.takedownButton.setFontSize("20px");
        this.takedownButton.setData(raceIdentifier.toString(), videoTrack.url);
        this.videoContainer = new SimplePanel();
        this.mediaWrapper.add((Widget)this.videoContainer);
        this.mediaWrapper.add((Widget)this.takedownButton);
        this.videoContainer.setStyleName("Youtube-Video-Panel");
        String videoContainerId = "videoContainer-" + videoTrack.url + ++videoCounter;
        this.videoContainer.getElement().setId(videoContainerId);
        this.videoContainer.getElement().setInnerText("When the Youtube video doesn't show up, click the popout button at the upper right corner to open the video in a dedicated browser window.");
        this.videoContainer.addAttachHandler((AttachEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void defer(DeferredAction deferredAction) {
        this.deferredActions.add(deferredAction);
    }

    public void shutDown() {
        if (!this.closing) {
            if (this.videoControl != null) {
                this.videoControl.pause();
            } else {
                this.defer((DeferredAction)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
    }

    public long getOffset() {
        return this.getMediaTrack().startTime.asMillis() - this.raceStartTime.asMillis();
    }

    public void changeOffsetBy(long delta) {
        this.getMediaTrack().startTime = this.getMediaTrack().startTime.plus(delta);
        this.forceAlign();
    }

    public void updateOffset() {
        this.getMediaTrack().startTime = new MillisecondsTimePoint(this.raceTimer.getTime().getTime() - this.getCurrentMediaTimeMillis());
    }

    public void pauseRace() {
        this.raceTimer.pause();
    }

    public void setControlsVisible(boolean isVisible) {
        if (!this.closing) {
            if (this.videoControl != null) {
                this.videoControl.setControlsVisible(isVisible);
            } else {
                this.defer((DeferredAction)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
    }

    public boolean isMediaPaused() {
        if (this.closing) {
            return true;
        }
        if (this.videoControl != null) {
            return this.videoControl.isPaused();
        }
        return true;
    }

    public void pauseMedia() {
        if (!this.isEditing() && !this.closing) {
            if (this.videoControl != null) {
                this.videoControl.pause();
            } else {
                this.defer((DeferredAction)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
    }

    public void playMedia() {
        if (!this.isEditing() && !this.closing) {
            if (this.videoControl != null) {
                this.videoControl.play();
            } else {
                this.defer((DeferredAction)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
    }

    public double getDuration() {
        if (this.videoControl != null && !this.closing) {
            return this.videoControl.getDuration();
        }
        return 0.0;
    }

    public double getCurrentMediaTime() {
        if (this.videoControl != null && !this.closing) {
            return this.videoControl.getCurrentTime();
        }
        return 0.0;
    }

    public void setCurrentMediaTime(double mediaTime) {
        if (!this.closing) {
            if (this.videoControl != null) {
                this.videoControl.setCurrentTime(mediaTime);
            } else {
                this.defer((DeferredAction)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
    }

    public void setPlaybackSpeed(double newPlaySpeedFactor) {
        if (!this.closing) {
            if (this.videoControl != null) {
                this.videoControl.setPlaybackSpeed(newPlaySpeedFactor);
            } else {
                this.defer((DeferredAction)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
    }

    public void setMuted(boolean isToBeMuted) {
        if (!this.closing) {
            if (this.videoControl != null) {
                this.videoControl.setMuted(isToBeMuted);
            } else {
                this.defer((DeferredAction)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
    }

    protected void alignTime() {
        if (!this.isEditing()) {
            super.alignTime();
        }
    }

    public Widget asWidget() {
        return this.mediaWrapper;
    }

    public void setEditFlag(MediaSynchAdapter.EditFlag editFlag) {
        this.editFlag = editFlag;
    }

    private boolean isEditing() {
        return this.editFlag != null && this.editFlag.isEditing();
    }

    public int getDefaultWidth() {
        return -1;
    }

    public int getDefaultHeight() {
        return -1;
    }

    static /* synthetic */ void access$0(VideoYoutubePlayer videoYoutubePlayer, YoutubeVideoControl youtubeVideoControl) {
        videoYoutubePlayer.videoControl = youtubeVideoControl;
    }

    static /* synthetic */ List access$1(VideoYoutubePlayer videoYoutubePlayer) {
        return videoYoutubePlayer.deferredActions;
    }

    static /* synthetic */ void access$2(VideoYoutubePlayer videoYoutubePlayer, boolean bl) {
        videoYoutubePlayer.closing = bl;
    }
}

