/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.dto.RaceDTO;
import com.sap.sailing.domain.common.dto.TrackedRaceDTO;
import com.sap.sailing.domain.common.media.MediaTrack;
import com.sap.sailing.gwt.ui.adminconsole.TrackedRacesListComposite;
import com.sap.sailing.gwt.ui.adminconsole.places.AdminConsoleView;
import com.sap.sailing.gwt.ui.client.Displayer;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.RegattaDTO;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import java.util.HashSet;
import java.util.Set;

public class AssignRacesToMediaDialog
extends DataEntryDialog<Set<RegattaAndRaceIdentifier>> {
    protected StringMessages stringMessages;
    protected final TrackedRacesListComposite trackedRacesListComposite;
    protected final MediaTrack mediaTrack;
    public boolean hasRaceCandidates = false;
    public boolean started = false;
    private final VerticalPanel panel;
    private Button btnRefresh;
    private final Displayer<RegattaDTO> regattasDisplayer = new /* Unavailable Anonymous Inner Class!! */;

    public Displayer<RegattaDTO> getRegattasDisplayer() {
        return this.regattasDisplayer;
    }

    public AssignRacesToMediaDialog(AdminConsoleView.Presenter presenter, MediaTrack mediaTrack, StringMessages stringMessages, DataEntryDialog.Validator<Set<RegattaAndRaceIdentifier>> validator, DataEntryDialog.DialogCallback<Set<RegattaAndRaceIdentifier>> callback) {
        super(stringMessages.linkedRaces(), stringMessages.selectFromRacesWithOverlappingTimeRange(), stringMessages.ok(), stringMessages.cancel(), validator, callback);
        this.stringMessages = stringMessages;
        this.mediaTrack = mediaTrack;
        this.trackedRacesListComposite = new /* Unavailable Anonymous Inner Class!! */;
        this.trackedRacesListComposite.ensureDebugId("TrackedRacesListComposite");
        presenter.getRegattasRefresher().reloadAndCallFillAll();
        this.panel = new VerticalPanel();
        Grid formGrid = new Grid(2, 2);
        this.panel.add((Widget)formGrid);
        Label message = new Label();
        message.setText(stringMessages.loadingRegattasAndRaces());
        formGrid.setWidget(0, 0, (Widget)message);
        formGrid.setWidget(1, 1, (Widget)this.trackedRacesListComposite);
        formGrid.getWidget(1, 1).setVisible(false);
        this.getOkButton().setVisible(false);
    }

    public Widget getAdditionalWidget() {
        return this.panel;
    }

    protected Set<RegattaAndRaceIdentifier> getResult() {
        return this.getAssignedRaces();
    }

    public void fillRegattas(Iterable<RegattaDTO> result) {
        this.hasRaceCandidates = false;
        this.trackedRacesListComposite.fillRegattas(result);
        for (RegattaAndRaceIdentifier assignedRace : this.mediaTrack.assignedRaces) {
            this.trackedRacesListComposite.selectRaceByIdentifier(assignedRace);
        }
        this.updateUI();
    }

    private void updateUI() {
        Grid grid = (Grid)this.panel.getWidget(0);
        if (this.hasRaceCandidates) {
            grid.getWidget(0, 0).setVisible(false);
            grid.getWidget(1, 1).setVisible(true);
            this.getOkButton().setVisible(true);
        } else {
            Label label = (Label)grid.getWidget(0, 0);
            label.setText(this.stringMessages.noRacesAvailable());
            grid.getWidget(0, 0).setVisible(true);
            grid.getWidget(1, 1).setVisible(false);
            this.getOkButton().setVisible(false);
        }
    }

    public Set<RegattaAndRaceIdentifier> getAssignedRaces() {
        Set races = this.trackedRacesListComposite.getSelectionModel().getSelectedSet();
        HashSet<RegattaAndRaceIdentifier> assignedRaces = new HashSet<RegattaAndRaceIdentifier>();
        for (RaceDTO race : races) {
            assignedRaces.add(race.getRaceIdentifier());
        }
        return assignedRaces;
    }

    public void hideRefreshButton() {
        this.btnRefresh.setVisible(false);
    }

    private boolean mediaTrackIsInTimerangeOf(TrackedRaceDTO race) {
        return (race.endOfTracking == null || !this.mediaTrack.beginsAfter(race.endOfTracking)) && (race.startOfTracking == null || !this.mediaTrack.endsBefore(race.startOfTracking));
    }

    static /* synthetic */ boolean access$1(AssignRacesToMediaDialog assignRacesToMediaDialog, TrackedRaceDTO trackedRaceDTO) {
        return assignRacesToMediaDialog.mediaTrackIsInTimerangeOf(trackedRaceDTO);
    }

    static /* synthetic */ void access$2(AssignRacesToMediaDialog assignRacesToMediaDialog, Button button) {
        assignRacesToMediaDialog.btnRefresh = button;
    }
}

