/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.RegattaNameAndRaceName;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.FleetDTO;
import com.sap.sailing.domain.common.dto.RaceColumnDTO;
import com.sap.sailing.domain.common.dto.RaceDTO;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.gwt.common.client.help.HelpButton;
import com.sap.sailing.gwt.common.client.help.HelpButtonResources;
import com.sap.sailing.gwt.ui.adminconsole.AbstractBoatCertificatesPanel;
import com.sap.sailing.gwt.ui.adminconsole.AbstractLeaderboardConfigPanel;
import com.sap.sailing.gwt.ui.adminconsole.BoatCertificateAssignmentDialog;
import com.sap.sailing.gwt.ui.adminconsole.NameBasedStrippedLeaderboardDTOEntityIdentityComparator;
import com.sap.sailing.gwt.ui.adminconsole.RaceBoatCertificatesPanel;
import com.sap.sailing.gwt.ui.adminconsole.RaceColumnInLeaderboardDialog;
import com.sap.sailing.gwt.ui.adminconsole.RaceLogDialog;
import com.sap.sailing.gwt.ui.adminconsole.RaceTableWrapper;
import com.sap.sailing.gwt.ui.adminconsole.RegattaLogDialog;
import com.sap.sailing.gwt.ui.adminconsole.SelectedLeaderboardProvider;
import com.sap.sailing.gwt.ui.adminconsole.TrackedRaceChangedListener;
import com.sap.sailing.gwt.ui.adminconsole.TrackedRacesListComposite;
import com.sap.sailing.gwt.ui.adminconsole.places.AdminConsoleView;
import com.sap.sailing.gwt.ui.client.Displayer;
import com.sap.sailing.gwt.ui.client.Refresher;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.RaceLogDTO;
import com.sap.sailing.gwt.ui.shared.RegattaDTO;
import com.sap.sailing.gwt.ui.shared.RegattaLogDTO;
import com.sap.sailing.gwt.ui.shared.StrippedLeaderboardDTO;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.adminconsole.AdminConsoleTableResources;
import com.sap.sse.gwt.adminconsole.FilterablePanelProvider;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.Notification;
import com.sap.sse.gwt.client.async.MarkedAsyncCallback;
import com.sap.sse.gwt.client.celltable.EntityIdentityComparator;
import com.sap.sse.gwt.client.celltable.FlushableCellTable;
import com.sap.sse.gwt.client.celltable.RefreshableMultiSelectionModel;
import com.sap.sse.gwt.client.celltable.RefreshableSelectionModel;
import com.sap.sse.gwt.client.celltable.SelectionCheckboxColumn;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.panels.AbstractFilterablePanel;
import com.sap.sse.gwt.client.panels.LabeledAbstractFilterablePanel;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.AccessControlledButtonPanel;
import com.sap.sse.security.ui.client.subscription.SubscriptionServiceFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;

public abstract class AbstractLeaderboardConfigPanel
extends FormPanel
implements SelectedLeaderboardProvider<StrippedLeaderboardDTO>,
TrackedRaceChangedListener,
FilterablePanelProvider<StrippedLeaderboardDTO> {
    protected final VerticalPanel mainPanel;
    protected final TrackedRacesListComposite trackedRacesListComposite;
    protected final StringMessages stringMessages;
    protected final SailingServiceWriteAsync sailingServiceWrite;
    protected final ListDataProvider<StrippedLeaderboardDTO> filteredLeaderboardList;
    protected final ErrorReporter errorReporter;
    protected final FlushableCellTable<StrippedLeaderboardDTO> leaderboardTable;
    protected final RaceTableWrapper<RefreshableSelectionModel<RaceColumnDTOAndFleetDTOWithNameBasedEquality>> raceColumnTable;
    protected final RefreshableSelectionModel<RaceColumnDTOAndFleetDTOWithNameBasedEquality> raceColumnTableSelectionModel;
    protected RaceColumnDTOAndFleetDTOWithNameBasedEquality selectedRaceInLeaderboard;
    protected final CaptionPanel selectedLeaderBoardPanel;
    protected final CaptionPanel trackedRacesCaptionPanel;
    protected final List<RegattaDTO> allRegattas;
    protected LabeledAbstractFilterablePanel<StrippedLeaderboardDTO> filterLeaderboardPanel;
    protected List<StrippedLeaderboardDTO> availableLeaderboardList;
    protected final RefreshableMultiSelectionModel<StrippedLeaderboardDTO> leaderboardSelectionModel;
    protected final RefreshableSelectionModel<RaceDTO> refreshableTrackedRaceSelectionModel;
    protected final SelectionChangeEvent.Handler trackedRaceListHandler;
    protected HandlerRegistration trackedRaceListHandlerRegistration;
    protected final AdminConsoleView.Presenter presenter;
    private final Button reloadAllRaceLogs;
    protected UserService userService;
    protected SubscriptionServiceFactory subscriptionServiceFactory;
    private final Displayer<StrippedLeaderboardDTO> leaderboardsDisplayer = new /* Unavailable Anonymous Inner Class!! */;
    private final Displayer<RegattaDTO> regattasDisplayer = new /* Unavailable Anonymous Inner Class!! */;

    public Displayer<StrippedLeaderboardDTO> getLeaderboardsDisplayer() {
        return this.leaderboardsDisplayer;
    }

    public Displayer<RegattaDTO> getRegattasDisplayer() {
        return this.regattasDisplayer;
    }

    public AbstractLeaderboardConfigPanel(AdminConsoleView.Presenter presenter, StringMessages theStringConstants, boolean multiSelection) {
        RefreshableMultiSelectionModel multiSelectionModel;
        this.stringMessages = theStringConstants;
        this.sailingServiceWrite = presenter.getSailingService();
        this.userService = presenter.getUserService();
        this.subscriptionServiceFactory = presenter.getSubscriptionServiceFactory();
        this.filteredLeaderboardList = new ListDataProvider();
        this.allRegattas = new ArrayList();
        this.errorReporter = presenter.getErrorReporter();
        this.presenter = presenter;
        this.availableLeaderboardList = new ArrayList();
        this.mainPanel = new VerticalPanel();
        this.mainPanel.setWidth("100%");
        this.setWidget((Widget)this.mainPanel);
        CaptionPanel leaderboardsCaptionPanel = new CaptionPanel(this.stringMessages.leaderboards());
        leaderboardsCaptionPanel.setStyleName("bold");
        this.mainPanel.add((Widget)leaderboardsCaptionPanel);
        VerticalPanel leaderboardsPanel = new VerticalPanel();
        leaderboardsCaptionPanel.add((Widget)leaderboardsPanel);
        AccessControlledButtonPanel buttonPanel = new AccessControlledButtonPanel(this.userService, SecuredDomainType.LEADERBOARD);
        Label lblFilterEvents = new Label(String.valueOf(this.stringMessages.filterLeaderboardsByName()) + ": ");
        leaderboardsPanel.add((Widget)buttonPanel);
        Button createLeaderboardRefreshBtn = buttonPanel.addAction(this.stringMessages.refresh(), () -> true, (Command)new /* Unavailable Anonymous Inner Class!! */);
        createLeaderboardRefreshBtn.ensureDebugId("LeaderboardRefreshButton");
        AdminConsoleTableResources tableRes = (AdminConsoleTableResources)GWT.create(AdminConsoleTableResources.class);
        this.leaderboardTable = new FlushableCellTable(10000, (CellTable.Resources)tableRes);
        this.filterLeaderboardPanel = new /* Unavailable Anonymous Inner Class!! */;
        this.filterLeaderboardPanel.getTextBox().ensureDebugId("LeaderboardsFilterTextBox");
        this.filterLeaderboardPanel.setUpdatePermissionFilterForCheckbox(leaderboard -> this.userService.hasPermission((SecuredDTO)leaderboard, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE));
        leaderboardsPanel.add((Widget)this.filterLeaderboardPanel);
        this.leaderboardTable.ensureDebugId("AvailableLeaderboardsTable");
        this.addColumnsToLeaderboardTableAndSetSelectionModel(this.userService, this.leaderboardTable, tableRes, this.filterLeaderboardPanel.getAllListDataProvider());
        this.leaderboardSelectionModel = multiSelectionModel = (RefreshableMultiSelectionModel)this.leaderboardTable.getSelectionModel();
        this.leaderboardTable.setWidth("100%");
        this.leaderboardSelectionModel.addSelectionChangeHandler((SelectionChangeEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
        this.addLeaderboardControls(buttonPanel);
        this.filteredLeaderboardList.addDataDisplay((HasData)this.leaderboardTable);
        leaderboardsPanel.add((Widget)this.leaderboardTable);
        Grid hPanel = new Grid(1, 2);
        Label helpLabel = new Label(this.stringMessages.helptextLinkingRaces());
        hPanel.setWidget(0, 0, (Widget)helpLabel);
        hPanel.setWidget(0, 1, (Widget)new HelpButton(HelpButtonResources.INSTANCE, this.stringMessages.videoGuide(), "https://vimeo.com/768053778/922b629cc4"));
        this.mainPanel.add((Widget)hPanel);
        HorizontalPanel splitPanel = new HorizontalPanel();
        splitPanel.ensureDebugId("LeaderboardDetailsPanel");
        splitPanel.setWidth("100%");
        this.mainPanel.add((Widget)splitPanel);
        this.selectedLeaderBoardPanel = new CaptionPanel(this.stringMessages.leaderboard());
        splitPanel.add((Widget)this.selectedLeaderBoardPanel);
        VerticalPanel vPanel = new VerticalPanel();
        this.selectedLeaderBoardPanel.setContentWidget((Widget)vPanel);
        this.trackedRacesCaptionPanel = new CaptionPanel(this.stringMessages.trackedRaces());
        splitPanel.add((Widget)this.trackedRacesCaptionPanel);
        VerticalPanel trackedRacesPanel = new VerticalPanel();
        this.trackedRacesCaptionPanel.setContentWidget((Widget)trackedRacesPanel);
        this.trackedRacesCaptionPanel.setStyleName("bold");
        this.trackedRacesListComposite = new TrackedRacesListComposite(null, null, presenter, this.stringMessages, false, this.isActionButtonsEnabled());
        this.refreshableTrackedRaceSelectionModel = this.trackedRacesListComposite.getSelectionModel();
        this.trackedRacesListComposite.ensureDebugId("TrackedRacesListComposite");
        trackedRacesPanel.add((Widget)this.trackedRacesListComposite);
        this.trackedRacesListComposite.addTrackedRaceChangeListener((TrackedRaceChangedListener)this);
        this.trackedRaceListHandler = new /* Unavailable Anonymous Inner Class!! */;
        this.trackedRaceListHandlerRegistration = this.refreshableTrackedRaceSelectionModel.addSelectionChangeHandler(this.trackedRaceListHandler);
        this.reloadAllRaceLogs = new Button(this.stringMessages.reloadAllRaceLogs());
        this.reloadAllRaceLogs.ensureDebugId("ReloadAllRaceLogsButton");
        this.reloadAllRaceLogs.addClickHandler(event -> {
            StrippedLeaderboardDTO leaderboard = this.getSelectedLeaderboard();
            for (RaceColumnDTO column : leaderboard.getRaceList()) {
                for (FleetDTO fleet : column.getFleets()) {
                    this.refreshRaceLog(column, fleet, false);
                }
            }
            Notification.notify((String)this.stringMessages.raceLogReloaded(), (Notification.NotificationType)Notification.NotificationType.SUCCESS);
        });
        vPanel.add((Widget)this.reloadAllRaceLogs);
        Label lblRaceNamesIn = new Label(this.stringMessages.races());
        vPanel.add((Widget)lblRaceNamesIn);
        this.raceColumnTable = new RaceTableWrapper(this.sailingServiceWrite, this.stringMessages, this.errorReporter, multiSelection);
        this.raceColumnTable.asWidget().ensureDebugId("RaceColumnTable");
        this.raceColumnTable.getTable().setWidth("100%");
        this.addColumnsToRacesTable((CellTable)this.raceColumnTable.getTable());
        this.raceColumnTableSelectionModel = this.raceColumnTable.getSelectionModel();
        this.raceColumnTableSelectionModel.addSelectionChangeHandler(event -> {
            this.removeTrackedRaceListHandlerTemporarily();
            this.leaderboardRaceColumnSelectionChanged();
        });
        vPanel.add((IsWidget)this.raceColumnTable);
        HorizontalPanel selectedLeaderboardRaceButtonPanel = new HorizontalPanel();
        selectedLeaderboardRaceButtonPanel.setSpacing(5);
        vPanel.add((Widget)selectedLeaderboardRaceButtonPanel);
        this.addSelectedLeaderboardRacesControls((Panel)selectedLeaderboardRaceButtonPanel);
    }

    protected boolean isActionButtonsEnabled() {
        return false;
    }

    protected abstract void addLeaderboardControls(AccessControlledButtonPanel var1);

    protected abstract void addSelectedLeaderboardRacesControls(Panel var1);

    protected abstract void addColumnsToLeaderboardTableAndSetSelectionModel(UserService var1, FlushableCellTable<StrippedLeaderboardDTO> var2, AdminConsoleTableResources var3, ListDataProvider<StrippedLeaderboardDTO> var4);

    protected abstract void addColumnsToRacesTable(CellTable<RaceColumnDTOAndFleetDTOWithNameBasedEquality> var1);

    protected SelectionCheckboxColumn<StrippedLeaderboardDTO> createSortableSelectionCheckboxColumn(FlushableCellTable<StrippedLeaderboardDTO> leaderboardTable, AdminConsoleTableResources tableResources, ColumnSortEvent.ListHandler<StrippedLeaderboardDTO> leaderboardColumnListHandler, ListDataProvider<StrippedLeaderboardDTO> listDataProvider) {
        SelectionCheckboxColumn selectionCheckboxColumn = new SelectionCheckboxColumn(tableResources.cellTableStyle().cellTableCheckboxSelected(), tableResources.cellTableStyle().cellTableCheckboxDeselected(), tableResources.cellTableStyle().cellTableCheckboxColumnCell(), (EntityIdentityComparator)new NameBasedStrippedLeaderboardDTOEntityIdentityComparator(), listDataProvider, leaderboardTable);
        selectionCheckboxColumn.setSortable(true);
        leaderboardColumnListHandler.setComparator((Column)selectionCheckboxColumn, (o1, o2) -> (leaderboardTable.getSelectionModel().isSelected(o1) ? 1 : 0) - (leaderboardTable.getSelectionModel().isSelected(o2) ? 1 : 0));
        return selectionCheckboxColumn;
    }

    public void fillLeaderboards(Iterable<StrippedLeaderboardDTO> result) {
        this.availableLeaderboardList.clear();
        Util.addAll(result, (Collection)this.availableLeaderboardList);
        this.filterLeaderboardPanel.updateAll((Iterable)this.availableLeaderboardList);
        this.leaderboardSelectionChanged();
        this.leaderboardRaceColumnSelectionChanged();
    }

    public void loadAndRefreshLeaderboard(String leaderboardName) {
        MarkedAsyncCallback callback = new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        this.sailingServiceWrite.getLeaderboardWithSecurity(leaderboardName, (AsyncCallback)callback);
    }

    public void loadAndRefreshLeaderboard(StrippedLeaderboardDTO leaderboard) {
        for (StrippedLeaderboardDTO leaderboardDTO : this.leaderboardSelectionModel.getSelectedSet()) {
            if (!leaderboardDTO.getName().equals(leaderboard.getName())) continue;
            this.leaderboardSelectionModel.setSelected((Object)leaderboardDTO, false);
            break;
        }
        this.replaceLeaderboardInList(this.availableLeaderboardList, leaderboard.getName(), leaderboard);
        this.filterLeaderboardPanel.updateAll((Iterable)this.availableLeaderboardList);
        this.leaderboardSelectionModel.setSelected((Object)leaderboard, true);
        this.leaderboardSelectionChanged();
        this.getLeaderboardsRefresher().updateAndCallFillForAll((Iterable)this.filteredLeaderboardList.getList(), this.getLeaderboardsDisplayer());
    }

    private void replaceLeaderboardInList(List<StrippedLeaderboardDTO> leaderboardList, String leaderboardToReplace, StrippedLeaderboardDTO newLeaderboard) {
        int index = -1;
        for (StrippedLeaderboardDTO existingLeaderboard : leaderboardList) {
            ++index;
            if (existingLeaderboard.getName().equals(leaderboardToReplace)) break;
        }
        if (index >= 0) {
            leaderboardList.set(index, newLeaderboard);
        }
    }

    protected void unlinkRaceColumnFromTrackedRace(String raceColumnName, FleetDTO fleet) {
        String selectedLeaderboardName = this.getSelectedLeaderboardName();
        this.sailingServiceWrite.disconnectLeaderboardColumnFromTrackedRace(selectedLeaderboardName, raceColumnName, fleet.getName(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void refreshRaceLog(RaceColumnDTO raceColumnDTO, FleetDTO fleet, boolean showAlerts) {
        String selectedLeaderboardName = this.getSelectedLeaderboardName();
        this.sailingServiceWrite.reloadRaceLog(selectedLeaderboardName, raceColumnDTO, fleet, (AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
    }

    protected abstract void leaderboardRaceColumnSelectionChanged();

    protected void selectRaceColumn(String raceColumnName) {
        List list = this.raceColumnTable.getDataProvider().getList();
        for (RaceColumnDTOAndFleetDTOWithNameBasedEquality pair : list) {
            if (!((RaceColumnDTO)pair.getA()).getName().equals(raceColumnName)) continue;
            this.raceColumnTable.getSelectionModel().setSelected((Object)pair, true);
            break;
        }
    }

    protected void selectTrackedRaceInRaceList() {
        String selectedLeaderboardName = this.getSelectedLeaderboardName();
        if (selectedLeaderboardName != null) {
            RaceColumnDTOAndFleetDTOWithNameBasedEquality selectedRaceColumnAndFleetNameInLeaderboard = this.getSelectedRaceColumnWithFleet();
            String selectedRaceColumnName = ((RaceColumnDTO)selectedRaceColumnAndFleetNameInLeaderboard.getA()).getRaceColumnName();
            String selectedFleetName = ((FleetDTO)selectedRaceColumnAndFleetNameInLeaderboard.getB()).getName();
            this.sailingServiceWrite.getRegattaAndRaceNameOfTrackedRaceConnectedToLeaderboardColumn(selectedLeaderboardName, selectedRaceColumnName, (AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
        }
    }

    protected void selectRaceInList(String regattaName, String raceName) {
        RegattaNameAndRaceName raceIdentifier = new RegattaNameAndRaceName(regattaName, raceName);
        this.trackedRacesListComposite.selectRaceByIdentifier((RegattaAndRaceIdentifier)raceIdentifier);
    }

    protected RaceColumnDTOAndFleetDTOWithNameBasedEquality getSelectedRaceColumnWithFleet() {
        if (this.raceColumnTable.getSelectionModel().getSelectedSet().isEmpty()) {
            return null;
        }
        return (RaceColumnDTOAndFleetDTOWithNameBasedEquality)this.raceColumnTable.getSelectionModel().getSelectedSet().iterator().next();
    }

    protected String getSelectedLeaderboardName() {
        return this.getSelectedLeaderboard() != null ? this.getSelectedLeaderboard().getName() : null;
    }

    protected boolean canBoatsOfCompetitorsChangePerRace() {
        return this.getSelectedLeaderboard() != null ? this.getSelectedLeaderboard().canBoatsOfCompetitorsChangePerRace : false;
    }

    protected abstract void leaderboardSelectionChanged();

    public void fillRegattas(Iterable<RegattaDTO> regattas) {
        this.removeTrackedRaceListHandlerTemporarily();
        this.trackedRacesListComposite.fillRegattas(regattas);
        this.allRegattas.clear();
        Util.addAll(regattas, (Collection)this.allRegattas);
    }

    public void racesStoppedTracking(Iterable<? extends RegattaAndRaceIdentifier> regattaAndRaceIdentifiers) {
    }

    public void racesRemoved(Iterable<? extends RegattaAndRaceIdentifier> regattaAndRaceIdentifiers) {
        for (RegattaAndRaceIdentifier regattaAndRaceIdentifier : regattaAndRaceIdentifiers) {
            for (StrippedLeaderboardDTO leaderboard : this.filteredLeaderboardList.getList()) {
                for (RaceColumnDTO raceColumn : leaderboard.getRaceList()) {
                    for (FleetDTO fleet : raceColumn.getFleets()) {
                        if (!Util.equalsWithNull((Object)raceColumn.getRaceIdentifier(fleet), (Object)regattaAndRaceIdentifier)) continue;
                        raceColumn.setRaceIdentifier(fleet, null);
                        raceColumn.getRaceLogTrackingInfo((FleetDTO)fleet).raceLogTrackerExists = false;
                    }
                }
            }
        }
        this.raceColumnTable.getDataProvider().refresh();
    }

    protected void onTrackedRaceForRaceInRaceColumnTableRemoved(RaceColumnDTOAndFleetDTOWithNameBasedEquality raceColumnAndFleetName) {
        ((RaceColumnDTO)raceColumnAndFleetName.getA()).setRaceIdentifier((FleetDTO)raceColumnAndFleetName.getB(), null);
    }

    private void linkTrackedRaceToSelectedRaceColumn(RaceColumnDTO selectedRaceInLeaderboard, FleetDTO fleet, RegattaAndRaceIdentifier selectedRace) {
        this.sailingServiceWrite.connectTrackedRaceToLeaderboardColumn(this.getSelectedLeaderboardName(), selectedRaceInLeaderboard.getRaceColumnName(), fleet.getName(), selectedRace, (AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
    }

    public StrippedLeaderboardDTO getSelectedLeaderboard() {
        return this.leaderboardSelectionModel.getSelectedSet().isEmpty() ? null : (StrippedLeaderboardDTO)this.leaderboardSelectionModel.getSelectedSet().iterator().next();
    }

    protected Refresher<StrippedLeaderboardDTO> getLeaderboardsRefresher() {
        return this.presenter.getLeaderboardsRefresher();
    }

    protected void editRaceColumnOfLeaderboard(RaceColumnDTOAndFleetDTOWithNameBasedEquality raceColumnWithFleet) {
        String selectedLeaderboardName = this.getSelectedLeaderboardName();
        boolean oldIsMedalRace = ((RaceColumnDTO)raceColumnWithFleet.getA()).isMedalRace();
        String oldRaceColumnName = ((RaceColumnDTO)raceColumnWithFleet.getA()).getRaceColumnName();
        Double oldExplicitFactor = ((RaceColumnDTO)raceColumnWithFleet.getA()).getExplicitFactor();
        HashSet<RaceColumnDTO> existingRacesWithoutThisRace = new HashSet<RaceColumnDTO>();
        for (RaceColumnDTOAndFleetDTOWithNameBasedEquality pair : this.raceColumnTable.getDataProvider().getList()) {
            existingRacesWithoutThisRace.add((RaceColumnDTO)pair.getA());
        }
        existingRacesWithoutThisRace.remove(raceColumnWithFleet.getA());
        RaceColumnInLeaderboardDialog raceDialog = new RaceColumnInLeaderboardDialog(existingRacesWithoutThisRace, (RaceColumnDTO)raceColumnWithFleet.getA(), this.getSelectedLeaderboard().type.isRegattaLeaderboard(), this.stringMessages, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
        raceDialog.show();
    }

    protected void showRaceLog(RaceColumnDTO raceColumnDTO, FleetDTO fleetDTO) {
        String selectedLeaderboardName = this.getSelectedLeaderboardName();
        this.sailingServiceWrite.getRaceLog(selectedLeaderboardName, raceColumnDTO, fleetDTO, (AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
    }

    private void openRaceLogDialog(RaceLogDTO raceLogDTO) {
        RaceLogDialog dialog = new RaceLogDialog(raceLogDTO, this.stringMessages, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
        dialog.show();
    }

    protected void showRegattaLog() {
        String selectedLeaderboardName = this.getSelectedLeaderboardName();
        this.sailingServiceWrite.getRegattaLog(selectedLeaderboardName, (AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
    }

    private void openRegattaLogDialog(RegattaLogDTO regattaLogDTO) {
        RegattaLogDialog dialog = new RegattaLogDialog(regattaLogDTO, this.stringMessages, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
        dialog.show();
    }

    private void removeTrackedRaceListHandlerTemporarily() {
        if (this.trackedRaceListHandlerRegistration == null) {
            return;
        }
        this.trackedRaceListHandlerRegistration.removeHandler();
        this.trackedRaceListHandlerRegistration = null;
        Scheduler.get().scheduleDeferred(() -> {
            HandlerRegistration handlerRegistration = this.trackedRaceListHandlerRegistration = this.refreshableTrackedRaceSelectionModel.addSelectionChangeHandler(this.trackedRaceListHandler);
        });
    }

    protected RegattaDTO getSelectedRegatta() {
        String regattaName = this.getSelectedLeaderboard() == null ? "" : this.getSelectedLeaderboard().regattaName;
        return this.getRegattaByName(regattaName);
    }

    protected RegattaDTO getRegattaByName(String regattaName) {
        RegattaDTO regatta = null;
        if (regattaName != null && this.allRegattas != null) {
            for (RegattaDTO i : this.allRegattas) {
                if (!regattaName.equals(i.getName())) continue;
                regatta = i;
                break;
            }
        }
        return regatta;
    }

    protected void assignCertificates(RaceColumnDTOAndFleetDTOWithNameBasedEquality object) {
        BoatCertificateAssignmentDialog dialog = new BoatCertificateAssignmentDialog((SailingServiceAsync)this.sailingServiceWrite, this.userService, this.stringMessages, this.errorReporter, (AbstractBoatCertificatesPanel)new RaceBoatCertificatesPanel(this.sailingServiceWrite, this.userService, (StrippedLeaderboardDTO)object.getC(), (RaceColumnDTO)object.getA(), (FleetDTO)object.getB(), this.stringMessages, this.errorReporter));
        dialog.show();
    }

    protected void selectScratchBoat(RaceColumnDTOAndFleetDTOWithNameBasedEquality object) {
        this.sailingServiceWrite.getORCPerformanceCurveScratchBoat(((StrippedLeaderboardDTO)object.getC()).getName(), ((RaceColumnDTO)object.getA()).getName(), ((FleetDTO)object.getB()).getName(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void setImpliedWind(RaceColumnDTOAndFleetDTOWithNameBasedEquality object) {
        String raceDisplayName = String.valueOf(((StrippedLeaderboardDTO)object.getC()).getName()) + "/" + ((RaceColumnDTO)object.getA()).getName() + "/" + ((FleetDTO)object.getB()).getName();
        this.sailingServiceWrite.getImpliedWindSource(((StrippedLeaderboardDTO)object.getC()).getName(), ((RaceColumnDTO)object.getA()).getName(), ((FleetDTO)object.getB()).getName(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected Consumer<AsyncCallback<Iterable<? extends CompetitorDTO>>> getRaceCompetitorProvider(RaceColumnDTOAndFleetDTOWithNameBasedEquality raceSlotIdentifier) {
        return callback -> this.sailingServiceWrite.getCompetitorsAndBoatsOfRace(((StrippedLeaderboardDTO)raceSlotIdentifier.getC()).getName(), ((RaceColumnDTO)raceSlotIdentifier.getA()).getName(), ((FleetDTO)raceSlotIdentifier.getB()).getName(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public AbstractFilterablePanel<StrippedLeaderboardDTO> getFilterablePanel() {
        return this.filterLeaderboardPanel;
    }

    static /* synthetic */ Button access$0(AbstractLeaderboardConfigPanel abstractLeaderboardConfigPanel) {
        return abstractLeaderboardConfigPanel.reloadAllRaceLogs;
    }

    static /* synthetic */ void access$1(AbstractLeaderboardConfigPanel abstractLeaderboardConfigPanel, RaceColumnDTO raceColumnDTO, FleetDTO fleetDTO, RegattaAndRaceIdentifier regattaAndRaceIdentifier) {
        abstractLeaderboardConfigPanel.linkTrackedRaceToSelectedRaceColumn(raceColumnDTO, fleetDTO, regattaAndRaceIdentifier);
    }

    static /* synthetic */ void access$2(AbstractLeaderboardConfigPanel abstractLeaderboardConfigPanel) {
        abstractLeaderboardConfigPanel.removeTrackedRaceListHandlerTemporarily();
    }

    static /* synthetic */ void access$3(AbstractLeaderboardConfigPanel abstractLeaderboardConfigPanel, List list, String string, StrippedLeaderboardDTO strippedLeaderboardDTO) {
        abstractLeaderboardConfigPanel.replaceLeaderboardInList(list, string, strippedLeaderboardDTO);
    }

    static /* synthetic */ void access$4(AbstractLeaderboardConfigPanel abstractLeaderboardConfigPanel, RaceLogDTO raceLogDTO) {
        abstractLeaderboardConfigPanel.openRaceLogDialog(raceLogDTO);
    }

    static /* synthetic */ void access$5(AbstractLeaderboardConfigPanel abstractLeaderboardConfigPanel, RegattaLogDTO regattaLogDTO) {
        abstractLeaderboardConfigPanel.openRegattaLogDialog(regattaLogDTO);
    }
}

