/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.desktop.places.event.regatta;

import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.gwt.settings.client.leaderboard.MultiCompetitorLeaderboardChartSettings;
import com.sap.sailing.gwt.settings.client.leaderboard.MultiRaceLeaderboardSettings;
import com.sap.sailing.gwt.ui.client.CompetitorSelectionModel;
import com.sap.sailing.gwt.ui.client.CompetitorSelectionProvider;
import com.sap.sailing.gwt.ui.client.DebugIdHelper;
import com.sap.sailing.gwt.ui.client.FlagImageResolver;
import com.sap.sailing.gwt.ui.client.SailingClientFactory;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.charts.MultiCompetitorLeaderboardChart;
import com.sap.sailing.gwt.ui.leaderboard.ClassicLeaderboardStyle;
import com.sap.sailing.gwt.ui.leaderboard.LeaderboardPanel;
import com.sap.sailing.gwt.ui.leaderboard.MultiRaceLeaderboardPanel;
import com.sap.sse.common.settings.Settings;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.async.AsyncActionsExecutor;
import com.sap.sse.gwt.client.player.TimeListener;
import com.sap.sse.gwt.client.player.Timer;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.SettingsDialog;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;
import com.sap.sse.security.ui.client.WithSecurity;

public class RegattaAnalyticsDataManager {
    private MultiRaceLeaderboardPanel leaderboardPanel;
    private MultiCompetitorLeaderboardChart multiCompetitorChart;
    private final CompetitorSelectionModel competitorSelectionProvider;
    private final AsyncActionsExecutor asyncActionsExecutor;
    private final ErrorReporter errorReporter;
    private final SailingClientFactory sailingCF;
    private final Timer timer;
    private final FlagImageResolver flagImageResolver;

    public RegattaAnalyticsDataManager(SailingClientFactory sailingCF, AsyncActionsExecutor asyncActionsExecutor, Timer timer, ErrorReporter errorReporter, FlagImageResolver flagImageResolver) {
        this.flagImageResolver = flagImageResolver;
        this.competitorSelectionProvider = new CompetitorSelectionModel(true);
        this.sailingCF = sailingCF;
        this.asyncActionsExecutor = asyncActionsExecutor;
        this.timer = timer;
        this.errorReporter = errorReporter;
        this.leaderboardPanel = null;
        this.multiCompetitorChart = null;
    }

    public MultiRaceLeaderboardPanel createMultiRaceLeaderboardPanel(Component<?> parent, ComponentContext<?> context, MultiRaceLeaderboardSettings leaderboardSettings, String leaderboardGroupName, String leaderboardName, boolean showRaceDetails, boolean autoExpandLastRaceColumn, Iterable<DetailType> availableDetailTypes) {
        if (this.leaderboardPanel == null) {
            SailingServiceAsync sailingService = this.sailingCF.getSailingService(() -> leaderboardName);
            this.leaderboardPanel = new MultiRaceLeaderboardPanel(parent, context, sailingService, this.asyncActionsExecutor, leaderboardSettings, true, (CompetitorSelectionProvider)this.competitorSelectionProvider, this.timer, leaderboardName, this.errorReporter, StringMessages.INSTANCE, showRaceDetails, null, true, null, autoExpandLastRaceColumn, true, false, false, true, (LeaderboardPanel.LeaderBoardStyle)new ClassicLeaderboardStyle(), this.flagImageResolver, availableDetailTypes, (WithSecurity)this.sailingCF);
        }
        return this.leaderboardPanel;
    }

    public MultiCompetitorLeaderboardChart createMultiCompetitorChart(String leaderboardName, DetailType chartDetailType) {
        if (this.multiCompetitorChart == null) {
            SailingServiceAsync sailingService = this.sailingCF.getSailingService(() -> leaderboardName);
            this.multiCompetitorChart = new MultiCompetitorLeaderboardChart(null, null, sailingService, this.asyncActionsExecutor, leaderboardName, chartDetailType, (CompetitorSelectionProvider)this.competitorSelectionProvider, this.timer, StringMessages.INSTANCE, false, this.errorReporter);
            this.multiCompetitorChart.setVisible(false);
        }
        return this.multiCompetitorChart;
    }

    public MultiRaceLeaderboardPanel getLeaderboardPanel() {
        return this.leaderboardPanel;
    }

    public MultiCompetitorLeaderboardChart getMultiCompetitorChart() {
        return this.multiCompetitorChart;
    }

    public CompetitorSelectionModel getCompetitorSelectionProvider() {
        return this.competitorSelectionProvider;
    }

    public void showCompetitorChart(DetailType chartDetailType) {
        MultiCompetitorLeaderboardChart multiCompetitorChart = this.getMultiCompetitorChart();
        MultiCompetitorLeaderboardChartSettings settings = new MultiCompetitorLeaderboardChartSettings(chartDetailType);
        multiCompetitorChart.updateSettings(settings);
        multiCompetitorChart.setVisible(true);
        this.timer.addTimeListener((TimeListener)multiCompetitorChart);
        multiCompetitorChart.clearChart();
        multiCompetitorChart.timeChanged(this.timer.getTime(), null);
    }

    public void hideCompetitorChart() {
        MultiCompetitorLeaderboardChart multiCompetitorChart = this.getMultiCompetitorChart();
        if (multiCompetitorChart != null) {
            multiCompetitorChart.setVisible(false);
            this.timer.removeTimeListener((TimeListener)multiCompetitorChart);
        }
    }

    public void showLeaderboardSettingsDialog() {
        this.showComponentSettingsDialog((Component)this.leaderboardPanel, null);
    }

    public void showChartSettingsDialog() {
        this.showComponentSettingsDialog((Component)this.multiCompetitorChart, null);
    }

    protected <SettingsType extends Settings> void showComponentSettingsDialog(Component<SettingsType> component, String componentDisplayName) {
        String componentName = componentDisplayName != null ? componentDisplayName : component.getLocalizedShortName();
        String debugIdPrefix = DebugIdHelper.createDebugId((String)componentName);
        SettingsDialog dialog = new SettingsDialog(component, (com.sap.sse.gwt.client.StringMessages)StringMessages.INSTANCE);
        dialog.ensureDebugId(String.valueOf(debugIdPrefix) + "SettingsDialog");
        dialog.show();
    }

    public Timer getTimer() {
        return this.timer;
    }
}

