/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.communication.event.statistics;

import com.google.gwt.core.shared.GwtIncompatible;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.gwt.home.communication.event.SimpleCompetitorDTO;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.shared.DTO;

public class EventStatisticsDTO
implements DTO {
    private int regattasFoughtCount;
    private int competitorsCount;
    private int racesRunCount;
    private int trackedRacesCount;
    private long numberOfGPSFixes;
    private long numberOfWindFixes;
    private SimpleCompetitorDTO fastestCompetitor;
    private Double fastestCompetitorSpeedInKnots;
    private Distance totalDistanceTraveled;

    private EventStatisticsDTO() {
    }

    @GwtIncompatible
    public EventStatisticsDTO(int regattasFoughtCount, int competitorsCount, int racesRunCount, int trackedRacesCount, long numberOfGPSFixes, long numberOfWindFixes, Util.Triple<Competitor, Speed, TimePoint> maxSpeed, Distance totalDistanceTraveled) {
        this.regattasFoughtCount = regattasFoughtCount;
        this.competitorsCount = competitorsCount;
        this.racesRunCount = racesRunCount;
        this.trackedRacesCount = trackedRacesCount;
        this.numberOfGPSFixes = numberOfGPSFixes;
        this.numberOfWindFixes = numberOfWindFixes;
        if (maxSpeed != null) {
            this.fastestCompetitor = new SimpleCompetitorDTO((Competitor)maxSpeed.getA());
            this.fastestCompetitorSpeedInKnots = ((Speed)maxSpeed.getB()).getKnots();
        }
        this.totalDistanceTraveled = totalDistanceTraveled;
    }

    public int getRegattasFoughtCount() {
        return this.regattasFoughtCount;
    }

    public void setRegattasFoughtCount(int regattasFoughtCount) {
        this.regattasFoughtCount = regattasFoughtCount;
    }

    public int getCompetitorsCount() {
        return this.competitorsCount;
    }

    public void setCompetitorsCount(int competitorsCount) {
        this.competitorsCount = competitorsCount;
    }

    public int getRacesRunCount() {
        return this.racesRunCount;
    }

    public void setRacesRunCount(int racesRunCount) {
        this.racesRunCount = racesRunCount;
    }

    public int getTrackedRacesCount() {
        return this.trackedRacesCount;
    }

    public void setTrackedRacesCount(int trackedRacesCount) {
        this.trackedRacesCount = trackedRacesCount;
    }

    public long getNumberOfGPSFixes() {
        return this.numberOfGPSFixes;
    }

    public long getNumberOfWindFixes() {
        return this.numberOfWindFixes;
    }

    public SimpleCompetitorDTO getFastestCompetitor() {
        return this.fastestCompetitor;
    }

    public Double getFastestCompetitorSpeedInKnots() {
        return this.fastestCompetitorSpeedInKnots;
    }

    public Distance getTotalDistanceTraveled() {
        return this.totalDistanceTraveled;
    }
}

