/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.communication.event.sixtyinch;

import com.google.gwt.core.shared.GwtIncompatible;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.RegattaNameAndRaceName;
import com.sap.sailing.domain.common.TargetTimeInfo;
import com.sap.sailing.domain.common.polars.NotEnoughDataHasBeenAddedException;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.gwt.common.communication.routing.ProvidesLeaderboardRouting;
import com.sap.sailing.gwt.home.communication.SailingAction;
import com.sap.sailing.gwt.home.communication.SailingDispatchContext;
import com.sap.sailing.gwt.home.communication.event.sixtyinch.GetSixtyInchStatisticDTO;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GetSixtyInchStatisticAction
implements SailingAction<GetSixtyInchStatisticDTO>,
ProvidesLeaderboardRouting {
    private static final Logger LOGGER = Logger.getLogger(GetSixtyInchStatisticAction.class.getName());
    private String racename;
    private String regattaname;

    public GetSixtyInchStatisticAction() {
    }

    public GetSixtyInchStatisticAction(String racename, String regattaname) {
        this.racename = racename;
        this.regattaname = regattaname;
    }

    @GwtIncompatible
    public GetSixtyInchStatisticDTO execute(SailingDispatchContext context) {
        int legs = 0;
        RegattaNameAndRaceName identifier = new RegattaNameAndRaceName(this.regattaname, this.racename);
        RaceDefinition race = context.getRacingEventService().getRace((RegattaAndRaceIdentifier)identifier);
        int competitors = Util.size((Iterable)race.getCompetitors());
        legs = race.getCourse().getLegs().size();
        DynamicTrackedRace trackedRace = context.getRacingEventService().getTrackedRace((RegattaAndRaceIdentifier)identifier);
        Duration duration = null;
        Distance distance = null;
        if (trackedRace.getEndOfRace() == null) {
            TimePoint timePoint = MillisecondsTimePoint.now();
            duration = this.estimateDuration(trackedRace, duration, timePoint);
            distance = this.estimateDistance(trackedRace, distance, timePoint);
        } else {
            Iterator competitorIterator = trackedRace.getCompetitorsFromBestToWorst(trackedRace.getEndOfRace()).iterator();
            if (competitorIterator.hasNext()) {
                distance = trackedRace.getDistanceTraveled((Competitor)competitorIterator.next(), trackedRace.getEndOfRace());
                duration = trackedRace.getStartOfRace().until(trackedRace.getEndOfRace());
            }
        }
        return new GetSixtyInchStatisticDTO(competitors, legs, duration, distance);
    }

    @GwtIncompatible
    private Distance estimateDistance(DynamicTrackedRace trace, Distance distance, TimePoint timePoint) {
        try {
            TargetTimeInfo timeToComplete = trace.getEstimatedTimeToComplete(timePoint);
            distance = timeToComplete.getExpectedDistance();
        }
        catch (NoWindException | NotEnoughDataHasBeenAddedException e) {
            LOGGER.log(Level.WARNING, "Could not estimate Distance", e);
        }
        return distance;
    }

    @GwtIncompatible
    private Duration estimateDuration(DynamicTrackedRace trace, Duration duration, TimePoint timePoint) {
        try {
            TargetTimeInfo timeToComplete = trace.getEstimatedTimeToComplete(timePoint);
            duration = timeToComplete.getExpectedDuration();
        }
        catch (NoWindException | NotEnoughDataHasBeenAddedException e) {
            LOGGER.log(Level.WARNING, "Could not estimate duration", e);
        }
        return duration;
    }

    public String getLeaderboardName() {
        return this.regattaname;
    }
}

