/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbcext;

import com.sap.db.annotations.Immutable;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.xa.XAException;

@Immutable
public final class XAExceptionSAP
extends XAException {
    private static final Map<Integer, Integer> ERROR_CODE_MAP = new HashMap<Integer, Integer>();
    private final String _message;

    public XAExceptionSAP(SQLException e) {
        super(XAExceptionSAP._getXAErrorCode(e.getErrorCode()));
        this._message = e.getMessage();
    }

    public XAExceptionSAP(int errorCode, String message) {
        super(errorCode);
        this._message = message;
    }

    @Override
    public String getMessage() {
        return this._message;
    }

    private static int _getXAErrorCode(int sqlErrorCode) {
        Integer xaErrorCode = ERROR_CODE_MAP.get(sqlErrorCode);
        return xaErrorCode != null ? xaErrorCode : 0;
    }

    static {
        ERROR_CODE_MAP.put(209, -2);
        ERROR_CODE_MAP.put(210, -8);
        ERROR_CODE_MAP.put(211, -5);
        ERROR_CODE_MAP.put(212, -4);
        ERROR_CODE_MAP.put(213, -9);
        ERROR_CODE_MAP.put(214, -6);
        ERROR_CODE_MAP.put(215, -3);
        ERROR_CODE_MAP.put(216, -7);
    }
}

