/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.aiagent.persistence.impl;

import com.sap.sailing.aiagent.interfaces.AIAgent;
import com.sap.sailing.aiagent.interfaces.AIAgentListener;
import com.sap.sailing.aiagent.persistence.DomainObjectFactory;
import com.sap.sailing.aiagent.persistence.MongoObjectFactory;
import com.sap.sailing.aiagent.persistence.PersistenceFactory;
import com.sap.sailing.aiagent.persistence.impl.CollectionNames;
import com.sap.sailing.domain.base.Event;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sse.aicore.Credentials;
import com.sap.sse.common.Duration;
import com.sap.sse.mongodb.MongoDBService;
import com.sap.sse.util.ServiceTrackerFactory;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static final Logger logger = Logger.getLogger(Activator.class.getName());
    private static final Duration TIMEOUT_WAITING_FOR_AI_AGENT = Duration.ONE_MINUTE.times(5L);
    private static BundleContext context;

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        CollectionNames[] collectionNamesArray = CollectionNames.values();
        int n = collectionNamesArray.length;
        int n2 = 0;
        while (n2 < n) {
            CollectionNames name = collectionNamesArray[n2];
            MongoDBService.INSTANCE.registerExclusively(CollectionNames.class, name.name());
            ++n2;
        }
        new Thread(() -> {
            ServiceTracker racingEventServiceTracker = ServiceTrackerFactory.createAndOpen((BundleContext)bundleContext, RacingEventService.class);
            ServiceTracker aiAgentTracker = ServiceTrackerFactory.createAndOpen((BundleContext)bundleContext, AIAgent.class);
            try {
                AIAgent aiAgent = (AIAgent)aiAgentTracker.waitForService(TIMEOUT_WAITING_FOR_AI_AGENT.asMillis());
                if (aiAgent != null) {
                    RacingEventService racingEventService = (RacingEventService)racingEventServiceTracker.waitForService(0L);
                    logger.info("Found service " + aiAgent + "; initializing it from the persistent configuration data");
                    aiAgent.stopCommentingOnAllEvents();
                    DomainObjectFactory dof = PersistenceFactory.INSTANCE.getDefaultDomainObjectFactory();
                    final MongoObjectFactory mof = PersistenceFactory.INSTANCE.getDefaultMongoObjectFactory();
                    Credentials credentials = dof.getCredentials(null);
                    if (credentials != null) {
                        logger.info("Found AI Core credentials in persistent store; applying to AI Agent");
                        aiAgent.setCredentials(credentials);
                    }
                    for (Event eventToCommentOn : racingEventService.getEventsSelectively(true, dof.getEventsToComment(null))) {
                        aiAgent.startCommentingOnEvent(eventToCommentOn);
                    }
                    aiAgent.addListener(new AIAgentListener(){

                        public void stoppedCommentingOnEvent(Event e) {
                            mof.removeEventToComment(e.getId(), null);
                        }

                        public void startedCommentingOnEvent(Event e) {
                            mof.addEventToComment(e.getId(), null);
                        }

                        public void credentialsUpdated(Credentials credentials) {
                            mof.updateCredentials(credentials, null);
                        }
                    });
                } else {
                    logger.warning("Waiting for AI Agent to show up in OSGi registry timed out after " + TIMEOUT_WAITING_FOR_AI_AGENT);
                }
            }
            catch (InterruptedException e) {
                logger.severe("Got interrupted while waiting for AIAgent service");
                throw new RuntimeException(e);
            }
        }, "Waiting for AIAgent to show up in OSGi registry").start();
        context = bundleContext;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        context = null;
    }
}

