/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.server;

import com.google.gwt.user.client.rpc.IncompatibleRemoteServiceException;
import com.google.gwt.user.client.rpc.RpcTokenException;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.RPC;
import com.google.gwt.user.server.rpc.RPCRequest;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.sap.sse.common.TimePoint;
import com.sap.sse.gwt.server.ProxiedRemoteServiceServlet;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class DelegatingProxiedRemoteServiceServlet
extends ProxiedRemoteServiceServlet {
    private static final Logger logger = Logger.getLogger(DelegatingProxiedRemoteServiceServlet.class.getName());
    private static final long serialVersionUID = -5543378343472849437L;

    @Override
    public String processCall(RPCRequest rpcRequest) throws SerializationException {
        TimePoint startOfProcessCall = this.beforeProcessCall();
        try {
            DelegatingProxiedRemoteServiceServlet delegate = this;
            try {
                this.onAfterRequestDeserialized(rpcRequest);
                return this.invokeAndEncodeResponse((Object)delegate, rpcRequest.getMethod(), rpcRequest.getParameters(), rpcRequest.getSerializationPolicy(), rpcRequest.getFlags(), rpcRequest, startOfProcessCall);
            }
            catch (IncompatibleRemoteServiceException ex) {
                this.afterProcessCall(rpcRequest, startOfProcessCall);
                this.log("An IncompatibleRemoteServiceException was thrown while processing this call.", ex);
                return RPC.encodeResponseForFailedRequest((RPCRequest)rpcRequest, (Throwable)ex);
            }
            catch (RpcTokenException tokenException) {
                this.afterProcessCall(rpcRequest, startOfProcessCall);
                this.log("An RpcTokenException was thrown while processing this call.", tokenException);
                return RPC.encodeResponseForFailedRequest((RPCRequest)rpcRequest, (Throwable)tokenException);
            }
        }
        catch (Throwable e) {
            this.afterProcessCall(rpcRequest, startOfProcessCall);
            throw e;
        }
    }

    private String invokeAndEncodeResponse(Object target, Method serviceMethod, Object[] args, SerializationPolicy serializationPolicy, int flags, RPCRequest rpcRequest, TimePoint startOfProcessCall) throws SerializationException {
        if (serviceMethod == null) {
            throw new NullPointerException("serviceMethod");
        }
        if (serializationPolicy == null) {
            throw new NullPointerException("serializationPolicy");
        }
        try {
            Object result = serviceMethod.invoke(target, args);
            this.afterProcessCall(rpcRequest, startOfProcessCall);
            return this.encodeResponseForSuccess(serviceMethod, serializationPolicy, flags, result);
        }
        catch (IllegalAccessException e) {
            SecurityException securityException = new SecurityException(this.formatIllegalAccessErrorMessage(target, serviceMethod));
            securityException.initCause(e);
            throw securityException;
        }
        catch (IllegalArgumentException e) {
            SecurityException securityException = new SecurityException(this.formatIllegalArgumentErrorMessage(target, serviceMethod, args));
            securityException.initCause(e);
            throw securityException;
        }
        catch (InvocationTargetException e) {
            this.afterProcessCall(rpcRequest, startOfProcessCall);
            Throwable cause = this.resolveCause(e);
            logger.log(Level.SEVERE, "Uncaught exception, forwarded to client", cause);
            try {
                return RPC.encodeResponseForFailure((Method)serviceMethod, (Throwable)cause, (SerializationPolicy)serializationPolicy, (int)flags);
            }
            catch (SerializationException se) {
                logger.warning("Couldn't serialize exception of type " + cause.getClass() + "; serializing a RuntimeException with the message \"" + cause.getMessage() + "\" only.");
                return RPC.encodeResponseForFailure((Method)serviceMethod, (Throwable)new RuntimeException(cause.getMessage()), (SerializationPolicy)serializationPolicy, (int)flags);
            }
        }
    }

    private Throwable resolveCause(InvocationTargetException e) {
        Throwable result = e;
        while (((Throwable)result).getCause() != null && ((Throwable)result).getCause() != result) {
            result = ((Throwable)result).getCause();
        }
        return result;
    }

    protected String encodeResponseForSuccess(Method serviceMethod, SerializationPolicy serializationPolicy, int flags, Object result) throws SerializationException {
        return RPC.encodeResponseForSuccess((Method)serviceMethod, (Object)result, (SerializationPolicy)serializationPolicy, (int)flags);
    }

    private String formatIllegalAccessErrorMessage(Object target, Method serviceMethod) {
        StringBuffer sb = new StringBuffer();
        sb.append("Blocked attempt to access inaccessible method '");
        sb.append(this.getSourceRepresentation(serviceMethod));
        sb.append("'");
        if (target != null) {
            sb.append(" on target '");
            sb.append(this.printTypeName(target.getClass()));
            sb.append("'");
        }
        sb.append("; this is either misconfiguration or a hack attempt");
        return sb.toString();
    }

    private String formatIllegalArgumentErrorMessage(Object target, Method serviceMethod, Object[] args) {
        StringBuffer sb = new StringBuffer();
        sb.append("Blocked attempt to invoke method '");
        sb.append(this.getSourceRepresentation(serviceMethod));
        sb.append("'");
        if (target != null) {
            sb.append(" on target '");
            sb.append(this.printTypeName(target.getClass()));
            sb.append("'");
        }
        sb.append(" with invalid arguments");
        if (args != null && args.length > 0) {
            sb.append(Arrays.asList(args));
        }
        return sb.toString();
    }

    private String getSourceRepresentation(Method method) {
        return method.toString().replace('$', '.');
    }

    private String printTypeName(Class<?> type) {
        if (type.equals(Integer.TYPE)) {
            return "int";
        }
        if (type.equals(Long.TYPE)) {
            return "long";
        }
        if (type.equals(Short.TYPE)) {
            return "short";
        }
        if (type.equals(Byte.TYPE)) {
            return "byte";
        }
        if (type.equals(Character.TYPE)) {
            return "char";
        }
        if (type.equals(Boolean.TYPE)) {
            return "boolean";
        }
        if (type.equals(Float.TYPE)) {
            return "float";
        }
        if (type.equals(Double.TYPE)) {
            return "double";
        }
        if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            return String.valueOf(this.printTypeName(componentType)) + "[]";
        }
        return type.getName().replace('$', '.');
    }
}

