/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.sapheader;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.gwt.client.StringMessages;
import com.sap.sse.gwt.client.sapheader.BrandedHeaderResources;
import com.sap.sse.gwt.shared.ClientConfiguration;

public class BrandedSailingHeader
extends Composite {
    private static final StringMessages stringMessages = (StringMessages)GWT.create(StringMessages.class);
    private static final String LOGO_URL = stringMessages.sapAnalyticsURL();
    private static SailingHeaderUiBinder uiBinder = (SailingHeaderUiBinder)GWT.create(SailingHeaderUiBinder.class);
    @UiField
    AnchorElement applicationNameAnchor;
    @UiField
    DivElement pageTitleUi;
    @UiField
    DivElement titleUi;
    @UiField
    DivElement subTitleUi;
    @UiField
    SimplePanel rightSideUi;
    @UiField
    AnchorElement logoAnchor;

    public BrandedSailingHeader(String applicationName, String applicationBaseUrl) {
        BrandedHeaderResources.INSTANCE.css().ensureInjected();
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.applicationNameAnchor.setInnerText(applicationName != null ? applicationName : "&nbsp;");
        this.logoAnchor.setHref(LOGO_URL);
        String sapSailingUrl = String.valueOf(applicationBaseUrl) + "?locale=" + LocaleInfo.getCurrentLocale().getLocaleName();
        this.applicationNameAnchor.setHref(sapSailingUrl);
        if (!ClientConfiguration.getInstance().isBrandingActive()) {
            this.logoAnchor.getStyle().setDisplay(Style.Display.NONE);
            this.applicationNameAnchor.setHref("");
        }
        this.logoAnchor.setAttribute("selenium-id", "logoAnchor");
        this.applicationNameAnchor.setAttribute("gwt-debug-", "applicationNameAnchor");
    }

    public void setHeaderTitle(String title) {
        this.titleUi.setInnerText(title);
    }

    public void setHeaderSubTitle(String subtitle) {
        if (subtitle == null || subtitle.isEmpty()) {
            this.subTitleUi.getStyle().setDisplay(Style.Display.NONE);
            this.titleUi.getStyle().setMarginTop(14.0, Style.Unit.PX);
        } else {
            this.subTitleUi.setInnerText(subtitle);
            this.subTitleUi.getStyle().clearDisplay();
            this.titleUi.getStyle().clearMarginTop();
        }
    }

    public void addWidgetToRightSide(Widget widget) {
        this.rightSideUi.add(widget);
    }

    static interface SailingHeaderUiBinder
    extends UiBinder<Widget, BrandedSailingHeader> {
    }
}

