/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.panels;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.user.cellview.client.AbstractCellTable;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SingleSelectionModel;
import com.sap.sse.common.Util;
import com.sap.sse.common.filter.AbstractKeywordFilter;
import com.sap.sse.common.filter.Filter;
import com.sap.sse.gwt.client.StringMessages;
import com.sap.sse.gwt.client.panels.FilterAndSelectParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

public abstract class AbstractFilterablePanel<T>
extends HorizontalPanel {
    protected ListDataProvider<T> all;
    protected final ListDataProvider<T> filtered;
    protected final TextBox textBox;
    protected final CheckBox showOnlyObjectsWithUpdatePermissionCheckBox;
    private final Set<Filter<T>> filters = new HashSet<Filter<T>>();
    private final CheckboxEnablableFilter<T> checkboxFilterForUpdatableObjectsOnly;
    private boolean showOnlyObjectsWithUpdatePermissionCheckBoxAdded = false;
    private List<String> select;
    private String selectExact;
    private boolean executeSelectOnRefresh;
    private boolean executeSelect;
    protected final AbstractKeywordFilter<T> filterer = new AbstractKeywordFilter<T>(){

        public Iterable<String> getStrings(T t) {
            return AbstractFilterablePanel.this.getSearchableStrings(t);
        }
    };
    protected final AbstractKeywordFilter<T> selectionFilter = new AbstractKeywordFilter<T>(){

        public Iterable<String> getStrings(T t) {
            return AbstractFilterablePanel.this.getSearchableStrings(t);
        }
    };

    public AbstractFilterablePanel(Iterable<T> all, ListDataProvider<T> filtered, boolean drawTextBox, StringMessages stringMessages, boolean executeSelectOnRefresh, String filterCheckboxLabel) {
        this.executeSelectOnRefresh = executeSelectOnRefresh;
        this.filters.add((Filter<T>)this.filterer);
        this.setSpacing(5);
        this.all = new ListDataProvider();
        this.filtered = filtered;
        this.textBox = new TextBox();
        this.textBox.ensureDebugId("FilterTextBox");
        this.showOnlyObjectsWithUpdatePermissionCheckBox = new CheckBox(filterCheckboxLabel);
        this.showOnlyObjectsWithUpdatePermissionCheckBox.setValue(Boolean.valueOf(true));
        this.checkboxFilterForUpdatableObjectsOnly = new CheckboxEnablableFilter(this.showOnlyObjectsWithUpdatePermissionCheckBox);
        this.filters.add(this.checkboxFilterForUpdatableObjectsOnly);
        this.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        this.setAll(all);
        if (drawTextBox) {
            this.addDefaultTextBox();
        }
    }

    public AbstractFilterablePanel(Iterable<T> all, ListDataProvider<T> filtered, boolean drawTextBox, StringMessages stringMessages, boolean executeSelectOnRefresh) {
        this(all, filtered, drawTextBox, stringMessages, executeSelectOnRefresh, stringMessages.hideElementsWithoutUpdateRights());
    }

    public AbstractFilterablePanel(Iterable<T> all, ListDataProvider<T> filtered, boolean drawTextBox, StringMessages stringMessages) {
        this(all, filtered, drawTextBox, stringMessages, true);
    }

    public AbstractFilterablePanel(Iterable<T> all, ListDataProvider<T> filtered, StringMessages stringMessages) {
        this(all, filtered, stringMessages, true);
    }

    public AbstractFilterablePanel(Iterable<T> all, ListDataProvider<T> filtered, StringMessages stringMessages, boolean selectOnRefresh) {
        this(all, filtered, true, stringMessages, selectOnRefresh);
    }

    public AbstractFilterablePanel(Iterable<T> all, ListDataProvider<T> filtered, StringMessages stringMessages, String filterCheckboxLabel) {
        this(all, filtered, true, stringMessages, true, filterCheckboxLabel);
    }

    private void setAll(Iterable<? extends T> all) {
        this.all.getList().clear();
        if (all != null) {
            for (T t : all) {
                this.all.getList().add(t);
            }
        }
    }

    public void addFilter(Filter<T> filterToAdd) {
        this.filters.add(filterToAdd);
    }

    private void setKeywordsFilterSplitValue(String value) {
        this.filterer.setKeywords(Util.splitAlongWhitespaceRespectingDoubleQuotedPhrases((String)value));
    }

    private void resetKeywordsFilterSplitValue() {
        this.setKeywordsFilterSplitValue(this.getTextBox().getValue());
    }

    public abstract Iterable<String> getSearchableStrings(T var1);

    public void updateAll(Iterable<? extends T> all) {
        this.setAll(all);
        this.filter();
        if (this.executeSelectOnRefresh && this.executeSelect) {
            this.select();
        }
    }

    private boolean isSelectParameterSet() {
        return this.selectExact != null || this.select != null && !this.select.isEmpty();
    }

    public void add(T object) {
        this.all.getList().add(object);
        this.filter();
    }

    public void add(int index, T object) {
        this.all.getList().add(index, object);
        this.filter();
    }

    public int indexOf(T object) {
        return this.all.getList().indexOf(object);
    }

    public void remove(T object) {
        this.all.getList().remove(object);
        this.filter();
    }

    public void addAll(Iterable<T> objects) {
        Util.addAll(objects, (Collection)this.all.getList());
        this.filter();
    }

    public void removeAll() {
        this.all.getList().clear();
        this.filter();
    }

    public void removeAll(Iterable<T> objects) {
        Util.removeAll(objects, (Collection)this.all.getList());
        this.filter();
    }

    public void filter() {
        this.filtered.getList().clear();
        this.retainElementsInFilteredThatPassFilter();
        Scheduler.get().scheduleFinally(() -> {
            this.filtered.flush();
            this.sort();
        });
    }

    public void filterAndSelect(FilterAndSelectParameters filterParameters) {
        if (filterParameters.isAnyParameterSet()) {
            if (filterParameters.getFilterString() != null) {
                this.search(filterParameters.getFilterString());
            }
            if (!this.executeSelectOnRefresh) {
                this.select(filterParameters.getSelectList(), filterParameters.getSelectExact());
            } else {
                this.setSelectParameters(filterParameters);
            }
        }
    }

    public abstract AbstractCellTable<T> getCellTable();

    protected void retainElementsInFilteredThatPassFilter() {
        ArrayList filteredElements = new ArrayList();
        for (Object t : this.all.getList()) {
            if (!this.matches(t)) continue;
            filteredElements.add(t);
        }
        Util.addAll(filteredElements, (Collection)this.filtered.getList());
    }

    private void select() {
        this.select(this.select, this.selectExact);
    }

    private void select(List<String> selections, String selectExact) {
        if (!this.isSelectParameterSet()) {
            this.deselectAll();
        } else if (this.isSingleSelect()) {
            this.selectSingle(selections, selectExact);
        } else {
            this.selectMultiple(selections, selectExact);
        }
        this.resetSelectParameters();
    }

    private void deselectAll() {
        for (Object t : this.all.getList()) {
            this.select(t, false);
        }
    }

    private void setSelectParameters(FilterAndSelectParameters filterParameters) {
        this.selectExact = filterParameters.getSelectExact();
        this.select = filterParameters.getSelectList();
        this.executeSelect = true;
    }

    private void resetSelectParameters() {
        if (this.select != null) {
            this.select.clear();
        }
        this.selectExact = null;
        this.executeSelect = false;
    }

    private boolean isSingleSelect() {
        return this.filtered.getDataDisplays().stream().allMatch(dataDisplay -> dataDisplay.getSelectionModel() instanceof SingleSelectionModel);
    }

    private void selectMultiple(List<String> selections, String selectExact) {
        this.selectionFilter.setKeywords(selectExact == null ? new ArrayList() : Arrays.asList(selectExact));
        for (Object t : this.all.getList()) {
            boolean matchFound = false;
            for (String selection : selections) {
                this.setKeywordsFilterSplitValue(selection);
                matchFound = this.matches(t);
                if (matchFound) break;
            }
            if (selectExact != null) {
                matchFound = matchFound || this.matchesExactly(t);
            }
            this.select(t, matchFound);
        }
        this.resetKeywordsFilterSplitValue();
    }

    private void selectSingle(List<String> selections, String selectExact) {
        boolean selected = this.singleSelectExact(selectExact);
        if (!selected) {
            try {
                for (Object t : this.all.getList()) {
                    for (String selection : selections) {
                        this.setKeywordsFilterSplitValue(selection);
                        if (!this.matches(t)) continue;
                        this.select(t);
                        return;
                    }
                }
            }
            finally {
                this.resetKeywordsFilterSplitValue();
            }
        }
    }

    private void select(T item) {
        this.select(item, true);
    }

    private void select(T item, boolean select) {
        this.getCellTable().getSelectionModel().setSelected(item, select);
    }

    private boolean singleSelectExact(String selectExact) {
        boolean result;
        if (selectExact == null) {
            result = false;
        } else {
            this.selectionFilter.setKeywords(Arrays.asList(selectExact));
            boolean found = false;
            for (Object t : this.all.getList()) {
                if (!this.matchesExactly(t)) continue;
                this.select(t);
                found = true;
                break;
            }
            result = found;
        }
        return result;
    }

    private boolean matchesExactly(T t) {
        return this.selectionFilter.matchesExactly(t);
    }

    private boolean matches(T t) {
        for (Filter<T> filter : this.filters) {
            if (filter.matches(t)) continue;
            return false;
        }
        return true;
    }

    protected void sort() {
        if (this.getCellTable() != null) {
            ColumnSortEvent.fire(this.getCellTable(), (ColumnSortList)this.getCellTable().getColumnSortList());
        }
    }

    public void addDefaultTextBox() {
        this.add(this.getTextBox());
        this.getTextBox().addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                AbstractFilterablePanel.this.resetKeywordsFilterSplitValue();
                AbstractFilterablePanel.this.filter();
            }
        });
    }

    public void addShowOnlyObjectsWithUpdatePermissionCheckBoxIfNecessary() {
        if (!this.showOnlyObjectsWithUpdatePermissionCheckBoxAdded) {
            this.add(this.getShowOnlyObjectsWithUpdatePermissionCheckBox());
            this.getShowOnlyObjectsWithUpdatePermissionCheckBox().addClickHandler(e -> this.filter());
            this.showOnlyObjectsWithUpdatePermissionCheckBoxAdded = true;
        }
    }

    public void search(String searchString) {
        this.getTextBox().setText(searchString);
        this.setKeywordsFilterSplitValue(searchString);
        this.filter();
    }

    public TextBox getTextBox() {
        return this.textBox;
    }

    public CheckBox getShowOnlyObjectsWithUpdatePermissionCheckBox() {
        return this.showOnlyObjectsWithUpdatePermissionCheckBox;
    }

    public void setUpdatePermissionFilterForCheckbox(final Function<T, Boolean> filterFunction) {
        this.checkboxFilterForUpdatableObjectsOnly.setFilterToApply(new Filter<T>(){

            public boolean matches(T object) {
                return (Boolean)filterFunction.apply(object);
            }

            public String getName() {
                return "Update Permission Filter";
            }
        });
        this.addShowOnlyObjectsWithUpdatePermissionCheckBoxIfNecessary();
    }

    public Iterable<T> getAll() {
        return this.all.getList();
    }

    public ListDataProvider<T> getAllListDataProvider() {
        return this.all;
    }

    static class CheckboxEnablableFilter<T>
    implements Filter<T> {
        private final CheckBox checkbox;
        private Filter<T> filterToApply;

        public CheckboxEnablableFilter(CheckBox checkbox) {
            this.checkbox = checkbox;
        }

        public boolean matches(T object) {
            boolean result = this.filterToApply == null ? true : (this.checkbox.getValue() == false ? true : this.filterToApply.matches(object));
            return result;
        }

        public String getName() {
            return this.filterToApply.getName();
        }

        public void setFilterToApply(Filter<T> filterToApply) {
            this.filterToApply = filterToApply;
        }
    }
}

