/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.application.impl;

import com.sap.sse.common.Util;
import com.sap.sse.common.impl.NamedImpl;
import com.sap.sse.landscape.Release;
import com.sap.sse.landscape.application.ApplicationProcess;
import com.sap.sse.landscape.application.ApplicationProcessMetrics;
import com.sap.sse.landscape.application.ApplicationReplicaSet;
import com.sap.sse.landscape.application.Scope;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public class ApplicationReplicaSetImpl<ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>>
extends NamedImpl
implements ApplicationReplicaSet<ShardingKey, MetricsT, ProcessT> {
    private static final long serialVersionUID = -4107033961273165726L;
    private ProcessT master;
    private Set<ProcessT> replicas;
    private CompletableFuture<String> hostname = new CompletableFuture();

    public ApplicationReplicaSetImpl(String replicaSetAndServerName, String hostname, ProcessT master, Optional<Iterable<ProcessT>> replicas) {
        super(replicaSetAndServerName);
        if (hostname != null) {
            this.hostname.complete(hostname);
        }
        this.master = master;
        this.replicas = new HashSet<ProcessT>();
        replicas.ifPresent(theReplicas -> {
            Collection collection = Util.addAll((Iterable)theReplicas, this.replicas);
        });
    }

    public ApplicationReplicaSetImpl(String replicaSetAndServerName, ProcessT master, Optional<Iterable<ProcessT>> replicas) {
        this(replicaSetAndServerName, null, master, replicas);
    }

    @Override
    public String getHostname() throws InterruptedException, ExecutionException {
        return this.hostname.get();
    }

    protected void setHostname(String hostname) {
        this.hostname.complete(hostname);
    }

    @Override
    public void upgrade(Release newVersion) {
    }

    @Override
    public ProcessT getMaster() {
        return this.master;
    }

    @Override
    public Iterable<ProcessT> getReplicas() {
        return Collections.unmodifiableSet(this.replicas);
    }

    @Override
    public Iterable<Scope<ShardingKey>> getScopes() {
        return null;
    }

    @Override
    public void importScope(ApplicationReplicaSet<ShardingKey, MetricsT, ProcessT> source, Scope<ShardingKey> scopeToImport, boolean failUponDiff, boolean removeFromSourceUponSuccess, boolean setRemoveReferenceInSourceUponSuccess) {
    }

    @Override
    public void removeScope(Scope<ShardingKey> scope) {
    }

    @Override
    public void setReadFromMaster(boolean readFromMaster) throws IllegalStateException {
    }

    @Override
    public boolean isReadFromMaster() {
        return false;
    }
}

