/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.sailti.resultimport;

import com.sap.sailing.sailti.resultimport.EventResultDescriptor;
import com.sap.sailing.sailti.resultimport.RegattaResultDescriptor;
import com.sap.sailing.sailti.resultimport.SailtiEventResultsParser;
import com.sap.sailing.xrr.resultimport.ParserFactory;
import com.sap.sailing.xrr.schema.Event;
import com.sap.sailing.xrr.schema.RegattaResults;
import com.sap.sse.common.TimePoint;
import com.sap.sse.util.HttpUrlConnectionHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SailtiEventResultsParserImpl
implements SailtiEventResultsParser {
    private static final Logger logger = Logger.getLogger(SailtiEventResultsParserImpl.class.getName());
    static final Pattern eventNamePattern = Pattern.compile("<h2>([^<]*)</h2>");
    static final Pattern xrrFileNamePattern = Pattern.compile("XML-([^_]*)_([0-9][0-9]*)_([0-9][0-9]*)_([0-9]*).xml");
    static final Pattern classAndXrrLinkPattern = Pattern.compile("<p>([^<]*)<br/>\\s*<a *href=\"(([^\"]*)" + xrrFileNamePattern + ")\"\\s*>");
    private final URL baseUrl;

    public SailtiEventResultsParserImpl(URL baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Override
    public EventResultDescriptor getEventResult(InputStream is) throws IOException {
        EventResultDescriptor result = null;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));){
                String eventName;
                String line;
                ArrayList<RegattaResultDescriptor> regattaResults = new ArrayList<RegattaResultDescriptor>();
                StringBuilder eventHtml = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    eventHtml.append(line);
                }
                String eventHtmlAsString = eventHtml.toString();
                Matcher matcher = classAndXrrLinkPattern.matcher(eventHtmlAsString);
                while (matcher.find()) {
                    regattaResults.add(new RegattaResultDescriptor(String.valueOf(matcher.group(1)) + "/" + matcher.group(5) + "/" + matcher.group(6), matcher.group(1), this.getBoatClassName(matcher), new URL(this.baseUrl, this.getAbsoluteXrrUrlPath(matcher)), this.getTimePoint(matcher)));
                }
                Matcher eventNameMatcher = eventNamePattern.matcher(eventHtmlAsString);
                if (eventNameMatcher.find()) {
                    eventName = eventNameMatcher.group(1);
                } else if (regattaResults.isEmpty()) {
                    eventName = this.getEventId();
                } else {
                    URL xrrFinalUrl = ((RegattaResultDescriptor)((Object)regattaResults.iterator().next())).getXrrFinalUrl();
                    RegattaResults anyXrr = null;
                    try {
                        anyXrr = ParserFactory.INSTANCE.createParser(HttpUrlConnectionHelper.redirectConnection((URL)xrrFinalUrl).getInputStream(), xrrFinalUrl.toString()).parse();
                    }
                    catch (Exception e) {
                        logger.warning("Couldn't read XRR document from " + xrrFinalUrl + " to obtain event name; using event ID " + this.getEventId() + " instead");
                    }
                    eventName = anyXrr == null ? this.getEventId() : anyXrr.getPersonOrBoatOrTeam().stream().filter(o -> o instanceof Event).findAny().map(o -> ((Event)o).getTitle()).get();
                }
                result = new EventResultDescriptor(this.getEventId(), eventName, regattaResults);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Problem parsing Sailti event document", e);
        }
        return result;
    }

    private String getEventId() {
        return this.baseUrl.getPath().substring(this.baseUrl.getPath().lastIndexOf(47) + 1);
    }

    private String getAbsoluteXrrUrlPath(Matcher matcher) {
        return matcher.group(2);
    }

    String getBoatClassName(Matcher matcher) {
        return matcher.group(1);
    }

    TimePoint getTimePoint(Matcher matcher) throws ParseException {
        return TimePoint.of((Date)new SimpleDateFormat("yyyyMMddhhmmssX").parse(String.valueOf(matcher.group(7)) + "Z"));
    }
}

