/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.igtimiadapter.impl;

import com.google.protobuf.InvalidProtocolBufferException;
import com.igtimi.IgtimiStream;
import com.sap.sailing.declination.DeclinationService;
import com.sap.sailing.domain.igtimiadapter.BulkFixReceiver;
import com.sap.sailing.domain.igtimiadapter.DataAccessWindow;
import com.sap.sailing.domain.igtimiadapter.Device;
import com.sap.sailing.domain.igtimiadapter.FixFactory;
import com.sap.sailing.domain.igtimiadapter.IgtimiConnection;
import com.sap.sailing.domain.igtimiadapter.LiveDataConnection;
import com.sap.sailing.domain.igtimiadapter.Permission;
import com.sap.sailing.domain.igtimiadapter.datatypes.Fix;
import com.sap.sailing.domain.igtimiadapter.datatypes.Type;
import com.sap.sailing.domain.igtimiadapter.impl.Activator;
import com.sap.sailing.domain.igtimiadapter.impl.DataAccessWindowDeserializer;
import com.sap.sailing.domain.igtimiadapter.impl.DataAccessWindowSerializer;
import com.sap.sailing.domain.igtimiadapter.impl.DeviceDeserializer;
import com.sap.sailing.domain.igtimiadapter.impl.IgtimiWindTracker;
import com.sap.sailing.domain.igtimiadapter.impl.WindListenerSendingToTrackedRace;
import com.sap.sailing.domain.igtimiadapter.shared.IgtimiWindReceiver;
import com.sap.sailing.domain.igtimiadapter.websocket.LiveDataConnectionFactory;
import com.sap.sailing.domain.igtimiadapter.websocket.LiveDataConnectionFactoryImpl;
import com.sap.sailing.domain.tracking.DynamicTrack;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.impl.DynamicTrackImpl;
import com.sap.sse.common.Duration;
import com.sap.sse.common.HttpRequestHeaderConstants;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Timed;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.security.util.impl.SecuredServerImpl;
import com.sun.jersey.core.util.Base64;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;

public class IgtimiConnectionImpl
extends SecuredServerImpl
implements IgtimiConnection {
    private static final Logger logger = Logger.getLogger(IgtimiConnectionImpl.class.getName());
    private static final String REASON = "reason";
    private static final String ERROR = "error";
    private final LiveDataConnectionFactory liveDataConnectionFactory = new LiveDataConnectionFactoryImpl(this);

    public IgtimiConnectionImpl(URL baseUrl, String bearerToken) {
        super(baseUrl, bearerToken);
    }

    @Override
    public Iterable<Fix> getLatestFixes(Iterable<String> deviceSerialNumbers, Type type) throws IllegalStateException, ClientProtocolException, IOException, ParseException {
        HttpGet getLatestData = new HttpGet(this.getLatestDatumUrl(deviceSerialNumbers, type));
        JSONObject latestDataJson = (JSONObject)this.getJsonParsedResponse((HttpUriRequest)getLatestData).getA();
        return new FixFactory().createFixes(latestDataJson);
    }

    @Override
    public IgtimiStream.Msg getLastMessage(String serialNumber, Type type) throws ClientProtocolException, IOException, ParseException {
        HttpGet getLatestData = new HttpGet(this.getLatestDatumUrl(Collections.singleton(serialNumber), type));
        JSONObject latestDataJson = (JSONObject)this.getJsonParsedResponse((HttpUriRequest)getLatestData).getA();
        JSONArray messages = (JSONArray)latestDataJson.get((Object)serialNumber);
        IgtimiStream.Msg result = messages == null || messages.isEmpty() ? null : IgtimiStream.Msg.parseFrom(Base64.decode((String)((String)messages.get(0))));
        return result;
    }

    @Override
    public Iterable<Fix> getResourceData(TimePoint startTime, TimePoint endTime, Iterable<String> deviceSerialNumbers, Map<Type, Double> typeAndCompression) throws IllegalStateException, ClientProtocolException, IOException, ParseException {
        return this.getResourceContent(startTime, endTime, deviceSerialNumbers, typeAndCompression, resourceDataJson -> {
            try {
                return new FixFactory().createFixes((JSONObject)resourceDataJson);
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private <T> Iterable<T> getResourceContent(TimePoint startTime, TimePoint endTime, Iterable<String> deviceSerialNumbers, Map<Type, Double> typeAndCompression, Function<JSONObject, Iterable<T>> messageParser) throws IllegalStateException, ClientProtocolException, IOException, ParseException {
        logger.info("Requested resource data from " + startTime + " to " + endTime + " for devices " + deviceSerialNumbers + " for types " + typeAndCompression);
        ArrayList result = new ArrayList();
        TimePoint windowStartTime = startTime;
        while (!windowStartTime.after(endTime)) {
            TimePoint windowEndTime = windowStartTime.plus(Duration.ONE_WEEK);
            if (windowEndTime.after(endTime)) {
                windowEndTime = endTime;
            }
            logger.info("Obtaining resource data from " + windowStartTime + " to " + windowEndTime + " for devices " + deviceSerialNumbers + " for types " + typeAndCompression);
            HttpGet getResourceData = new HttpGet(this.getResourceDataUrl(windowStartTime, windowEndTime, deviceSerialNumbers, typeAndCompression));
            getResourceData.addHeader((String)HttpRequestHeaderConstants.HEADER_FORWARD_TO_MASTER.getA(), (String)HttpRequestHeaderConstants.HEADER_FORWARD_TO_MASTER.getB());
            JSONObject resourceDataJson = (JSONObject)this.getJsonParsedResponse((HttpUriRequest)getResourceData).getA();
            String error = (String)resourceDataJson.get((Object)ERROR);
            if (error != null) {
                String reason = (String)resourceDataJson.get((Object)REASON);
                throw new ClientProtocolException("Error trying to obtain Igtimi resource data from " + windowStartTime + " to " + windowEndTime + " from devices " + deviceSerialNumbers + ": " + error + (reason == null ? "" : ". Reason: " + reason));
            }
            Util.addAll(messageParser.apply(resourceDataJson), result);
            windowStartTime = windowEndTime.plus(1L);
        }
        return result;
    }

    @Override
    public Iterable<Fix> getResourceData(TimePoint startTime, TimePoint endTime, Iterable<String> deviceSerialNumbers, Type ... types) throws IllegalStateException, ClientProtocolException, IOException, ParseException {
        HashMap<Type, Double> typeAndCompression = new HashMap<Type, Double>();
        Type[] typeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Type type = typeArray[n2];
            typeAndCompression.put(type, 0.0);
            ++n2;
        }
        return this.getResourceData(startTime, endTime, deviceSerialNumbers, typeAndCompression);
    }

    @Override
    public Iterable<IgtimiStream.Msg> getMessages(TimePoint startTime, TimePoint endTime, Iterable<String> deviceSerialNumbers, Type[] types) throws IllegalStateException, ClientProtocolException, IOException, ParseException {
        HashMap<Type, Double> typeAndCompression = new HashMap<Type, Double>();
        Type[] typeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Type type = typeArray[n2];
            typeAndCompression.put(type, 0.0);
            ++n2;
        }
        return this.getResourceContent(startTime, endTime, deviceSerialNumbers, typeAndCompression, resourceDataJson -> {
            ArrayList<IgtimiStream.Msg> messages = new ArrayList<IgtimiStream.Msg>();
            for (Map.Entry e : resourceDataJson.entrySet()) {
                JSONArray messagesAsBase64 = (JSONArray)e.getValue();
                for (Object msgAsBase64 : messagesAsBase64) {
                    try {
                        messages.add(IgtimiStream.Msg.parseFrom(Base64.decode((String)msgAsBase64.toString())));
                    }
                    catch (InvalidProtocolBufferException e1) {
                        throw new RuntimeException(e1);
                    }
                }
            }
            return messages;
        });
    }

    private Iterable<Fix> getAndNotifyResourceData(TimePoint startTime, TimePoint endTime, Iterable<String> deviceSerialNumbers, BulkFixReceiver bulkFixReceiver, Type ... types) throws IllegalStateException, ClientProtocolException, IOException, ParseException {
        Iterable<Fix> result = this.getResourceData(startTime, endTime, deviceSerialNumbers, types);
        logger.info("Received " + Util.size(result) + " fixes; will pass them to BulkFixReceiver for further processing now.");
        bulkFixReceiver.received(result);
        return result;
    }

    @Override
    public Map<String, Map<Type, DynamicTrack<Fix>>> getResourceDataAsTracks(TimePoint startTime, TimePoint endTime, Iterable<String> deviceSerialNumbers, Type ... types) throws IllegalStateException, ClientProtocolException, IOException, ParseException {
        Iterable<Fix> fixes = this.getResourceData(startTime, endTime, deviceSerialNumbers, types);
        Map<String, Map<Type, DynamicTrack<Fix>>> result = this.getFixesAsTracks(fixes);
        return result;
    }

    @Override
    public Map<String, Map<Type, DynamicTrack<Fix>>> getFixesAsTracks(Iterable<Fix> fixes) {
        HashMap<String, Map<Type, DynamicTrack<Fix>>> result = new HashMap<String, Map<Type, DynamicTrack<Fix>>>();
        for (Fix fix : fixes) {
            String deviceSerialNumber = fix.getSensor().getDeviceSerialNumber();
            Type type = fix.getType();
            DynamicTrack<Fix> track = this.getOrCreateTrack(result, deviceSerialNumber, type);
            track.add((Timed)fix);
        }
        return result;
    }

    @Override
    public LiveDataConnection getOrCreateLiveConnection(Iterable<String> deviceSerialNumbers) throws Exception {
        return this.liveDataConnectionFactory.getOrCreateLiveDataConnection(deviceSerialNumbers);
    }

    private DynamicTrack<Fix> getOrCreateTrack(Map<String, Map<Type, DynamicTrack<Fix>>> result, String deviceSerialNumber, Type type) {
        DynamicTrackImpl track;
        Map<Type, DynamicTrack<Fix>> mapForDevice = result.get(deviceSerialNumber);
        if (mapForDevice == null) {
            mapForDevice = new HashMap<Type, DynamicTrack<Fix>>();
            result.put(deviceSerialNumber, mapForDevice);
        }
        if ((track = mapForDevice.get((Object)type)) == null) {
            track = new DynamicTrackImpl("Track for Igtimi fixes of type " + type.name() + " for " + this);
            mapForDevice.put(type, (DynamicTrack<Fix>)track);
        }
        return track;
    }

    @Override
    public Iterable<Device> getDevices() throws IllegalStateException, ClientProtocolException, IOException, ParseException {
        HttpGet getResources = new HttpGet(this.getDevicesUrl());
        JSONObject devicesJson = (JSONObject)this.getJsonParsedResponse((HttpUriRequest)getResources).getA();
        ArrayList<Device> result = new ArrayList<Device>();
        for (Object deviceJson : (JSONArray)devicesJson.get((Object)"devices")) {
            Device device = new DeviceDeserializer().createDeviceFromJson((JSONObject)deviceJson);
            result.add(device);
        }
        return result;
    }

    @Override
    public void removeDevice(Device existingDevice) throws ClientProtocolException, IOException, ParseException {
        HttpDelete getResources = new HttpDelete(this.getDeleteDeviceUrl(existingDevice.getId()));
        if ((Integer)this.getJsonParsedResponse((HttpUriRequest)getResources).getB() >= 400) {
            throw new RuntimeException("Error deleting device with ID " + existingDevice.getId());
        }
    }

    private String getDeleteDeviceUrl(long id) {
        return String.valueOf(this.getApiV1BaseUrl()) + "devices/" + id;
    }

    @Override
    public Iterable<DataAccessWindow> getDataAccessWindows(Permission permission, TimePoint startTime, TimePoint endTime, Iterable<String> deviceSerialNumbers) throws IllegalStateException, ClientProtocolException, IOException, ParseException {
        HttpGet getDataAccessWindows = new HttpGet(this.getDataAccessWindowsUrl(permission, startTime, endTime, deviceSerialNumbers));
        JSONObject dataAccessWindowsJson = (JSONObject)this.getJsonParsedResponse((HttpUriRequest)getDataAccessWindows).getA();
        ArrayList<DataAccessWindow> result = new ArrayList<DataAccessWindow>();
        for (Object dataAccessWindowJson : (JSONArray)dataAccessWindowsJson.get((Object)"data_access_windows")) {
            DataAccessWindow dataAccessWindow = new DataAccessWindowDeserializer().createDataAccessWindowFromJson((JSONObject)((JSONObject)dataAccessWindowJson).get((Object)"data_access_window"));
            result.add(dataAccessWindow);
        }
        return result;
    }

    @Override
    public DataAccessWindow createDataAccessWindow(String deviceSerialNumber, TimePoint startTime, TimePoint endTime) throws ClientProtocolException, IOException, ParseException {
        HttpPost createDataAccessWindows = new HttpPost(this.getCreateDataAccessWindowsUrl(deviceSerialNumber, startTime, endTime));
        createDataAccessWindows.setEntity((HttpEntity)new StringEntity(new DataAccessWindowSerializer().createJsonFromDataAccessWindow(DataAccessWindow.create(0L, startTime, endTime, deviceSerialNumber)).toJSONString(), ContentType.APPLICATION_JSON));
        JSONObject dataAccessWindowsJson = (JSONObject)this.getJsonParsedResponse((HttpUriRequest)createDataAccessWindows).getA();
        DataAccessWindow dataAccessWindow = new DataAccessWindowDeserializer().createDataAccessWindowFromJson(dataAccessWindowsJson);
        return dataAccessWindow;
    }

    private String getCreateDataAccessWindowsUrl(String deviceSerialNumber, TimePoint startTime, TimePoint endTime) {
        StringBuilder url = new StringBuilder(this.getApiV1BaseUrl());
        url.append("data_access_windows");
        return url.toString();
    }

    @Override
    public Map<TrackedRace, Integer> importWindIntoRace(Iterable<DynamicTrackedRace> trackedRaces, boolean correctByDeclination) throws IllegalStateException, ClientProtocolException, IOException, ParseException {
        Map<TrackedRace, Integer> result;
        logger.info("Importing Igtimi wind for tracked races " + trackedRaces);
        MillisecondsTimePoint startOfWindow = new MillisecondsTimePoint(Long.MAX_VALUE);
        MillisecondsTimePoint endOfWindow = new MillisecondsTimePoint(0L);
        for (DynamicTrackedRace trackedRace : trackedRaces) {
            startOfWindow = Collections.min(Arrays.asList(startOfWindow, IgtimiWindTracker.getReceivingStartTime(trackedRace)));
            TimePoint receivingEndTime = IgtimiWindTracker.getReceivingEndTime(trackedRace);
            endOfWindow = Collections.max(Arrays.asList(endOfWindow, receivingEndTime == null ? MillisecondsTimePoint.now() : receivingEndTime));
        }
        Iterable<DataAccessWindow> daws = this.getDataAccessWindows(Permission.read, (TimePoint)startOfWindow, (TimePoint)endOfWindow, null);
        logger.info("Found " + Util.size(daws) + " data access windows.");
        Set deviceSerialNumbers = Util.asSet((Iterable)Util.map(daws, DataAccessWindow::getDeviceSerialNumber));
        if (!deviceSerialNumbers.isEmpty()) {
            IgtimiWindReceiver windReceiver = new IgtimiWindReceiver((DeclinationService)(correctByDeclination ? DeclinationService.INSTANCE : null));
            WindListenerSendingToTrackedRace windListener = new WindListenerSendingToTrackedRace(trackedRaces, Activator.getInstance().getWindTrackerFactory());
            windReceiver.addListener(windListener);
            this.getAndNotifyResourceData((TimePoint)startOfWindow, (TimePoint)endOfWindow, deviceSerialNumbers, windReceiver, windReceiver.getFixTypes());
            result = windListener.getFixesAppliedPerTrackedRace();
            logger.info("Imported the following number of wind fixes for the following list of races: " + result);
        } else {
            logger.info("No Igtimi devices that measure wind found for time window " + startOfWindow + ".." + endOfWindow);
            result = new HashMap<TrackedRace, Integer>();
        }
        return result;
    }

    @Override
    public Iterable<String> getWindDevices() throws IllegalStateException, ClientProtocolException, IOException, ParseException {
        Iterable<DataAccessWindow> dataAccessWindows = this.getDataAccessWindows(Permission.read, null, null, null);
        HashSet<String> deviceSerialNumbersWeCanRead = new HashSet<String>();
        for (DataAccessWindow daw : dataAccessWindows) {
            deviceSerialNumbersWeCanRead.add(daw.getDeviceSerialNumber());
        }
        Iterable<Fix> gpsFixes = this.getLatestFixes(deviceSerialNumbersWeCanRead, Type.gps_latlong);
        Set<String> devicesWithGps = this.getDeviceSerialNumbers(gpsFixes);
        Iterable<Fix> awsFixes = this.getLatestFixes(deviceSerialNumbersWeCanRead, Type.AWS);
        Set<String> devicesWithWind = this.getDeviceSerialNumbers(awsFixes);
        HashSet<String> devicesThatHaveNeverSentGpsNorWind = new HashSet<String>(deviceSerialNumbersWeCanRead);
        devicesThatHaveNeverSentGpsNorWind.removeAll(devicesWithGps);
        devicesThatHaveNeverSentGpsNorWind.removeAll(devicesWithWind);
        HashSet<String> devicesWeShouldListenTo = new HashSet<String>();
        devicesWeShouldListenTo.addAll(devicesWithWind);
        devicesWeShouldListenTo.addAll(devicesThatHaveNeverSentGpsNorWind);
        logger.info("Wind devices identified: " + devicesWeShouldListenTo + " because from all devices " + deviceSerialNumbersWeCanRead + " for " + devicesThatHaveNeverSentGpsNorWind + " we don't know what they are as they never sent anything we can access, and for " + devicesWithWind + " we know they sent wind");
        return devicesWeShouldListenTo;
    }

    private Set<String> getDeviceSerialNumbers(Iterable<Fix> fixes) {
        HashSet<String> deviceSerialNumbers = new HashSet<String>();
        for (Fix fix : fixes) {
            deviceSerialNumbers.add(fix.getSensor().getDeviceSerialNumber());
        }
        return deviceSerialNumbers;
    }

    private String getApiV1BaseUrl() {
        return this.getBaseUrl() + "/igtimi/api/v1/";
    }

    @Override
    public JSONObject getWebSocketConfigurationMessage(Iterable<String> deviceIds) {
        JSONObject result = new JSONObject();
        JSONArray deviceIdsJson = new JSONArray();
        result.put((Object)"devices", (Object)deviceIdsJson);
        for (String deviceId : deviceIds) {
            deviceIdsJson.add((Object)deviceId);
        }
        return result;
    }

    private String getDevicesUrl() {
        return String.valueOf(this.getApiV1BaseUrl()) + "devices/";
    }

    private String getDataAccessWindowsUrl(Permission permission, TimePoint startTime, TimePoint endTime, Iterable<String> deviceSerialNumbers) {
        StringBuilder url = new StringBuilder(this.getApiV1BaseUrl());
        url.append("data_access_windows?type=");
        url.append(permission.name());
        if (startTime != null) {
            url.append("&start_time=");
            url.append(startTime.asMillis());
        }
        if (endTime != null) {
            url.append("&end_time=");
            url.append(endTime.asMillis());
        }
        if (deviceSerialNumbers != null) {
            for (String serialNumber : deviceSerialNumbers) {
                url.append("&serial_numbers[]=");
                url.append(serialNumber);
            }
        }
        return url.toString();
    }

    private String getLatestDatumUrl(Iterable<String> deviceSerialNumbers, Type type) {
        StringBuilder url = new StringBuilder(this.getApiV1BaseUrl());
        url.append("resources/data/latest?type=");
        url.append(type.getCode());
        for (String deviceSerialNumber : deviceSerialNumbers) {
            url.append("&serial_numbers[]=");
            url.append(deviceSerialNumber);
        }
        return url.toString();
    }

    private String getResourceDataUrl(TimePoint startTime, TimePoint endTime, Iterable<String> serialNumbers, Map<Type, Double> typeAndCompression) {
        StringBuilder url = new StringBuilder(this.getApiV1BaseUrl());
        url.append("resources/data?start_time=");
        url.append(startTime.asMillis());
        url.append("&end_time=");
        url.append(endTime.asMillis());
        for (String string : serialNumbers) {
            url.append("&serial_numbers[]=");
            url.append(string);
        }
        for (Map.Entry entry : typeAndCompression.entrySet()) {
            url.append("&types[" + ((Type)((Object)entry.getKey())).getCode() + "]=" + entry.getValue());
        }
        url.append("&restore_archives=true");
        return url.toString();
    }

    @Override
    public Iterable<URI> getWebsocketServers() throws IllegalStateException, ClientProtocolException, IOException, ParseException, URISyntaxException {
        HttpGet getWebsocketServers = new HttpGet(String.valueOf(this.getApiV1BaseUrl()) + "server_listers/web_sockets");
        JSONObject serversJson = (JSONObject)this.getJsonParsedResponse((HttpUriRequest)getWebsocketServers).getA();
        ArrayList<URI> result = new ArrayList<URI>();
        for (Object serverUrl : (JSONArray)serversJson.get((Object)"web_socket_servers")) {
            URI uri = new URI((String)serverUrl);
            result.add(uri);
        }
        Collections.shuffle(result);
        logger.info("Trying Igtimi WebSocket servers in the following order: " + result);
        return result;
    }

    @Override
    public int getRiotPort() throws ClientProtocolException, IOException, ParseException {
        HttpGet getServer = new HttpGet(String.valueOf(this.getApiV1BaseUrl()) + "server");
        JSONObject serverJson = (JSONObject)this.getJsonParsedResponse((HttpUriRequest)getServer).getA();
        return Integer.valueOf(serverJson.get((Object)"port").toString());
    }

    @Override
    public void authenticate(ClientUpgradeRequest websocketUpgradeRequest) {
        super.authenticate(websocketUpgradeRequest);
    }
}

