/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.impl;

import com.sap.sailing.competitorimport.CompetitorProvider;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceLogResolver;
import com.sap.sailing.domain.base.MasterDataImportClassLoaderService;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.common.ScoreCorrectionProvider;
import com.sap.sailing.domain.common.WindFinderReviewedSpotsCollectionIdProvider;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.domain.common.subscription.PremiumRole;
import com.sap.sailing.domain.common.subscription.SailingSubscriptionPlan;
import com.sap.sailing.domain.common.tracking.impl.DoubleVectorFixImpl;
import com.sap.sailing.domain.common.tracking.impl.GPSFixImpl;
import com.sap.sailing.domain.common.tracking.impl.GPSFixMovingImpl;
import com.sap.sailing.domain.persistence.DomainObjectFactory;
import com.sap.sailing.domain.persistence.MongoObjectFactory;
import com.sap.sailing.domain.persistence.racelog.tracking.FixMongoHandler;
import com.sap.sailing.domain.persistence.racelog.tracking.impl.DoubleVectorFixMongoHandlerImpl;
import com.sap.sailing.domain.persistence.racelog.tracking.impl.GPSFixMongoHandlerImpl;
import com.sap.sailing.domain.persistence.racelog.tracking.impl.GPSFixMovingMongoHandlerImpl;
import com.sap.sailing.domain.polars.PolarDataService;
import com.sap.sailing.domain.racelog.tracking.SensorFixStoreSupplier;
import com.sap.sailing.domain.tracking.TrackedRegattaListener;
import com.sap.sailing.domain.windestimation.WindEstimationFactoryService;
import com.sap.sailing.resultimport.ResultUrlRegistry;
import com.sap.sailing.server.impl.ExtenderBundleTracker;
import com.sap.sailing.server.impl.OSGiBasedTrackedRegattaListener;
import com.sap.sailing.server.impl.RacingEventServiceImpl;
import com.sap.sailing.server.impl.RacingEventServiceMXBeanImpl;
import com.sap.sailing.server.impl.SecurityUrlPathProviderSailingImpl;
import com.sap.sailing.server.impl.preferences.model.BoatClassNotificationPreferences;
import com.sap.sailing.server.impl.preferences.model.CompetitorNotificationPreferences;
import com.sap.sailing.server.impl.preferences.model.StoredDataMiningQueryPreferences;
import com.sap.sailing.server.impl.preferences.model.StoredDataMiningReportPreferences;
import com.sap.sailing.server.impl.preferences.model.TrackedEventPreferences;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.notification.impl.SailingNotificationServiceImpl;
import com.sap.sailing.server.preferences.SailorProfilePreferences;
import com.sap.sailing.server.security.EventManagerRole;
import com.sap.sailing.server.security.SailingViewerRole;
import com.sap.sailing.server.statistics.TrackedRaceStatisticsCache;
import com.sap.sailing.server.statistics.TrackedRaceStatisticsCacheImpl;
import com.sap.sailing.shared.server.SharedSailingData;
import com.sap.sse.branding.BrandingConfigurationService;
import com.sap.sse.classloading.ServiceTrackerCustomizerForClassLoaderSupplierRegistrations;
import com.sap.sse.common.TypeBasedServiceFinderFactory;
import com.sap.sse.common.Util;
import com.sap.sse.mail.MailService;
import com.sap.sse.mail.queue.MailQueue;
import com.sap.sse.mail.queue.impl.ExecutorMailQueue;
import com.sap.sse.osgi.CachedOsgiTypeBasedServiceFinderFactory;
import com.sap.sse.replication.FullyInitializedReplicableTracker;
import com.sap.sse.replication.Replicable;
import com.sap.sse.replication.ReplicationService;
import com.sap.sse.security.SecurityInitializationCustomizer;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.SecurityUrlPathProvider;
import com.sap.sse.security.interfaces.PreferenceConverter;
import com.sap.sse.security.shared.HasPermissionsProvider;
import com.sap.sse.security.shared.RoleDefinition;
import com.sap.sse.security.shared.RolePrototype;
import com.sap.sse.security.shared.ServerAdminRole;
import com.sap.sse.security.shared.SubscriptionPlanProvider;
import com.sap.sse.security.shared.subscription.AllDataMiningRole;
import com.sap.sse.security.shared.subscription.ArchiveDataMiningRole;
import com.sap.sse.security.util.GenericJSONPreferenceConverter;
import com.sap.sse.shared.classloading.ClassLoaderRegistry;
import com.sap.sse.util.ClearStateTestSupport;
import com.sap.sse.util.ServiceTrackerFactory;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator {
    private static final Logger logger = Logger.getLogger(Activator.class.getName());
    private static final String CLEAR_PERSISTENT_COMPETITORS_PROPERTY_NAME = "persistentcompetitors.clear";
    private static final String RESTORE_TRACKED_RACES_PROPERTY_NAME = "restore.tracked.races";
    private static ExtenderBundleTracker extenderBundleTracker;
    private static BundleContext context;
    private CachedOsgiTypeBasedServiceFinderFactory serviceFinderFactory;
    private RacingEventServiceImpl racingEventService;
    private final boolean clearPersistentCompetitors;
    private final boolean restoreTrackedRaces;
    private Set<ServiceRegistration<?>> registrations = new HashSet();
    private ObjectName mBeanName;
    private ServiceTracker<MasterDataImportClassLoaderService, MasterDataImportClassLoaderService> masterDataImportClassLoaderServiceTracker;
    private ServiceTracker<PolarDataService, PolarDataService> polarDataServiceTracker;
    private ServiceTracker<WindEstimationFactoryService, WindEstimationFactoryService> windEstimationFactoryServiceTrack;
    private OSGiBasedTrackedRegattaListener trackedRegattaListener;
    private MailQueue mailQueue;
    private SailingNotificationServiceImpl notificationService;
    private ServiceTracker<MailService, MailService> mailServiceTracker;
    private FullyInitializedReplicableTracker<SecurityService> securityServiceTracker;
    private FullyInitializedReplicableTracker<SharedSailingData> sharedSailingDataTracker;
    private ServiceTracker<ReplicationService, ReplicationService> replicationServiceTracker;

    public Activator() {
        this.clearPersistentCompetitors = Boolean.valueOf(System.getProperty(CLEAR_PERSISTENT_COMPETITORS_PROPERTY_NAME, "false"));
        this.restoreTrackedRaces = Boolean.valueOf(System.getProperty(RESTORE_TRACKED_RACES_PROPERTY_NAME, "false"));
        logger.log(Level.INFO, "setting persistentcompetitors.clear to " + this.clearPersistentCompetitors);
    }

    public void start(final BundleContext context) throws Exception {
        Activator.context = context;
        extenderBundleTracker = new ExtenderBundleTracker(context);
        extenderBundleTracker.open();
        this.mailServiceTracker = ServiceTrackerFactory.createAndOpen((BundleContext)context, MailService.class);
        this.replicationServiceTracker = ServiceTrackerFactory.createAndOpen((BundleContext)context, ReplicationService.class);
        this.sharedSailingDataTracker = FullyInitializedReplicableTracker.createAndOpen((BundleContext)context, SharedSailingData.class);
        this.securityServiceTracker = FullyInitializedReplicableTracker.createAndOpen((BundleContext)context, SecurityService.class);
        new Thread(this + " initializing RacingEventService in the background"){

            @Override
            public void run() {
                try {
                    Activator.this.internalStartBundle(context);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Could not start RacingEvent service properly", e);
                }
            }
        }.start();
    }

    protected void registerPreferenceConvertersForUserStore(BundleContext context) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("key", "sailing.notifications.competitors");
        this.registrations.add(context.registerService(PreferenceConverter.class, (Object)new GenericJSONPreferenceConverter(() -> new CompetitorNotificationPreferences()), properties));
        ((Dictionary)properties).put("key", "sailing.notifications.boatclasses");
        this.registrations.add(context.registerService(PreferenceConverter.class, (Object)new GenericJSONPreferenceConverter(() -> new BoatClassNotificationPreferences(this.racingEventService)), properties));
        ((Dictionary)properties).put("key", "sailing.datamining.storedqueries");
        this.registrations.add(context.registerService(PreferenceConverter.class, (Object)new GenericJSONPreferenceConverter(StoredDataMiningQueryPreferences::new), properties));
        ((Dictionary)properties).put("key", "sailing.datamining.storedreports");
        this.registrations.add(context.registerService(PreferenceConverter.class, (Object)new GenericJSONPreferenceConverter(StoredDataMiningReportPreferences::new), properties));
        ((Dictionary)properties).put("key", "user.profile.sailorProfiles");
        this.registrations.add(context.registerService(PreferenceConverter.class, (Object)new GenericJSONPreferenceConverter(() -> new SailorProfilePreferences(this.racingEventService.getCompetitorAndBoatStore())), properties));
        ((Dictionary)properties).put("key", "sailing.profile.trackedevents");
        this.registrations.add(context.registerService(PreferenceConverter.class, (Object)new GenericJSONPreferenceConverter(TrackedEventPreferences::new), properties));
    }

    public static BundleContext getContext() {
        return context;
    }

    public void stop(BundleContext context) throws Exception {
        this.masterDataImportClassLoaderServiceTracker.close();
        if (extenderBundleTracker != null) {
            extenderBundleTracker.close();
        }
        if (this.serviceFinderFactory != null) {
            this.serviceFinderFactory.close();
        }
        for (Util.Triple<Regatta, RaceDefinition, String> triple : this.racingEventService.getWindTrackedRaces()) {
            this.racingEventService.stopTrackingWind((Regatta)triple.getA(), (RaceDefinition)triple.getB());
        }
        for (Regatta regatta : this.racingEventService.getAllRegattas()) {
            this.racingEventService.stopTracking(regatta, true);
        }
        for (ServiceRegistration serviceRegistration : this.registrations) {
            serviceRegistration.unregister();
        }
        this.trackedRegattaListener.close();
        this.registrations.clear();
        this.notificationService.stop();
        this.mailQueue.stop();
        this.mailServiceTracker.close();
        this.sharedSailingDataTracker.close();
        this.replicationServiceTracker.close();
        this.securityServiceTracker.close();
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        mBeanServer.unregisterMBean(this.mBeanName);
    }

    private void internalStartBundle(BundleContext context) throws MalformedURLException, MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException, InterruptedException {
        this.mailQueue = new ExecutorMailQueue(this.mailServiceTracker);
        this.notificationService = new SailingNotificationServiceImpl(context, this.mailQueue);
        this.trackedRegattaListener = new OSGiBasedTrackedRegattaListener(context);
        Hashtable<String, String> sailingSecurityUrlPathProviderProperties = new Hashtable<String, String>();
        ((Dictionary)sailingSecurityUrlPathProviderProperties).put("type", "sailing");
        this.registrations.add(context.registerService(SecurityUrlPathProvider.class, (Object)new SecurityUrlPathProviderSailingImpl(), sailingSecurityUrlPathProviderProperties));
        this.registrations.add(context.registerService(HasPermissionsProvider.class, SecuredDomainType::getAllInstances, null));
        this.registrations.add(context.registerService(SubscriptionPlanProvider.class, SailingSubscriptionPlan::getAllInstances, null));
        this.registrations.add(context.registerService(SecurityInitializationCustomizer.class, securityService -> {
            Thread backgroundThread = new Thread(() -> {
                try {
                    ReplicationService replicationService = (ReplicationService)ServiceTrackerFactory.createAndOpen((BundleContext)context, ReplicationService.class).waitForService(0L);
                    if (!replicationService.isReplicationStarting() && securityService.getMasterDescriptor() == null) {
                        RoleDefinition sailingViewerRoleDefinition = securityService.getOrCreateRoleDefinitionFromPrototype((RolePrototype)SailingViewerRole.getInstance(), true);
                        securityService.getOrCreateRoleDefinitionFromPrototype((RolePrototype)EventManagerRole.getInstance(), true);
                        securityService.getOrCreateRoleDefinitionFromPrototype((RolePrototype)ServerAdminRole.getInstance(), true);
                        securityService.getOrCreateRoleDefinitionFromPrototype((RolePrototype)PremiumRole.getInstance(), true);
                        securityService.getOrCreateRoleDefinitionFromPrototype((RolePrototype)ArchiveDataMiningRole.getInstance(), true);
                        securityService.getOrCreateRoleDefinitionFromPrototype((RolePrototype)AllDataMiningRole.getInstance(), true);
                        if (securityService.isNewServer()) {
                            securityService.putRoleDefinitionToUserGroup(securityService.getServerGroup(), sailingViewerRoleDefinition, true);
                        }
                    }
                }
                catch (InterruptedException e) {
                    logger.log(Level.SEVERE, "Couldn't get a hold of the ReplicationService to tell whether this SecurityService is to become a replica; not setting server to public, not enforcing READability of sailing_viewer role", e);
                }
            }, "Waiting for replication service to tell whether this SecurityService will become a replica");
            backgroundThread.setDaemon(true);
            backgroundThread.start();
        }, null));
        TrackedRaceStatisticsCacheImpl trackedRaceStatisticsCache = new TrackedRaceStatisticsCacheImpl();
        this.registrations.add(context.registerService(TrackedRaceStatisticsCache.class.getName(), (Object)trackedRaceStatisticsCache, null));
        this.registrations.add(context.registerService(TrackedRegattaListener.class.getName(), (Object)trackedRaceStatisticsCache, null));
        this.serviceFinderFactory = new CachedOsgiTypeBasedServiceFinderFactory(context);
        ServiceTracker scoreCorrectionProviderServiceTracker = ServiceTrackerFactory.createAndOpen((BundleContext)context, ScoreCorrectionProvider.class);
        ServiceTracker competitorProviderServiceTracker = ServiceTrackerFactory.createAndOpen((BundleContext)context, CompetitorProvider.class);
        ServiceTracker resultUrlRegistryServiceTracker = ServiceTrackerFactory.createAndOpen((BundleContext)context, ResultUrlRegistry.class);
        ServiceTracker brandingConfigurationServiceTracker = ServiceTrackerFactory.createAndOpen((BundleContext)context, BrandingConfigurationService.class);
        this.racingEventService = new RacingEventServiceImpl(this.clearPersistentCompetitors, null, (TypeBasedServiceFinderFactory)this.serviceFinderFactory, this.trackedRegattaListener, this.notificationService, trackedRaceStatisticsCache, this.restoreTrackedRaces, this.securityServiceTracker, this.sharedSailingDataTracker, this.replicationServiceTracker, (ServiceTracker<ScoreCorrectionProvider, ScoreCorrectionProvider>)scoreCorrectionProviderServiceTracker, (ServiceTracker<CompetitorProvider, CompetitorProvider>)competitorProviderServiceTracker, (ServiceTracker<ResultUrlRegistry, ResultUrlRegistry>)resultUrlRegistryServiceTracker, (ServiceTracker<BrandingConfigurationService, BrandingConfigurationService>)brandingConfigurationServiceTracker);
        this.notificationService.setRacingEventService(this.racingEventService);
        this.masterDataImportClassLoaderServiceTracker = ServiceTrackerCustomizerForClassLoaderSupplierRegistrations.createClassLoaderSupplierServiceTracker((BundleContext)context, MasterDataImportClassLoaderService.class, (ClassLoaderRegistry)this.racingEventService.getMasterDataClassLoaders());
        this.polarDataServiceTracker = new ServiceTracker(context, PolarDataService.class, (ServiceTrackerCustomizer)new PolarDataServiceTrackerCustomizer(context, this.racingEventService));
        this.polarDataServiceTracker.open();
        this.windEstimationFactoryServiceTrack = new ServiceTracker(context, WindEstimationFactoryService.class, (ServiceTrackerCustomizer)new WindEstimationFactoryServiceTrackerCustomizer(context, this.racingEventService));
        this.windEstimationFactoryServiceTrack.open();
        this.racingEventService.setBundleContext(context);
        context.registerService(MongoObjectFactory.class, (Object)this.racingEventService.getMongoObjectFactory(), null);
        context.registerService(DomainObjectFactory.class, (Object)this.racingEventService.getDomainObjectFactory(), null);
        Hashtable<String, String> replicableServiceProperties = new Hashtable<String, String>();
        ((Dictionary)replicableServiceProperties).put("ID", this.racingEventService.getId().toString());
        context.registerService(Replicable.class, (Object)this.racingEventService, replicableServiceProperties);
        context.registerService(RacingEventService.class, (Object)this.racingEventService, null);
        context.registerService(RaceLogResolver.class, (Object)this.racingEventService, null);
        context.registerService(ClearStateTestSupport.class, (Object)this.racingEventService, null);
        context.registerService(SensorFixStoreSupplier.class, (Object)this.racingEventService, null);
        context.registerService(WindFinderReviewedSpotsCollectionIdProvider.class, (Object)this.racingEventService, null);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        GPSFixMongoHandlerImpl gpsFixMongoHandler = new GPSFixMongoHandlerImpl(this.racingEventService.getMongoObjectFactory(), this.racingEventService.getDomainObjectFactory());
        ((Dictionary)properties).put("type", GPSFixImpl.class.getName());
        this.registrations.add(context.registerService(FixMongoHandler.class, (Object)gpsFixMongoHandler, properties));
        ((Dictionary)properties).put("type", "com.sap.sailing.domain.tracking.impl.GPSFixImpl");
        this.registrations.add(context.registerService(FixMongoHandler.class, (Object)gpsFixMongoHandler, properties));
        GPSFixMovingMongoHandlerImpl gpsFixMovingMongoHandler = new GPSFixMovingMongoHandlerImpl(this.racingEventService.getMongoObjectFactory(), this.racingEventService.getDomainObjectFactory());
        ((Dictionary)properties).put("type", GPSFixMovingImpl.class.getName());
        this.registrations.add(context.registerService(FixMongoHandler.class, (Object)gpsFixMovingMongoHandler, properties));
        ((Dictionary)properties).put("type", "com.sap.sailing.domain.tracking.impl.GPSFixMovingImpl");
        this.registrations.add(context.registerService(FixMongoHandler.class, (Object)gpsFixMovingMongoHandler, properties));
        ((Dictionary)properties).put("type", DoubleVectorFixImpl.class.getName());
        this.registrations.add(context.registerService(FixMongoHandler.class, (Object)new DoubleVectorFixMongoHandlerImpl(this.racingEventService.getMongoObjectFactory(), this.racingEventService.getDomainObjectFactory()), properties));
        this.registerPreferenceConvertersForUserStore(context);
        RacingEventServiceMXBeanImpl mbean = new RacingEventServiceMXBeanImpl(this.racingEventService);
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        this.mBeanName = new ObjectName("com.sap.sailing:type=RacingEventService");
        mbs.registerMBean(mbean, this.mBeanName);
        logger.log(Level.INFO, "Started " + context.getBundle().getSymbolicName() + ". Character encoding: " + Charset.defaultCharset());
        this.racingEventService.ensureOwnerships();
        this.racingEventService.migrateCompetitorNotificationPreferencesWithCompetitorNames();
    }

    private class PolarDataServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<PolarDataService, PolarDataService> {
        private final BundleContext context;
        private RacingEventServiceImpl racingEventService;

        public PolarDataServiceTrackerCustomizer(BundleContext context, RacingEventServiceImpl racingEventService) {
            this.context = context;
            this.racingEventService = racingEventService;
        }

        public PolarDataService addingService(ServiceReference<PolarDataService> reference) {
            PolarDataService service = (PolarDataService)this.context.getService(reference);
            this.racingEventService.setPolarDataService(service);
            return service;
        }

        public void modifiedService(ServiceReference<PolarDataService> reference, PolarDataService service) {
        }

        public void removedService(ServiceReference<PolarDataService> reference, PolarDataService service) {
            this.racingEventService.unsetPolarDataService(service);
        }
    }

    private class WindEstimationFactoryServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<WindEstimationFactoryService, WindEstimationFactoryService> {
        private final BundleContext context;
        private final RacingEventServiceImpl racingEventService;

        public WindEstimationFactoryServiceTrackerCustomizer(BundleContext context, RacingEventServiceImpl racingEventService) {
            this.context = context;
            this.racingEventService = racingEventService;
        }

        public WindEstimationFactoryService addingService(ServiceReference<WindEstimationFactoryService> reference) {
            WindEstimationFactoryService service = (WindEstimationFactoryService)this.context.getService(reference);
            service.addWindEstimationModelsChangedListenerAndReceiveUpdate(windEstimationReady -> this.racingEventService.setWindEstimationFactoryService((WindEstimationFactoryService)(windEstimationReady ? service : null)));
            return service;
        }

        public void modifiedService(ServiceReference<WindEstimationFactoryService> reference, WindEstimationFactoryService service) {
        }

        public void removedService(ServiceReference<WindEstimationFactoryService> reference, WindEstimationFactoryService service) {
            this.racingEventService.setWindEstimationFactoryService(null);
        }
    }
}

