/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.model.regressor.twdtransition;

import com.sap.sailing.windestimation.data.TwdTransition;
import com.sap.sailing.windestimation.model.regressor.twdtransition.SingleDimensionBasedTwdTransitionRegressorModelContext;
import com.sap.sailing.windestimation.model.regressor.twdtransition.SupportedDimensionValueRange;
import com.sap.sailing.windestimation.model.store.ModelDomainType;

public final class DistanceBasedTwdTransitionRegressorModelContext
extends SingleDimensionBasedTwdTransitionRegressorModelContext {
    private static final String DIMENSION_NAME = "Distance";
    private static final long serialVersionUID = 4324543543L;

    public DistanceBasedTwdTransitionRegressorModelContext(DistanceValueRange distanceValueRange) {
        super(DIMENSION_NAME, ModelDomainType.DISTANCE_BASED_TWD_DELTA_STD_REGRESSOR, distanceValueRange.getSupportedDimensionValueRange());
    }

    @Override
    public double getDimensionValueUnpreprocessed(TwdTransition instance) {
        double meters = instance.getDistance().getMeters();
        return meters;
    }

    public static enum DistanceValueRange {
        BEGINNING(0.0, 10.0, 1, false),
        MIDDLE1(10.0, 100.0, 1, true),
        MIDDLE2(100.0, 500.0, 1, true),
        REMAINDER(500.0, 1.0E11, 1, true);

        private final SupportedDimensionValueRange supportedDimensionValueRange;

        private DistanceValueRange(double fromInclusive, double toExclusive, int polynomialDegree, boolean withBias) {
            this.supportedDimensionValueRange = new SupportedDimensionValueRange(fromInclusive, toExclusive, polynomialDegree, withBias);
        }

        public SupportedDimensionValueRange getSupportedDimensionValueRange() {
            return this.supportedDimensionValueRange;
        }
    }
}

