/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.aggregator.hmm;

import com.sap.sailing.windestimation.aggregator.hmm.BestManeuverNodeInfo;
import com.sap.sailing.windestimation.aggregator.hmm.BestNodeInfo;
import com.sap.sailing.windestimation.aggregator.hmm.BestPathsPerLevel;
import com.sap.sailing.windestimation.aggregator.hmm.GraphLevel;
import com.sap.sailing.windestimation.aggregator.hmm.GraphLevelInference;
import com.sap.sailing.windestimation.aggregator.hmm.GraphNode;
import com.sap.sailing.windestimation.aggregator.hmm.GraphNodeTransitionProbabilitiesCalculator;
import com.sap.sailing.windestimation.aggregator.hmm.IntersectedWindRange;
import com.sap.sse.common.Util;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class BestPathsCalculator {
    private GraphLevel lastLevel;
    private Map<GraphLevel, BestPathsPerLevel> bestPathsPerLevel;
    private final boolean preciseConfidence;
    private final GraphNodeTransitionProbabilitiesCalculator<GraphLevel> transitionProbabilitiesCalculator;

    public BestPathsCalculator(GraphNodeTransitionProbabilitiesCalculator<GraphLevel> transitionProbabilitiesCalculator) {
        this(true, transitionProbabilitiesCalculator);
    }

    public BestPathsCalculator(boolean preciseConfidence, GraphNodeTransitionProbabilitiesCalculator<GraphLevel> transitionProbabilitiesCalculator) {
        this.preciseConfidence = preciseConfidence;
        this.transitionProbabilitiesCalculator = transitionProbabilitiesCalculator;
    }

    public GraphNodeTransitionProbabilitiesCalculator<GraphLevel> getTransitionProbabilitiesCalculator() {
        return this.transitionProbabilitiesCalculator;
    }

    public void computeBestPathsFromScratch() {
        GraphLevel previousLevel = this.lastLevel;
        if (previousLevel != null) {
            while (previousLevel.getPreviousLevel() != null) {
                previousLevel = previousLevel.getPreviousLevel();
            }
            this.computeBestPathsFromScratch(previousLevel);
        }
    }

    public void computeBestPathsFromScratch(GraphLevel firstLevel) {
        this.resetState();
        GraphLevel currentLevel = firstLevel;
        do {
            this.computeBestPathsToNextLevel(currentLevel);
        } while ((currentLevel = currentLevel.getNextLevel()) != null);
    }

    public void recomputeBestPathsFromLevel(GraphLevel fromLevel) {
        LinkedList<GraphLevel> levelsToKeep = new LinkedList<GraphLevel>();
        GraphLevel currentLevel = fromLevel.getPreviousLevel();
        while (currentLevel != null) {
            levelsToKeep.add(currentLevel);
            currentLevel = currentLevel.getPreviousLevel();
        }
        Iterator<Map.Entry<GraphLevel, BestPathsPerLevel>> iterator = this.bestPathsPerLevel.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<GraphLevel, BestPathsPerLevel> entry = iterator.next();
            if (levelsToKeep.contains(entry.getKey())) continue;
            iterator.remove();
        }
        this.lastLevel = fromLevel.getPreviousLevel();
        currentLevel = fromLevel;
        do {
            this.computeBestPathsToNextLevel(currentLevel);
        } while (currentLevel != null);
    }

    public void resetState() {
        this.lastLevel = null;
        this.bestPathsPerLevel = null;
    }

    public void computeBestPathsToNextLevel(GraphLevel nextLevel) {
        GraphLevel previousLevel = nextLevel.getPreviousLevel();
        if (previousLevel != this.lastLevel) {
            throw new IllegalArgumentException("The previous level of next level does not match with the last level processed by this calculator");
        }
        GraphLevel currentLevel = nextLevel;
        if (previousLevel == null) {
            this.bestPathsPerLevel = new HashMap<GraphLevel, BestPathsPerLevel>();
            BestPathsPerLevel bestPathsUntilLevel = new BestPathsPerLevel(currentLevel);
            for (GraphNode<GraphLevel> graphNode : currentLevel.getLevelNodes()) {
                double probability = graphNode.getConfidence() / (double)currentLevel.getLevelNodes().size();
                BestManeuverNodeInfo<GraphLevel> currentNodeInfo = bestPathsUntilLevel.addBestPreviousNodeInfo(graphNode, null, probability, graphNode.getValidWindRange().toIntersected());
                currentNodeInfo.setForwardProbability(probability);
            }
            this.bestPathsPerLevel.put(currentLevel, bestPathsUntilLevel);
        } else {
            BestPathsPerLevel bestPathsUntilPreviousLevel = this.bestPathsPerLevel.get(previousLevel);
            BestPathsPerLevel bestPathsPerLevel = new BestPathsPerLevel(currentLevel);
            for (GraphNode<GraphLevel> graphNode : currentLevel.getLevelNodes()) {
                double bestProbabilityFromStart = 0.0;
                double forwardProbability = 0.0;
                GraphNode bestPreviousNode = null;
                IntersectedWindRange bestIntersectedWindRange = null;
                for (GraphNode previousNode : previousLevel.getLevelNodes()) {
                    IntersectedWindRange previousNodeIntersectedWindRange = bestPathsUntilPreviousLevel.getBestPreviousNodeInfo(previousNode).getIntersectedWindRange();
                    Util.Pair<IntersectedWindRange, Double> newWindRangeAndProbability = this.transitionProbabilitiesCalculator.mergeWindRangeAndGetTransitionProbability(previousNode, previousLevel, previousNodeIntersectedWindRange, graphNode, currentLevel);
                    double transitionObservationMultipliedProbability = (Double)newWindRangeAndProbability.getB() * graphNode.getConfidence();
                    double probabilityFromStart = bestPathsUntilPreviousLevel.getNormalizedProbabilityToNodeFromStart(previousNode) * transitionObservationMultipliedProbability;
                    forwardProbability += transitionObservationMultipliedProbability * bestPathsUntilPreviousLevel.getNormalizedForwardProbability(previousNode);
                    if (!(probabilityFromStart > bestProbabilityFromStart)) continue;
                    bestProbabilityFromStart = probabilityFromStart;
                    bestPreviousNode = previousNode;
                    bestIntersectedWindRange = (IntersectedWindRange)newWindRangeAndProbability.getA();
                }
                BestManeuverNodeInfo<GraphLevel> currentNodeInfo = bestPathsPerLevel.addBestPreviousNodeInfo(graphNode, bestPreviousNode, bestProbabilityFromStart, bestIntersectedWindRange);
                currentNodeInfo.setForwardProbability(forwardProbability);
            }
            this.bestPathsPerLevel.put(currentLevel, bestPathsPerLevel);
        }
        this.lastLevel = currentLevel;
    }

    public List<GraphLevelInference<GraphLevel>> getBestPath(GraphLevel lastLevel, GraphNode<GraphLevel> lastNode) {
        double probabilitiesSum = 0.0;
        BestPathsPerLevel bestPathsUntilLastLevel = this.bestPathsPerLevel.get(lastLevel);
        double lastNodeProbability = bestPathsUntilLastLevel.getNormalizedProbabilityToNodeFromStart(lastNode);
        if (this.preciseConfidence) {
            if (!bestPathsUntilLastLevel.isBackwardProbabilitiesComputed()) {
                this.computeBackwardProbabilities();
            }
            GraphLevel firstLevel = lastLevel;
            while (firstLevel.getPreviousLevel() != null) {
                firstLevel = firstLevel.getPreviousLevel();
            }
            probabilitiesSum = bestPathsUntilLastLevel.getForwardProbabilitiesSum();
        } else {
            for (GraphNode node : lastLevel.getLevelNodes()) {
                double probability = bestPathsUntilLastLevel.getNormalizedProbabilityToNodeFromStart(node);
                probabilitiesSum += probability;
            }
        }
        LinkedList<GraphLevelInference<GraphLevel>> result = new LinkedList<GraphLevelInference<GraphLevel>>();
        GraphNode<GraphLevel> currentNode = lastNode;
        GraphLevel currentLevel = lastLevel;
        while (currentLevel != null) {
            BestPathsPerLevel currentLevelInfo = this.bestPathsPerLevel.get(currentLevel);
            BestNodeInfo currentNodeInfo = currentLevelInfo.getBestPreviousNodeInfo((GraphNode)currentNode);
            double nodeConfidence = this.preciseConfidence ? currentLevelInfo.getNormalizedForwardBackwardProbability(currentNode) : lastNodeProbability / probabilitiesSum;
            GraphLevelInference<GraphLevel> entry = new GraphLevelInference<GraphLevel>(currentNode, nodeConfidence);
            result.add(0, entry);
            currentNode = ((BestManeuverNodeInfo)currentNodeInfo).getBestPreviousNode();
            currentLevel = currentLevel.getPreviousLevel();
        }
        return result;
    }

    public List<GraphLevelInference<GraphLevel>> getBestPath(GraphLevel lastLevel) {
        BestPathsPerLevel bestPathsUntilLevel = this.bestPathsPerLevel.get(lastLevel);
        double maxProbability = 0.0;
        GraphNode bestLastNode = null;
        for (GraphNode lastNode : lastLevel.getLevelNodes()) {
            double probability = bestPathsUntilLevel.getNormalizedProbabilityToNodeFromStart(lastNode);
            if (!(maxProbability < probability)) continue;
            maxProbability = probability;
            bestLastNode = lastNode;
        }
        return this.getBestPath(lastLevel, bestLastNode);
    }

    public boolean isPreciseConfidence() {
        return this.preciseConfidence;
    }

    public void computeBackwardProbabilities() {
        GraphLevel currentLevel = this.lastLevel;
        BestPathsPerLevel bestPathsUntilLastLevel = this.bestPathsPerLevel.get(currentLevel);
        for (GraphNode currentNode : currentLevel.getLevelNodes()) {
            BestNodeInfo currentNodeInfo = bestPathsUntilLastLevel.getBestPreviousNodeInfo(currentNode);
            currentNodeInfo.setBackwardProbability(1.0);
        }
        GraphLevel nextLevel = currentLevel;
        while ((currentLevel = currentLevel.getPreviousLevel()) != null) {
            BestPathsPerLevel bestPathsUntilLevel = this.bestPathsPerLevel.get(currentLevel);
            BestPathsPerLevel bestPathsUntilNextLevel = this.bestPathsPerLevel.get(nextLevel);
            for (GraphNode currentNode : currentLevel.getLevelNodes()) {
                BestNodeInfo currentNodeInfo = bestPathsUntilLevel.getBestPreviousNodeInfo(currentNode);
                double backwardProbability = 0.0;
                for (GraphNode nextNode : nextLevel.getLevelNodes()) {
                    Util.Pair<IntersectedWindRange, Double> newWindRangeAndProbability = this.transitionProbabilitiesCalculator.mergeWindRangeAndGetTransitionProbability(currentNode, currentLevel, currentNodeInfo.getIntersectedWindRange(), nextNode, nextLevel);
                    backwardProbability += nextNode.getConfidence() * (Double)newWindRangeAndProbability.getB() * bestPathsUntilNextLevel.getNormalizedBackwardProbability(nextNode);
                }
                currentNodeInfo.setBackwardProbability(backwardProbability);
            }
            nextLevel = currentLevel;
        }
    }
}

